!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!=========================================================================

category: 'Index Query Support'
set compile_env: 0
method: Array
buildGsQueryParserNodeFor: aGsQueryParser
  | receiverNode messages |
  receiverNode := self at: 1.
  messages := self at: 2.
  aGsQueryParser build: receiverNode messages: messages
%
category: 'Testing'
set compile_env: 0
method: Array
_literalEqual: anotherLiteral
  "For two literals to be _literalEqual, their class must be identical and  
   otherwise equal"

  self class == anotherLiteral class
    ifFalse: [ ^ false ].
  self size == anotherLiteral size
    ifFalse: [ ^ false ].
  self
    with: anotherLiteral
    do: [ :e1 :e2 | 
      (e1 _literalEqual: e2)
        ifFalse: [ ^ false ] ].
  ^ true
%
category: 'Testing'
method: Array
_refersToLiteral: literal
  "Answer true if literal is identical to any literal in receiver, even if imbedded 
   in further structures."  
  1 to: self size do: [ :index | 
    | lit |
    (literal _literalEqual: (lit := self at: index))
      ifTrue: [ ^ true ].
    (lit _refersToLiteral: literal)
      ifTrue: [ ^ true ] ].
  ^ false
%
! fix 47102
category: 'Testing'
method: Array
_refersToNonSymbolLiteral: argLiteral
  "Answer true if literal is equivalent to any non-symbol element of receiver. 
   Used by ClassOrganizer. 
   If literal is a SymbolAssociation, the value of literal is used.
   If literal is an Array,  elements of literal are searched ." 
  | argVal argInvariant argKey aLit mySize |
  mySize := self size .
  mySize > 0 ifTrue:[
    argInvariant := false .
    (argLiteral isKindOfClass: SymbolAssociation) ifTrue:[
      argKey := argLiteral key .
      argVal := argLiteral _value .
    ].
    1 to: mySize do: [ :index | 
      (aLit := self at: index ) _isSymbol ifFalse:[
        (aLit _literalEqual: argLiteral ) ifTrue: [ ^ true ].
        argVal ifNotNil:[ (aLit _literalEqual: argVal) ifTrue:[ ^ true ]].
        aLit _isArray ifTrue:[ 
          (aLit _refersToNonSymbolLiteral: argLiteral) ifTrue: [ ^ true ] 
        ] ifFalse:[
          (aLit isKindOfClass: SymbolAssociation) ifTrue:[ | v |
             v := aLit _value .
             argVal ifNotNil:[ v == argVal ifTrue:[ ^ true]]
                    ifNil:[ v == argLiteral ifTrue:[ ^ true ]].
          ]
        ]
      ]
    ].
  ].
  ^ false
%

