!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   BtreeComparisonForCompare, Object.
!
!=========================================================================

! class created in idxclasses.topaz

category: 'For Documentation Installation only'
removeallmethods BtreeComparisonForCompare
removeallclassmethods BtreeComparisonForCompare

classmethod: BtreeComparisonForCompare
installDocumentation

self comment:
'During btree sort and compare operations (for BtreeNode and subclasses) the exact method
 send for doing comparison operations varies depending upon whether the comparison is for 
 a sort or a query (compare). The class translates the message into a variant for comparing.'.
%

! ------------------- Class methods for BtreeComparisonForCompare
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey equalTo: aValue

^ aKey _idxForCompareEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey greaterThan: aValue

^ aKey _idxForCompareGreaterThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey greaterThanOrEqualTo: aValue

^ aKey _idxForCompareGreaterThanOrEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey lessThan: aValue

^ aKey _idxForCompareLessThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForCompare
compareKey: aKey lessThanOrEqualTo: aValue

^ aKey _idxForCompareLessThanOrEqualTo: aValue
%
category: 'Testing'
classmethod: BtreeComparisonForCompare
satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2
  ^ ((val1 _idxForCompareGreaterThan: val2)
    or: [ (val1 _idxForCompareEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ])
    not
%
! ------------------- Instance methods for BtreeComparisonForCompare
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForCompare
compareKey: aKey equalTo: aValue

^ aKey _idxForCompareEqualTo: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForCompare
compareKey: aKey greaterThan: aValue

^ aKey _idxForCompareGreaterThan: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForCompare
compareKey: aKey greaterThanOrEqualTo: aValue

^ aKey _idxForCompareGreaterThanOrEqualTo: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForCompare
compareKey: aKey lessThan: aValue

^ aKey _idxForCompareLessThan: aValue
%
category: 'Comparison Operators'
set compile_env: 0
method: BtreeComparisonForCompare
compareKey: aKey lessThanOrEqualTo: aValue

^ aKey _idxForCompareLessThanOrEqualTo: aValue
%
category: 'instance creation'
set compile_env: 0
classmethod: BtreeComparisonForCompare
newForComparison: aCollatorOrNil
  ^ aCollatorOrNil
    ifNil: [ self new ]
    ifNotNil: [ :collator | 
      BtreeComparisonForUnicodeCompare new
        collator: collator;
        yourself ]
%
category: 'instance creation'
set compile_env: 0
classmethod: BtreeComparisonForCompare
newForSort: aCollatorOrNil
  ^ aCollatorOrNil
    ifNil: [ BtreeComparisonForSort new ]
    ifNotNil: [ :collator | 
      BtreeComparisonForUnicodeSort new
        collator: collator;
        yourself ]
%
category: 'Testing'
set compile_env: 0
method: BtreeComparisonForCompare
satisfiableQueryGreaterThan: val1 andEquals: bool1 andLessThan: val2 andEquals: bool2
  ^ ((val1 _idxForCompareGreaterThan: val2)
    or: [ (val1 _idxForCompareEqualTo: val2) and: [ (bool1 and: [ bool2 ]) not ] ])
    not
%
category: 'instance creation'
classmethod: BtreeComparisonForCompare
newForComparison
  ^ self new
%
category: 'instance creation'
classmethod: BtreeComparisonForCompare
newForSort
  ^ BtreeComparisonForSort new
%
