!=========================================================================
! Copyright (C) GemTalk Systems 2017-2020.  All Rights Reserved.
!
! $Id: btreeplusclasses.gs 38384 2016-01-08 18:22:36Z lalmarod $
!
! btreeplusclasses.gs  -  class definitions for the gs indexing classes
!
!========================================================================

doit
(IdentityKeyValueDictionary
        subclass: 'BtreePlusTraversalMapDictionary'
        instVarNames: #(  )
        classVars: #(  )
        classInstVars: #(  )
        poolDictionaries: #()
        inDictionary: Globals
        options: #())
                category: 'Btree-PathTerm-Core';
                comment: 'BtreePlusTraversalMapDictionary is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.

Dictionary class for creating reverse lookup map for Btree Plus update operations.';
                immediateInvariant.
true.
%

doit
(Object
        subclass: 'BtreePlusRootObjectMap'
        instVarNames: #( roots traversalMap cumulativeFactor pivotObject pivotPathTerm )
        classVars: #(  )
        classInstVars: #(  )
        poolDictionaries: #()
        inDictionary: Globals
        options: #())
                category: 'Btree-PathTerm-Core';
                comment: 'BtreePlusRootObjectMap is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.

Dictionary class for creating reverse lookup map for Btree Plus update operations.';
                immediateInvariant.
true.
%

doit
(BtreeComparisonForCompare
	subclass: 'BtreeComparisonForIdentity'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Comparison-Core';
		comment: 'BtreeComparisonForIdentity is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.

During btree sort and compare operations (for BtreeNode and subclasses) the exact method
send for doing comparison operations varies depending upon whether the comparison is for 
a sort or a query (compare). The class translates the message into a variant for sorting.';
		immediateInvariant.
true.
%

doit
(BtreeComparisonForSort
	subclass: 'BtreeOptimizedComparison'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Comparison-Core';
		comment: 'BtreeOptimizedComparison is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreeComparisonForSort
	subclass: 'BtreeOptimizedUnicodeComparison'
	instVarNames: #( collator  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Comparison-Core';
		comment: 'BtreeOptimizedUnicodeComparison is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(Object subclass: 'GsIndexedQueryEvaluator'
	instVarNames: #( index doBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Evaluator-Core';
		comment: 'GsIndexedQueryEvaluator is an abstract class that implements the behavior used to 
 evaluate queries against UnordedCollections that have been indexed. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

doit
(GsIndexedQueryEvaluator
	subclass: 'GsIdentityIndexQueryEvaluator'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Evaluator-Core';
		comment: 'GsIdentityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have identity indexes. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

doit
(GsIndexedQueryEvaluator subclass: 'GsEqualityIndexQueryEvaluator'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Evaluator-Core';
		comment: 'GsEqualityIndexQueryEvaluator is a concrete class that implements the behavior used to 
 evaluate queries against UnordedCollections that have equality indexes. This class is
 used in the internal implementation of indexing and should not be modified.';
		immediateInvariant.
true.
%

doit
(Array
	subclass: 'GsAbstractIndex'
	instVarNames: #( nscRoot btreeRoot options isComplete progress comparisonForSort )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Index-Core';
		comment: 'GsAbstractIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsAbstractIndex
	subclass: 'GsIdentityIndex'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Index-Core';
		comment: 'GsIdentityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsAbstractIndex
	subclass: 'GsRangeEqualityIndex'
	instVarNames: #( lastElementClass optimizingComparison )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Index-Core';
		comment: 'GsRangeEqualityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%


doit
(Array
	subclass: 'BtreePlusNode'
	instVarNames: #( rootNode numElements )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusNode
	subclass: 'BtreePlusInteriorNode'
	instVarNames: #( lastValue lastRoot )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusInteriorNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusInteriorNode
	subclass: 'BtreePlusInteriorKeyValueNode'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusInteriorKeyValueNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusInteriorNode
	subclass: 'BtreePlusInteriorKeyValueRootObjectNode'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusInteriorKeyValueRootObjectNode is part of the Indexing and Querying subsystem. 
It implements GemStone internals and is not intended for customer use, by creating instances 
or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusNode
	subclass: 'BtreePlusLeafNode'
	instVarNames: #( previousLeaf nextLeaf )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusLeafNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusLeafNode
	subclass: 'BtreePlusLeafKeyNode'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusLeafKeyNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusLeafNode
	subclass: 'BtreePlusLeafKeyValueNode'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusLeafKeyValueNode is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusLeafNode
	subclass: 'BtreePlusLeafKeyValueRootObjectNode'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusLeafKeyValueRootObjectNode is part of the Indexing and Querying subsystem. 
It implements GemStone internals and is not intended for customer use, by creating instances 
or by subclassing.';
		immediateInvariant.
true.
%

doit
(Object
	subclass: 'BtreePlusNodeAuditor'
	instVarNames: #( auditResultString )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusNodeAuditor is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(Object
	indexableSubclass: 'BtreePlusRoot'
	instVarNames: #( btreeRootNode indexObject )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'BtreePlusRoot is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreePlusRoot
	subclass: 'RcBtreePlusRoot'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Node-Core';
		comment: 'RcBtreePlusRoot is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(Array
	subclass: 'GsPathTerm'
	instVarNames: #( name offset securityPolicies children updateBtree needsDepList requirePathTerms termsRequired nilOnPath )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-PathTerm-Core';
		comment: 'GsPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsPathTerm
	subclass: 'GsCollectionBasedPathTerm'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-PathTerm-Core';
		comment: 'GsCollectionBasedPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsCollectionBasedPathTerm
	subclass: 'GsEnumeratedPathTerm'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-PathTerm-Core';
		comment: 'GsEnumeratedPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsCollectionBasedPathTerm
	subclass: 'GsSetValuedPathTerm'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-PathTerm-Core';
		comment: 'GsSetValuedPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsPathTerm
	subclass: 'GsOptionalPathTerm'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-PathTerm-Core';
		comment: 'GsOptionalPathTerm is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsPathTerm
	subclass: 'GsSelectorPathTerm'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-PathTerm-Core';
		comment: 'GsSelectorPathTerm  is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsPathConstantPredicate
	subclass: 'GsPreparedPathConstantPredicate'
	instVarNames: #( cachedClasses cachedOffsets preparedOperator preparedConstant preparedEvaluator preparedEvaluatorSize )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Query-Core';
		comment: 'GsPreparedPathConstantPredicate is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(GsRangeQueryPredicate
	subclass: 'GsPreparedRangeQueryPredicate'
	instVarNames: #( cachedClasses cachedOffsets preparedOperator1 preparedConstant1 preparedOperator2 preparedConstant2 preparedEvaluator preparedEvaluatorSize )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Query-Core';
		comment: 'GsPreparedRangeQueryPredicate is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

doit
(BtreeQuerySpec
	subclass: 'BtreePlusComparisonQuerySpec'
	instVarNames: #( key opCode selector optimizingComparison )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-QuerySpec-Core';
		comment: 'BtreePlusComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreePlusNode that satisfy a particular query
 based on a comparison of a single set of values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.';
		immediateInvariant.
true.
%

doit
(BtreePlusComparisonQuerySpec
	subclass: 'BtreePlusRangeComparisonQuerySpec'
	instVarNames: #( key2 opCode2 selector2 )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-QuerySpec-Core';
		comment: 'BtreePlusRangeComparisonQuerySpec is an concrete class that implements behavior for handling the double
 dispatching of messages for adding objects from a btreePlusNode that satisfy a particular query
 based on comparisons between two values.

 The implementation for this class and its concrete subclasses is tightly coupled to alogorithms
 implemented in primitives, so these classes should not be modified.';
		immediateInvariant.
true.
%

doit
(BtreePlusRangeComparisonQuerySpec
	subclass: 'BtreePlusUnicodeRangeComparisonQuerySpec'
	instVarNames: #( collator )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-QuerySpec-Core';
		comment: 'BtreePlusUnicodeRangeComparisonQuerySpec is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

doit
(BtreePlusComparisonQuerySpec
	subclass: 'BtreePlusUnicodeComparisonQuerySpec'
	instVarNames: #( collator )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-QuerySpec-Core';
		comment: 'BtreePlusUnicodeComparisonQuerySpec is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.';
		immediateInvariant.
true.
%

doit
(Stream
	subclass: 'BtreePlusReadStream'
	instVarNames: #( currentNode currentIndex currentLastValIndex currentEntrySize endNode endIndex )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Stream-Core';
		comment: 'BtreePlusReadStream supports the composition of query results by providing access
 to a B-tree structure.

 A BtreePlusReadStream can read all the entries of the B-tree one at a time.  Supply
 the root node when you create the stream, and send the ''next'' message to
 read the first node.  Send the ''next'' message repeatedly to iterate over
 the B-tree''s contents, and send the ''atEnd'' message to check if there are
 any more nodes.
';
		immediateInvariant.
true.
%

doit
(BtreePlusReadStream
	subclass: 'BtreePlusGsIndexReadStream'
	instVarNames: #( gsIndex streamQuerySpec optimizedComparison mustCompare )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Stream-Core';
		comment: 'BtreePlusGsIndexReadStream is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing. ';
		immediateInvariant.
true.
%

doit
(BtreePlusGsIndexReadStream 
	subclass: 'BtreePlusGsReversedIndexReadStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Stream-Core';
		comment: 'BtreePlusGsReversedIndexReadStream is part of the Indexing and Querying subsystem. 
It implements GemStone internals and is not intended for customer use, by creating instances 
or by subclassing';
		immediateInvariant.
true.
%

doit
(EqualityIndexSpecification subclass: 'ConstrainedCharacterCollectionIndexSpecification'
  instVarNames: #( collator constraintType)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #())
    category: 'Btree-Index-Core';
    comment: 'ConstrainedCharacterCollectionIndexSpecification is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
    immediateInvariant.
true.
%

doit
(GsRangeEqualityIndex subclass: 'GsConstrainedCharacterCollectionIndex'
  instVarNames: #( collator constraintType )
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #())
    category: 'Btree-Index-Core';
    comment: 'GsConstrainedCharacterCollectionIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
    immediateInvariant.
true.
%

doit
(GsConstrainedCharacterCollectionIndex
	subclass: 'GsUnicodeRangeEqualityIndex'
	instVarNames: #( )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Globals
	options: #())
		category: 'Btree-Index-Core';
		comment: 'GsUnicodeRangeEqualityIndex is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

