!=========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
!=========================================================================
set class CharacterCollection

! recompile some methods with optimized literals
category: 'Non-Printable Characters'
method:
tab
"Appends a tab to the receiver and returns the receiver."

  self addCodePoint: 9 
%


category: '*PetitParser-Core-Converting'
method:
asParser
	"Answer a parser that accepts the receiving string."

	^ PPLiteralSequenceParser on: self
%

category: 'Index Query Support'
method:
asQueryOn: anNsc
  ^ GsQuery fromString: self on: anNsc
%
method:
asCachedQueryOn: anNsc
  ^ GsQuery
    fromString: self
    on: anNsc
    options: GsQueryOptions default + GsQueryOptions cacheQueryResult
%
method:
asCachedQuery
  ^ GsQuery
    fromString: self
    options: GsQueryOptions default + GsQueryOptions cacheQueryResult
%
method:
asQuery
  ^ GsQuery fromString: self
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareEqualToUnicode: aUnicodeString collator: anIcuCollator
"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ (aUnicodeString compareTo: self collator: anIcuCollator useMinSize: 900)
    == 0
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareGreaterThanUnicode: aUnicodeString collator: anIcuCollator
 
"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThan:collator:. Note that aUnicodeString should be the receiver in any > comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == 1
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareGreaterThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any >= comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) >= 0
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareLessThanUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThan:collator:. Note that aUnicodeString should be the receiver in any < comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == -1
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareLessThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any <= comparison"

  ^ (aUnicodeString
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) <= 0
%
category: 'New Indexing Comparison - for Sort'
method:
_idxForSortEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortEqualTo:collator:."

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == 0
%
category: 'New Indexing Comparison - for Sort'
method:
_idxForSortGreaterThanCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThan:collator:. Note that aCharacterCollection should be the receiver in any > comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == 1
%
category: 'New Indexing Comparison - for Sort'
method:
_idxForSortGreaterThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any >= comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) >= 0
%
category: 'New Indexing Comparison - for Sort'
method:
_idxForSortLessThanCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThan:collator:. Note that aCharacterCollection should be the receiver in any < comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) == -1
%
category: 'New Indexing Comparison - for Sort'
method:
_idxForSortLessThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any <= comparison"

  ^ (aCharacterCollection
    compareTo: self
    collator: anIcuCollator
    useMinSize: 900) <= 0
%
category: 'New Indexing Comparison'
method:
_idxForSortEqualToSymbol: aSymbol
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ self _idxPrimCompareEqualTo: aSymbol asString
%
category: 'New Indexing Comparison'
method:
_idxForCompareEqualToCharacterCollection: arg
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ self _idxPrimCompareEqualTo: arg
%
category: 'Indexing Support'
classmethod:
_idxCanOptimizeComparison
  "Answer true if it is possible to optimize index-related comparisons by replacing
   _idxForCompare* calles with a primitive comparison call instead.

     _idxForCompareEqualTo:              #=
     _idxForCompareGreaterThan:          #>
     _idxForCompareGreaterThanOrEqualTo: #>=
     _idxForCompareLessThan:             #<
     _idxForCompareLessThanOrEqualTo:    #<=
     _idxForCompareNotEqualTo:           #~=
   "

  "In order to optimize Numeric comparisons, NANs (#_isNaN is true) must be excluded 
   from indexed collection"


  "In order to optimize CharacterCollection comparisons, elements of the indexed collections
   must be all Symbols or all Unicode Strings." 

  ^ true
%
category: 'Indexing Support'
method:
_idxOptimizedCompareWithClass: aClass
  "Returns true if the receiver may be inserted into a BtreePlusNode whose 
   #lastElementClass is <aClass> and whose comparisons are optimized."

  "Sent when index option optimizeComparison is true and aClass responds true to #_idxCanOptimizeComparison"

  "if aClass is Symbol, DoubleByteSymbol, or QuadByteSymbol the receiver must be a symbol.
   Otherwise the receiver must not be a Symbol. "

  self class == aClass ifTrue: [ ^ true ].
  (self _idxBasicCanCompareWithClass: aClass) 
    ifFalse: [ 
        "If using Unicode compares, then *String and Unicode* instances may be compared.
         If not using Unicode compares then *String and Unicode* instances may not be compared."
      ^ false ].
  ({Symbol. DoubleByteSymbol. QuadByteSymbol} includes: aClass)
    ifTrue: [ ^ self _isSymbol ].
  ^self _isSymbol not
%

category: 'Converting'
method:
asJISString

"Returns a JISString representation of the receiver."

| selfSize aJISString |

self deprecated: 'CharacterCollection>>asJISString deprecated v3.0.'.
selfSize := self size.
aJISString := JISString new: selfSize.
1 to: selfSize do: [ :i |
  aJISString at: i put: (self at: i) asJISCharacter.
  ].

^ aJISString.
%

