!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!
! $Id: setpathterm.gs 31614 2013-10-09 17:47:16Z dhenrich $
!
! Superclass Hierarchy:
!   CollectionBasedPathTerm, PathTerm, Array, SequenceableCollection, 
!   Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods CollectionBasedPathTerm
removeallclassmethods CollectionBasedPathTerm

category: 'For Documentation Installation only'
classmethod: CollectionBasedPathTerm
installDocumentation

self comment: '
CollectionBasedPathTerm is an abstract superclass for classes that represents a term within an index or query path that
is a collection. 

CollectionBasedPathTerm implements only GemStone internals, and is not intended for direct use
by customers.
'.
%

category: 'Updating Indexes'
set compile_env: 0
method: CollectionBasedPathTerm
addIndexListEntriesFor: nscBag index: indexObj
  "Update the Bag of NSC's index lists."

  | anNsc iList nextOffset |
  nextOffset := offset + 1.
  1 to: nscBag size do: [ :i | 
    " for each NSC in the Bag of NSCs ... update the index list "
    anNsc := nscBag at: i.
    anNsc class isNsc
      ifFalse: [ ^ self _errorPathObjectNotAnNsc: anNsc ].
    iList := anNsc _getIndexList.
    anNsc _putInWriteSet.
    iList addIndex: indexObj withOffset: nextOffset nsc: anNsc ]
%
category: 'Deprecated'
set compile_env: 0
method: CollectionBasedPathTerm
allDependencyListsFor: anNsc into: all
  "Put any dependency lists that can be found from the receiver into the given set."

  self deprecated: 'CollectionBasedPathTerm>>allDependencyListsFor:into: deprecated v3.3.  
    Use DependencyList class>>depMapValues to collect dependency lists.'.  "bug 43886"
  self subclassResponsibility: #'allDependencyListsFor:into:'
%
category: 'Updating Indexes'
set compile_env: 0
method: CollectionBasedPathTerm
cleanupDependencyListFor: anNsc
  ""

  self subclassResponsibility: #'cleanupDependencyListFor:'
%
category: 'Updating Indexes'
set compile_env: 0
method: CollectionBasedPathTerm
getMappingInfoFor: anObject ifObject: origObject atOffset: origOffset replaceWith: otherObject
  "Gathers all the objects, their dependency lists, and the instance variable
 offset for each path term in the tree of path terms.  Puts them in a
 MappingInfo object.  Builds a tree of MappingInfo objects for each child path
 term.

 It is possible that this method is invoked due to an instance variable
 modification.  In that case, we want to traverse the path terms as if the
 modification had occurred.  Thus, if anObject is the one that was modified
 (that is, if it is identical to origObject) and the instance variable offset of
 this path term is the same instance variable offset that was modified (that is,
 it is equal to origOffset), then rather than getting the next object along the
 path, use the otherObject."

  self
    subclassResponsibility: #'getMappingInfoFor:ifObject:atOffset:replaceWith:'
%
category: 'Testing'
set compile_env: 0
method: CollectionBasedPathTerm
indicatesMultiValue
  "Returns true, the receiver indicates that the index is on an
 instance variable that may have multiple values (i.e., collection based path term)"

  ^ true
%
category: 'Updating Indexes'
set compile_env: 0
method: CollectionBasedPathTerm
removeIndexListEntriesFor: nscBag index: indexObj
  "Update the Bag of NSC's index lists."

  | anNsc iList nextOffset |
  nextOffset := offset + 1.	" for each NSC in the Bag of NSCs ... "
  1 to: nscBag size do: [ :i | 
    anNsc := nscBag at: i.
    iList := anNsc _getIndexList.
    anNsc _putInWriteSet.	" update the index list "
    iList removeIndex: indexObj withOffset: nextOffset for: anNsc ]
%
category: 'Updating Indexes'
set compile_env: 0
method: CollectionBasedPathTerm
removeMappingsFor: anObject lastOne: aBoolean logging: doLogging
  "Remove entries in the index dictionary and dependency lists for anObject."

  self subclassResponsibility: #'removeMappingsFor:lastOne:logging:'
%
category: 'Accessing'
set compile_env: 0
method: CollectionBasedPathTerm
nextObj: anObj do: aBlock
  self subclassResponsibility: #'nextObj:do:'
%
category: 'Testing'
set compile_env: 0
method: CollectionBasedPathTerm
isCollectionBasedTerm
  "Returns true if the receiver is an enumerated path term or a term that indicates a 
   set-valued instance variable."

  ^ true
%
category: 'Indexing Support'
method: CollectionBasedPathTerm
_updateCollectionBasedIndexFor: anIndex on: anNsc offset: anOffset addingIndex: addingIndex
  "noop by default"

  
%
category: 'Deprecated'
method: CollectionBasedPathTerm
auditObject: obj occurrences: num on: aString builder: nscBuilder
  "called by UnorderedCollection>>_incrementalAuditIndexes:to: and not this type of 
   old audit not supported for collection-based pathterms"

  self shouldNotImplement: #'auditObject:occurrences:on:builder:'
%
category: 'Accessing'
method: CollectionBasedPathTerm
_nextObjectFor: anObject
  "Cannot use this shortcut method"

  self shouldNotImplement: #'_nextObjectFor:'
%
category: 'Accessing'
method: CollectionBasedPathTerm
requirePathTerms
  requirePathTerms ifNil: [ ^ true ].
  ^ requirePathTerms
%
category: 'Accessing'
method: CollectionBasedPathTerm
requirePathTerms: aBool
  requirePathTerms := aBool
%
category: 'Error Handling'
method: CollectionBasedPathTerm
_errorPathObjectNotAnNsc: anObject
  "An object traversed along an index path through a set-valued instance
 variable was not an NSC."

  ImproperOperation new
    reason: #'rtErrPathTermObjectNotAnNsc';
    object: anObject;
    details: 'Expected an UnorderedCollection';
    signal
%
category: 'Testing'
method: CollectionBasedPathTerm
termsRequired
  "Answer true if receiver requires that instance variables of indexed objects are present "

  ^ self requirePathTerms
%
