!=========================================================================
! Copyright (C) GemTalk Systems 2019-2020.  All Rights Reserved.

! File:  dnuErrorMethod.gs
!  used in Object, PrivateObject, UnauthorizedObjectStub 
!=========================================================================

category 'Private'
method:
_dnuError: aSymbol args: anArray reason: dnuKind
 "dnuKind constants must agree with  DNU_ constants in om.hf .
  Not using class variables for DNU_* to avoid polluting name space of Object. "
 | err |
 err := InternalError new .
 dnuKind _isSmallInteger ifTrue:[
   dnuKind == 1 ifTrue:[ 
     err details: 'method needs recompile, receiver a ',
	  self class name , ' , selector #', aSymbol  ;
	   tag: { self . aSymbol }.
   ] ifFalse:[
     dnuKind == 2 ifTrue:[ err details: 'method load error DNU_failure2' ].
     dnuKind == 3 ifTrue:[ err details: 'method load error DNU_failure3' ].
     dnuKind == 4 ifTrue:[ err details: 'method is not invariant' ].
     dnuKind == 5 ifTrue:[ err details: 'method load error DNU_largeLeafMissing'].
     dnuKind == 6 ifTrue:[ err details:'method load error DNU_badExtrasSize' ].
     dnuKind == 7 ifTrue:[ err details:'method load error DNU_methodDoesNotExist' ].
     err tag:{ self . aSymbol . anArray }.
   ].
 ] ifFalse:[
   err details: 'method oop:' , dnuKind asOop asString, ' needs recompile, receiver a ',
	  self class name , ' , selector #', aSymbol  ;
	   tag: { self . aSymbol }.
 ].
 ^ err signal .
%

method: 
_doesNotUnderstand: aSymbol args: anArray envId: aSmallInt reason: dnuKind
  "This private message is sent by the virtual machine. The implementation must
 be in the persistent method dictionary for Object, since the method is preloaded
 during VM startup.  Reimplementations in a session methods dictionary will not
 be seen."

  dnuKind ~~ 0 ifTrue: [
    "a more severe problem such as method needing recompile"
    self _dnuError: aSymbol args: anArray reason: dnuKind
  ].
  aSmallInt == 0 ifTrue:[
     "this path for compatibility with Gs64 v2.x, and assumes you are using
      only method environment 0  for all of your Smalltalk code."
      ^self doesNotUnderstand: (Message selector: aSymbol arguments: anArray)
  ].
  ^self doesNotUnderstand: aSymbol args: anArray envId: aSmallInt
%

