!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
!=========================================================================


set class GsNMethod
category: 'Debugging Support'
method:
_setBreakAtIp: ipOffset operation: opcFlags frame: fpOffset process: aGsProcess

"Set breakpoint at specified ipOffset.  ipOffset is an instruction offset,
 which is a absolute byte offset within the receiver.

 Checks that the receiver is not part of the implementation of the scheduler.

 opcFlags is a SmallInteger , fields have these masks
    opcode 		   16rFF
    includeMethodStartBcs 16r100 , a Boolean , only affects opcode==1
        when ipOffset == -1 .

 opcode  action
   0	 set or reenable method breakpoint
   1     set single step breakpoint (takes precedence over method break)
   2     delete method breakpoint or disabled method breakpoint
   3     delete single step breakpoint
   4     disable method breakpoint, no action if breakpoint not set

  If ipOffset == -1, then apply the action to all step points within the
  method.  

  For opcode 1 only, to restrict breakpoint to a specific frame 
  and/or GsProcess , fpOffset and/or aGsProcess must be non-nil. "

(Processor _scheduler _criticalMethods includes: self) ifTrue:[
  ^ Error signal:'cannot set breakpoints within the ProcessorScheduler'
].
^ self __setBreakAtIp: ipOffset operation: opcFlags frame: fpOffset process: aGsProcess
%

! fix 46519
category: 'Repository Conversion'
method: 
_literalValToAssocations: aValue
  "Returns a SymbolAssocation or an Array of SymbolAssocations
   thus returning all associations from the current symbolList whose value is
   identical to aValue.  If there are multiple qualifying associations 
   with identical keys, the first association found with a given key is included 
   in the result."
  | reverseDict tmps |
  reverseDict := (tmps := SessionTemps current) at: #GsRecompileValuesToKeys ifAbsent:[
    tmps at: #GsRecompileValuesToKeys put: IdentityDictionary new
  ].
  ^ reverseDict at: aValue ifAbsent:[ | keys values |
     keys := IdentitySet new .  values := { } .
     GsSession currentSession symbolList do:[ :symd |
       symd associationsDo:[ :assoc |
         (assoc value == aValue and:[ (keys includes: assoc key) == false]) ifTrue:[
           keys add: assoc key .
           values add: assoc.
         ]
       ].
     ].
     values size == 0 ifTrue:[ |vCls |
       ((vCls := aValue class) == ByteArray 
           or:[ (vCls == Array and:[ aValue isInvariant])
           or:[ (aValue isKindOf: String) and:[ aValue isInvariant]]]) ifFalse:[
         Warning signal: 'cannot find key for optimized literal value oop ' ,
            aValue asOop asString , ' (a ' , aValue class name, ')' .
       ]
     ].
     ^ reverseDict at: aValue put: (values size == 1 ifTrue:[ values at: 1] ifFalse:[ values]).
  ]
%

