!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   GsSessionMethodDictionary, GsMethodDictionary, 
!     IdentityKeyValueDictionary, KeyValueDictionary, AbstractDictionary
!       Collection, Object
!       
!
!=========================================================================
expectvalue false
run
"temporarily allow subclasses to handle repository upgrade"
| oldFmt |
GsMethodDictionary subclassesDisallowed ifTrue:[
  oldFmt := GsMethodDictionary format .
  GsMethodDictionary _unsafeAt: 2 "offset of format"
     put: (oldFmt bitXor:32"subclasses disallowed bit" ).
  ].
^ GsMethodDictionary subclassesDisallowed 
%

expectvalue %String
run
  GsMethodDictionary _newKernelSubclass: 'GsSessionMethodDictionary'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
      options: #()
    reservedOop: 987
%

expectvalue true
run
" restore subclasses disallowed bit to 1 "
| oldFmt |
oldFmt := GsMethodDictionary format .
GsMethodDictionary _unsafeAt: 2 "offset of format"
   put: (oldFmt bitOr:32"subclasses disallowed bit" ) .
^ GsMethodDictionary subclassesDisallowed
%

removeallmethods GsSessionMethodDictionary
removeallclassmethods GsSessionMethodDictionary

category: 'For Documentation Installation only'
classmethod: GsSessionMethodDictionary
installDocumentation

self comment:
'GsSessionMethodDictionary is a subclass of GsMethodDictionary to be used
 for storing session methods. The keys of this class are expected to be a 
 Behavior and keys are GsMethodDictionaries.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
	valueConstraint: Behavior
	keyConstraint: Behavior' .
%

! ------------------- Class methods for GsSessionMethodDictionary
! ------------------- Instance methods for GsSessionMethodDictionary
category: 'Updating'
method: GsSessionMethodDictionary
at: anIndex put: aValue

	<protected>
	^super at: anIndex put: aValue
%
category: 'Hashing'
method: GsSessionMethodDictionary
hashFunction: aKey

	<protected>
	^super hashFunction: aKey
%
category: 'Initializing'
method: GsSessionMethodDictionary
initialize: itsSize

	<protected>
	^super initialize: itsSize
%
category: 'Updating'
method: GsSessionMethodDictionary
instVarAt: anIndex put: aValue

	<protected>
	^super instVarAt: anIndex put: aValue
%
category: 'Updating'
method: GsSessionMethodDictionary
keyConstraint: aClass

	<protected>
	^super keyConstraint: aClass
%
category: 'Hashing'
method: GsSessionMethodDictionary
rebuildTable: newSize

	<protected>
	^super rebuildTable: newSize
%
category: 'Updating'
method: GsSessionMethodDictionary
size: anInteger

	<protected>
	^super size: anInteger
%
category: 'Updating'
method: GsSessionMethodDictionary
valueConstraint: aClass

	<protected>
	^super valueConstraint: aClass
%
category: 'Updating'
method: GsSessionMethodDictionary
_at: anIndex put: aValue

	<protected>
	^super _at: anIndex put: aValue
%
category: 'Updating'
method: GsSessionMethodDictionary
_basicAt: anIndex put: aValue

	<protected>
	^super _basicAt: anIndex put: aValue
%
category: 'Updating'
method: GsSessionMethodDictionary
squeakBasicAt: anIndex put: aValue

  ^ self _basicAt: anIndex put: aValue
%

category: 'Updating'
method: GsSessionMethodDictionary
_basicSize: anInteger

	<protected>
	^super _basicSize: anInteger
%
category: 'Updating'
method: GsSessionMethodDictionary
_primitiveAt: anIndex put: aValue

	<protected>
	^super _primitiveAt: anIndex put: aValue
%
category: 'Updating'
method: GsSessionMethodDictionary
_atKey: aKey put: aValue

	<protected>
	^ super _atKey: aKey put: aValue
%

category: 'Instance Migration'
method: GsSessionMethodDictionary
_unsafeAt: anIndex put: aValue

	<protected>
	^super _unsafeAt: anIndex put: aValue
%
