!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================
removeallmethods ObsLargePositiveInteger
removeallclassmethods ObsLargePositiveInteger

category: 'Documentation'
classmethod: ObsLargePositiveInteger
comment
^ ' 
 Instances of ObsLargePositiveInteger represent positive integers whose values are
 greater than the maximum SmallInteger.  Each instance of ObsLargePositiveInteger 
 is stored as an Array of bytes, where each double-byte pair represents a 
 base 32768 digit.  The first two bytes in that Array constitute the least 
 significant base 32768 digit, and the last two bytes are the most significant 
 base 32768 digit.  Within each digit, the least significant byte is first, 
 followed by the more significant byte.

 The superclass of ObsLargePositiveInteger is Object, the only method
 supported is #convert .

 All instances are mutated in a read-only manner on fault into VM memory 
 to be instances of LargePositiveInteger.  Send #convert to the instance to
 cause it to be written by the current transaction as an instance
 of LargePositiveInteger. 
 See also Number>>convert .
'
%

