category: 'archive operations'
method: Archive
addTree: aFileNameOrDirectory removingFirstCharacters: n match: aBlock
	| dir baseDir relativeDir |
	dir := (aFileNameOrDirectory isString)
		ifTrue: [ FSDiskFilesystem pathFromString: aFileNameOrDirectory ]
		ifFalse: [ aFileNameOrDirectory ].
	baseDir := FSDiskFilesystem pathFromString: (dir printString copyFrom: 1 to: n - 1).
	relativeDir := dir relativeToPath: baseDir.
	(dir asReference children select: [ :entry | true])
		do: [ :reference | | newEntry newMember |
		newEntry := dir / reference basename.
		newMember := reference isDirectory
				ifTrue: [ self memberClass newFromDirectory: newEntry ]
				ifFalse: [ self memberClass newFromFile: newEntry ].
		newMember localFileName: (relativeDir / reference basename) printString.
		self addMember: newMember.
		reference isDirectory ifTrue: [ self addTree: newEntry removingFirstCharacters: n match: aBlock].
	].

%
run
Archive setStamp: 'eem 6/11/2008 12:47' forMethod: #addTree:removingFirstCharacters:match:.
true
%
category: 'archive operations'
method: Archive
extractMember: aMemberOrName
	| member |
	member := self member: aMemberOrName.
	member ifNil: [ ^nil ].
	member extractToFileNamed: member localFileName inDirectory: FSDiskFilesystem pwd.
%
run
Archive setStamp: 'nk 12/20/2002 14:48' forMethod: #extractMember:.
true
%
category: 'archive operations'
method: Archive
extractMemberWithoutPath: aMemberOrName
	self extractMemberWithoutPath: aMemberOrName inDirectory: FSDiskFilesystem pwd.
%
run
Archive setStamp: 'nk 11/11/2002 14:09' forMethod: #extractMemberWithoutPath:.
true
%

category: 'archive operations'
method: Archive
extractMemberWithoutPath: aMemberOrName inDirectory: dir
	| member |
	member := self member: aMemberOrName.
	member ifNil: [ ^nil ].
	member extractToFileNamed: (FSDiskFilesystem pathFromString: member localFileName) basename inDirectory: dir
%
run
Archive setStamp: 'nk 12/20/2002 14:48' forMethod: #extractMemberWithoutPath:inDirectory:.
true
%

category: 'extraction'
method: ZipArchiveMember
extractToFileNamed: aFileName
	self extractToFileNamed: aFileName inDirectory: FSDiskFilesystem pwd.
%
run
ZipArchiveMember setStamp: 'nk 11/11/2002 14:08' forMethod: #extractToFileNamed:.
true
%

category: 'accessing'
method: ZipDirectoryMember
localFileName: aString
	| entry parent |
	super localFileName: aString.
	parent := FSDiskFilesystem pwd.
	(parent directoryExists: fileName) ifTrue: [
		entry := parent entryAt: fileName.
		self setLastModFileDateTimeFrom: entry modificationSeconds
	]
%
run
ZipDirectoryMember setStamp: 'nk 12/20/2002 14:45' forMethod: #localFileName:.
true
%

category: 'testing'
method: ZipFileMember
usesFileNamed: aFileName
	"Do I require aFileName? That is, do I care if it's clobbered?"
	^(FSPath readFrom: externalFileName readStream delimiter: $/) = (FSDiskFilesystem pwd resolveString: aFileName)
%
run
ZipFileMember setStamp: 'nk 2/24/2001 14:07' forMethod: #usesFileNamed:.
true
%

category: 'testing'
method: ZipNewFileMember
usesFileNamed: aFileName
	"Do I require aFileName? That is, do I care if it's clobbered?"
	^(FSPath readFrom: externalFileName readStream delimiter: $/) = (FSDiskFilesystem pwd resolveString: aFileName)
%
run
ZipNewFileMember setStamp: 'nk 2/24/2001 15:03' forMethod: #usesFileNamed:.
true
%

category: 'accessing'
method: ZipArchiveMember
localFileName
	"Answer my fileName in terms of the local directory naming convention"
	^(FSPath readFrom: fileName readStream delimiter: $/) asReference printString
%
run
ZipArchiveMember setStamp: 'nk 3/13/2003 09:23' forMethod: #localFileName.
true
%
