"
No class-specific documentation for HostAgentConfig, hierarchy is: 
Object
  HostAgentConfig( portRange)

"
Class {
	#name : 'HostAgentConfig',
	#superclass : 'Object',
	#instVars : Array [
    'inheritedFd',
    'inheritedSsl',
		'leafLdiFd',
		'leafLdiSsl',
		'localIpAddress',
		'portRange',
		'remoteHostId',
		'localHostId',
    'stoneIpString'
	],
	#category : 'X509-HostAgent'
}

{ #category : 'instance creation' }
HostAgentConfig class >> retrieveFromSessionState: isMidCacheAgent withDebugLevel: aSymbol [

	^(self new) initializeFromSessionState: isMidCacheAgent debugLevel: aSymbol
]

{ #category : 'accessing' }
HostAgentConfig >> cacheHostId [

	^ remoteHostId ~~ 0 ifTrue:[ remoteHostId ] ifFalse:[ localHostId ]
]

{ #category : 'accessing' }
HostAgentConfig >> stoneIpString [
	^ stoneIpString
]

{ #category : 'primitives' }
HostAgentConfig >> connectToLeafHost: isMidCacheAgent withDebugLevel: aSymbol [
  "Connects to the leaf host netldi, gets leafHostId from that netldi .
   Fetches various values embedded in gem session state or hostagent commandline.

   Returns an Array { clientPort . lowPort. highPort. clientFd. clientHostId .
                      leafNetldiFd .
                      CPointer to the LgcSslState.ssl leafNetldi connection }
   or Returns a String with error details
  "
	<primitive: 1051>
	isMidCacheAgent _validateClass: Boolean .
	aSymbol _validateClass: Symbol .
	self _primitiveFailed: #connectToLeafHost: args: { isMidCacheAgent } .
]

{ #category : 'validation' }
HostAgentConfig >> validateTimeout: aSeconds [
	| max min |
	aSeconds _validateClass: SmallInteger.
	max := 36000 . min := 1 .
	(aSeconds  between: min and: max)
		ifFalse: 
			[(OutOfRange new)
				name: 'timeout'
					min: min
					max: max
					actual: aSeconds ;
				signal]
]

{ #category : 'initialization' }
HostAgentConfig >> getLocalIpAddress [
	"inheritedFd is an open file descriptor. 
   Figure out what IP address is its local IP, and cache that value."

  inheritedFd > 0 ifTrue:[ | socket |
	  socket := GsSignalingSocket fromFileHandle: inheritedFd.
	  localIpAddress := socket address
  ] ifFalse:[
    "localIpAddress is nil in a hostagent on mid cache"
  ]
]

{ #category : 'initialization' }
HostAgentConfig >> initializeFromSessionState: isMidCacheAgent debugLevel: aSymbol [

	| argsArray |
	argsArray := self connectToLeafHost: isMidCacheAgent withDebugLevel: aSymbol .
	argsArray _isArray ifFalse:[ | errStr |
    errStr := argsArray asString .
    HostAgent replyToStoneNetldi: errStr .
    Error signal: 'connectToLeafHost failed:', errStr .
  ].

	"Port range uses first three args."
	self initializePortRange: argsArray.
	inheritedFd :=   argsArray at: 4.  "0 in a hostagent on mid cache"
	remoteHostId := argsArray at: 5. "0 in a hostagent on mid cache"
	  inheritedSsl := argsArray at: 6.
	leafLdiFd :=    argsArray at: 7.   
	leafLdiSsl :=   argsArray at: 8 .
	localHostId :=  System hostId .
	stoneIpString := argsArray at: 9 . "non-nil only in hostagent on mid cache"
	self getLocalIpAddress
]

{ #category : 'initialization' }
HostAgentConfig >> initializePortRange: argsArray [

	| lowPort highPort netldiPort |
	netldiPort := argsArray at: 1.	"This port is known to be taken, do not listen even if in range."
	lowPort := argsArray at: 2.
	highPort := argsArray at: 3.
	portRange := PortRange
				lowPort: lowPort
				highPort: highPort
				avoidPort: netldiPort
]

{ #category : 'accessing' }
HostAgentConfig >> leafLdiSsl [
  "Returns the SSL of the persistent connection to the leaf host netldi"
	^ leafLdiSsl
]

{ #category : 'accessing' }
HostAgentConfig >> leafLdiFd [
  "Returns file descriptor of the persistent connection to the leaf host netldi"
	^ leafLdiFd
]

{ #category : 'accessing' }
HostAgentConfig >> inheritedSsl [
  "Returns the SSL inherited from the parent netldi that forked this hostagent "
  ^ inheritedSsl
]

{ #category : 'accessing' }
HostAgentConfig >> localIpAddress [

	^localIpAddress
]

{ #category : 'accessing' }
HostAgentConfig >> portRange [

	^portRange
]

{ #category : 'accessing' }
HostAgentConfig >> remoteHostId [

	^remoteHostId
]

