"
No class-specific documentation for LibcFcntl, hierarchy is: 
Object
  LibcFcntl

"
Class {
	#name : 'LibcFcntl',
	#superclass : 'Object',
	#classVars : Array [
		'Functioncreat',
		'Functionfcntl',
		'Functionlockf',
		'Functionopen',
		'Functionopenat',
		'Functionposix_fadvise',
		'Functionposix_fallocate',
		'Function__openat_2',
		'Function__open_2'
	],
	#category : 'X509-HostAgent'
}

{ #category : 'Initializing - private' }
LibcFcntl class >> initialize [

	| library |
	library := nil. "dlsym in-process not CLibrary named: '/lib/libc.so.6'  "
	self
		initializeFunction_creat_inLibrary: library;
		initializeFunction_fcntl_inLibrary: library;
		initializeFunction_lockf_inLibrary: library;
		initializeFunction_open_inLibrary: library;
		initializeFunction_openat_inLibrary: library;
		initializeFunction_posix_fadvise_inLibrary: library;
		initializeFunction_posix_fallocate_inLibrary: library;
		initializeFunction___openat_2_inLibrary: library;
		initializeFunction___open_2_inLibrary: library;
		yourself.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction_creat_inLibrary: cLibrary [

	Functioncreat := CCallout
		library: cLibrary
		name: 'creat'
		result: #'int32'
		args: #(#'const char*' #'uint32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction_fcntl_inLibrary: cLibrary [

	Functionfcntl := CCallout
				library: cLibrary
				name: 'fcntl'
				result: #int32
				args: #(#int32 #int32 #int32)
				varArgsAfter: 2
]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction_lockf_inLibrary: cLibrary [

	Functionlockf := CCallout
		library: cLibrary
		name: 'lockf'
		result: #'int32'
		args: #(#'int32' #'int32' #'int64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction_openat_inLibrary: cLibrary [

	Functionopenat := CCallout
		library: cLibrary
		name: 'openat'
		result: #'int32'
		args: #(#'int32' #'const char*' #'int32')
		varArgsAfter: 3.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction_open_inLibrary: cLibrary [

	Functionopen := CCallout
		library: cLibrary
		name: 'open'
		result: #'int32'
		args: #(#'const char*' #'int32')
		varArgsAfter: 2.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction_posix_fadvise_inLibrary: cLibrary [

	Functionposix_fadvise := CCallout
		library: cLibrary
		name: 'posix_fadvise'
		result: #'int32'
		args: #(#'int32' #'int64' #'int64' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction_posix_fallocate_inLibrary: cLibrary [

	Functionposix_fallocate := CCallout
		library: cLibrary
		name: 'posix_fallocate'
		result: #'int32'
		args: #(#'int32' #'int64' #'int64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction___openat_2_inLibrary: cLibrary [

	Function__openat_2 := CCallout
		library: cLibrary
		name: '__openat_2'
		result: #'int32'
		args: #(#'int32' #'const char*' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcFcntl class >> initializeFunction___open_2_inLibrary: cLibrary [

	Function__open_2 := CCallout
		library: cLibrary
		name: '__open_2'
		result: #'int32'
		args: #(#'const char*' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Functions' }
LibcFcntl >> creat_: __file _: __mode [ 
	"/usr/include/fcntl.h line 225
extern int creat (const char *__file, mode_t __mode) __nonnull ((1));"

	"Interpreted as #int32 from #( #'const char*' #'uint32' )"

	^Functioncreat callWith: { __file. __mode }

]

{ #category : 'Functions' }
LibcFcntl >> fcntl_: __fd _: __cmd [ 
	"/usr/include/fcntl.h line 169
/* Do the file control operation described by CMD on FD.
   The remaining arguments are interpreted depending on CMD.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int fcntl (int __fd, int __cmd, ...);"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionfcntl callWith: { __fd. __cmd"varArgs array should be appended to this array" }

]

{ #category : 'Functions' }
LibcFcntl >> fcntl_: __fd _: __cmd _: arg [
	"/usr/include/fcntl.h line 169
/* Do the file control operation described by CMD on FD.
   The remaining arguments are interpreted depending on CMD.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int fcntl (int __fd, int __cmd, ...);"
	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionfcntl callWith: 
			{__fd.
			__cmd.
			#int32.
			arg}
]

{ #category : 'constants' }
LibcFcntl >> F_GETFL [
	"#define F_GETFL		3	/* Get file status flags.  */"

	^3
]

{ #category : 'constants' }
LibcFcntl >> F_SETFL [
	"#define F_SETFL		4	/* Set file status flags.  */"

	^4
]

{ #category : 'Functions' }
LibcFcntl >> lockf_: __fd _: __cmd _: __len [ 
	"/usr/include/fcntl.h line 254
extern int lockf (int __fd, int __cmd, off_t __len);"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int64' )"

	^Functionlockf callWith: { __fd. __cmd. __len }

]

{ #category : 'Functions' }
LibcFcntl >> openat_: __fd _: __file _: __oflag [ 
	"/usr/include/fcntl.h line 203
extern int openat (int __fd, const char *__file, int __oflag, ...)
     __nonnull ((2));"

	"Interpreted as #int32 from #( #'int32' #'const char*' #'int32' )"

	^Functionopenat callWith: { __fd. __file. __oflag"varArgs array should be appended to this array" }

]

{ #category : 'Functions' }
LibcFcntl >> open_: __file _: __oflag [ 
	"/usr/include/fcntl.h line 179
extern int open (const char *__file, int __oflag, ...) __nonnull ((1));"

	"Interpreted as #int32 from #( #'const char*' #'int32' )"

	^Functionopen callWith: { __file. __oflag"varArgs array should be appended to this array" }

]

{ #category : 'constants' }
LibcFcntl >> O_NONBLOCK [
	"# define O_NONBLOCK	  04000"

	^8r04000
]

{ #category : 'Functions' }
LibcFcntl >> posix_fadvise_: __fd _: __offset _: __len _: __advise [ 
	"/usr/include/fcntl.h line 271
extern int posix_fadvise (int __fd, off_t __offset, off_t __len,
			  int __advise) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int64' #'int64' #'int32' )"

	^Functionposix_fadvise callWith: { __fd. __offset. __len. __advise }

]

{ #category : 'Functions' }
LibcFcntl >> posix_fallocate_: __fd _: __offset _: __len [ 
	"/usr/include/fcntl.h line 293
extern int posix_fallocate (int __fd, off_t __offset, off_t __len);"

	"Interpreted as #int32 from #( #'int32' #'int64' #'int64' )"

	^Functionposix_fallocate callWith: { __fd. __offset. __len }

]

{ #category : 'Functions' }
LibcFcntl >> __openat_2_: __fd _: __path _: __oflag [ 
	"/usr/include/bits/fcntl2.h line 95
extern int __openat_2 (int __fd, const char *__path, int __oflag)
     __nonnull ((2));"

	"Interpreted as #int32 from #( #'int32' #'const char*' #'int32' )"

	^Function__openat_2 callWith: { __fd. __path. __oflag }

]

{ #category : 'Functions' }
LibcFcntl >> __open_2_: __path _: __oflag [ 
	"/usr/include/bits/fcntl2.h line 26
extern int __open_2 (const char *__path, int __oflag) __nonnull ((1));"

	"Interpreted as #int32 from #( #'const char*' #'int32' )"

	^Function__open_2 callWith: { __path. __oflag }

]
