"
No class-specific documentation for LibcSocket, hierarchy is: 
Object
  LibcSocket

"
Class {
	#name : 'LibcSocket',
	#superclass : 'Object',
	#classVars : Array [
		'Functionaccept',
		'Functionbind',
		'Functionconnect',
		'Functiongetpeername',
		'Functiongetsockname',
		'Functiongetsockopt',
		'Functiongnu_dev_major',
		'Functiongnu_dev_makedev',
		'Functiongnu_dev_minor',
		'Functionisfdtype',
		'Functionlisten',
		'Functionpreadv',
		'Functionpselect',
		'Functionpwritev',
		'Functionreadv',
		'Functionrecv',
		'Functionrecvfrom',
		'Functionrecvmsg',
		'Functionselect',
		'Functionsend',
		'Functionsendmsg',
		'Functionsendto',
		'Functionsetsockopt',
		'Functionshutdown',
		'Functionsockatmark',
		'Functionsocket',
		'Functionsocketpair',
		'Functionwritev',
		'Function__cmsg_nxthdr',
		'Function__fdelt_chk',
		'Function__fdelt_warn',
		'Function__recvfrom_chk',
		'Function__recv_chk'
	],
	#category : 'X509-HostAgent'
}

{ #category : 'Constants' }
LibcSocket class >> af_inet [

	^2
]

{ #category : 'Constants' }
LibcSocket class >> af_inet6 [
  | cpuOs |
  cpuOs := GsProcess cpuOsKind .
  cpuOs == 3 ifTrue:[ ^10 "x86_64 linux" ].
  (cpuOs == 2 or:[ cpuOs == 6 ]) ifTrue:[ ^ 26 "solaris" ].
  cpuOs == 4 ifTrue:[ ^ 24 "AIX" ].
  cpuOs == 5 ifTrue:[ ^ 30 "Darwin"].
  Error signal:'unknown cpuOs ' , cpuOs asString .
]

{ #category : 'Initializing - private' }
LibcSocket class >> initialize [

	self initializeFunctions
]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunctions [

	| library |
	library := nil.	"Libc should already be loaded."
	self
		initializeFunction_accept_inLibrary: library;
		initializeFunction_bind_inLibrary: library;
		initializeFunction_connect_inLibrary: library;
		initializeFunction_getpeername_inLibrary: library;
		initializeFunction_getsockname_inLibrary: library;
		initializeFunction_getsockopt_inLibrary: library;
		initializeFunction_gnu_dev_major_inLibrary: library;
		initializeFunction_gnu_dev_makedev_inLibrary: library;
		initializeFunction_gnu_dev_minor_inLibrary: library;
		initializeFunction_isfdtype_inLibrary: library;
		initializeFunction_listen_inLibrary: library;
		initializeFunction_preadv_inLibrary: library;
		initializeFunction_pselect_inLibrary: library;
		initializeFunction_pwritev_inLibrary: library;
		initializeFunction_readv_inLibrary: library;
		initializeFunction_recv_inLibrary: library;
		initializeFunction_recvfrom_inLibrary: library;
		initializeFunction_recvmsg_inLibrary: library;
		initializeFunction_select_inLibrary: library;
		initializeFunction_send_inLibrary: library;
		initializeFunction_sendmsg_inLibrary: library;
		initializeFunction_sendto_inLibrary: library;
		initializeFunction_setsockopt_inLibrary: library;
		initializeFunction_shutdown_inLibrary: library;
		initializeFunction_sockatmark_inLibrary: library;
		initializeFunction_socket_inLibrary: library;
		initializeFunction_socketpair_inLibrary: library;
		initializeFunction_writev_inLibrary: library;
		initializeFunction___cmsg_nxthdr_inLibrary: library;
		initializeFunction___fdelt_chk_inLibrary: library;
		initializeFunction___fdelt_warn_inLibrary: library;
		initializeFunction___recvfrom_chk_inLibrary: library;
		initializeFunction___recv_chk_inLibrary: library;
		yourself
]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_accept_inLibrary: cLibrary [

	Functionaccept := CCallout
		library: cLibrary
		name: 'accept'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_bind_inLibrary: cLibrary [

	Functionbind := CCallout
		library: cLibrary
		name: 'bind'
		result: #'int32'
		args: #(#'int32' #'ptr' #'uint32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_connect_inLibrary: cLibrary [

	Functionconnect := CCallout
		library: cLibrary
		name: 'connect'
		result: #'int32'
		args: #(#'int32' #'ptr' #'uint32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_getpeername_inLibrary: cLibrary [

	Functiongetpeername := CCallout
		library: cLibrary
		name: 'getpeername'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_getsockname_inLibrary: cLibrary [

	Functiongetsockname := CCallout
		library: cLibrary
		name: 'getsockname'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_getsockopt_inLibrary: cLibrary [

	Functiongetsockopt := CCallout
		library: cLibrary
		name: 'getsockopt'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_gnu_dev_major_inLibrary: cLibrary [

	Functiongnu_dev_major := CCallout
		library: cLibrary
		name: 'gnu_dev_major'
		result: #'uint32'
		args: #(#'uint64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_gnu_dev_makedev_inLibrary: cLibrary [

	Functiongnu_dev_makedev := CCallout
		library: cLibrary
		name: 'gnu_dev_makedev'
		result: #'uint64'
		args: #(#'uint32' #'uint32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_gnu_dev_minor_inLibrary: cLibrary [

	Functiongnu_dev_minor := CCallout
		library: cLibrary
		name: 'gnu_dev_minor'
		result: #'uint32'
		args: #(#'uint64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_isfdtype_inLibrary: cLibrary [

	Functionisfdtype := CCallout
		library: cLibrary
		name: 'isfdtype'
		result: #'int32'
		args: #(#'int32' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_listen_inLibrary: cLibrary [

	Functionlisten := CCallout
		library: cLibrary
		name: 'listen'
		result: #'int32'
		args: #(#'int32' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_preadv_inLibrary: cLibrary [

	Functionpreadv := CCallout
		library: cLibrary
		name: 'preadv'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32' #'int64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_pselect_inLibrary: cLibrary [

	Functionpselect := CCallout
		library: cLibrary
		name: 'pselect'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr' #'ptr' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_pwritev_inLibrary: cLibrary [

	Functionpwritev := CCallout
		library: cLibrary
		name: 'pwritev'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32' #'int64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_readv_inLibrary: cLibrary [

	Functionreadv := CCallout
		library: cLibrary
		name: 'readv'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_recvfrom_inLibrary: cLibrary [

	Functionrecvfrom := CCallout
		library: cLibrary
		name: 'recvfrom'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_recvmsg_inLibrary: cLibrary [

	Functionrecvmsg := CCallout
		library: cLibrary
		name: 'recvmsg'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_recv_inLibrary: cLibrary [

	Functionrecv := CCallout
		library: cLibrary
		name: 'recv'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_select_inLibrary: cLibrary [

	Functionselect := CCallout
		library: cLibrary
		name: 'select'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_sendmsg_inLibrary: cLibrary [

	Functionsendmsg := CCallout
		library: cLibrary
		name: 'sendmsg'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_sendto_inLibrary: cLibrary [

	Functionsendto := CCallout
		library: cLibrary
		name: 'sendto'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32' #'ptr' #'uint32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_send_inLibrary: cLibrary [

	Functionsend := CCallout
		library: cLibrary
		name: 'send'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_setsockopt_inLibrary: cLibrary [

	Functionsetsockopt := CCallout
		library: cLibrary
		name: 'setsockopt'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32' #'ptr' #'uint32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_shutdown_inLibrary: cLibrary [

	Functionshutdown := CCallout
		library: cLibrary
		name: 'shutdown'
		result: #'int32'
		args: #(#'int32' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_sockatmark_inLibrary: cLibrary [

	Functionsockatmark := CCallout
		library: cLibrary
		name: 'sockatmark'
		result: #'int32'
		args: #(#'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_socketpair_inLibrary: cLibrary [

	Functionsocketpair := CCallout
		library: cLibrary
		name: 'socketpair'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_socket_inLibrary: cLibrary [

	Functionsocket := CCallout
		library: cLibrary
		name: 'socket'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction_writev_inLibrary: cLibrary [

	Functionwritev := CCallout
		library: cLibrary
		name: 'writev'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction___cmsg_nxthdr_inLibrary: cLibrary [

	Function__cmsg_nxthdr := CCallout
		library: cLibrary
		name: '__cmsg_nxthdr'
		result: #'ptr'
		args: #(#'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction___fdelt_chk_inLibrary: cLibrary [

	Function__fdelt_chk := CCallout
		library: cLibrary
		name: '__fdelt_chk'
		result: #'int64'
		args: #(#'int64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction___fdelt_warn_inLibrary: cLibrary [

	Function__fdelt_warn := CCallout
		library: cLibrary
		name: '__fdelt_warn'
		result: #'int64'
		args: #(#'int64')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction___recvfrom_chk_inLibrary: cLibrary [

	Function__recvfrom_chk := CCallout
		library: cLibrary
		name: '__recvfrom_chk'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'uint64' #'int32' #'ptr' #'ptr')
		varArgsAfter: -1.

]

{ #category : 'Initializing - private' }
LibcSocket class >> initializeFunction___recv_chk_inLibrary: cLibrary [

	Function__recv_chk := CCallout
		library: cLibrary
		name: '__recv_chk'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'uint64' #'int32')
		varArgsAfter: -1.

]

{ #category : 'Functions' }
LibcSocket >> accept_: __fd _: __addr _: __addr_len [ 
	"/usr/include/sys/socket.h line 243
/* Await a connection on socket FD.
   When a connection arrives, open a new socket to communicate with it,
   set *ADDR (which is *ADDR_LEN bytes long) to the address of the connecting
   peer and *ADDR_LEN to the address's actual length, and return the
   new socket's descriptor, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int accept (int __fd, __SOCKADDR_ARG __addr,
		   socklen_t *__restrict __addr_len);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' )"

	^Functionaccept callWith: { __fd. __addr. __addr_len }

]

{ #category : 'Constants' }
LibcSocket >> af_inet [

	^self class af_inet
]

{ #category : 'Constants' }
LibcSocket >> af_inet6 [

	^self class af_inet6
]

{ #category : 'Functions' }
LibcSocket >> bind_: __fd _: __addr _: __len [ 
	"/usr/include/sys/socket.h line 123
/* Give the socket FD the local address ADDR (which is LEN bytes long).  */
extern int bind (int __fd, __CONST_SOCKADDR_ARG __addr, socklen_t __len)
     __THROW;"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'uint32' )"

	^Functionbind callWith: { __fd. __addr. __len }

]

{ #category : 'Functions' }
LibcSocket >> connect_: __fd _: __addr _: __len [ 
	"/usr/include/sys/socket.h line 137
/* Open a connection on socket FD to peer at ADDR (which LEN bytes long).
   For connectionless socket types, just set the default address to send to
   and the only address from which to accept transmissions.
   Return 0 on success, -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int connect (int __fd, __CONST_SOCKADDR_ARG __addr, socklen_t __len);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'uint32' )"

	^Functionconnect callWith: { __fd. __addr. __len }

]

{ #category : 'Functions' }
LibcSocket >> getpeername_: __fd _: __addr _: __len [ 
	"/usr/include/sys/socket.h line 141
/* Put the address of the peer connected to socket FD into *ADDR
   (which is *LEN bytes long), and its actual length into *LEN.  */
extern int getpeername (int __fd, __SOCKADDR_ARG __addr,
			socklen_t *__restrict __len) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' )"

	^Functiongetpeername callWith: { __fd. __addr. __len }

]

{ #category : 'Functions' }
LibcSocket >> getsockname_: __fd _: __addr _: __len [ 
	"/usr/include/sys/socket.h line 127
/* Put the local address of FD into *ADDR and its length in *LEN.  */
extern int getsockname (int __fd, __SOCKADDR_ARG __addr,
			socklen_t *__restrict __len) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' )"

	^Functiongetsockname callWith: { __fd. __addr. __len }

]

{ #category : 'Functions' }
LibcSocket >> getsockopt_: __fd _: __level _: __optname _: __optval _: __optlen [ 
	"/usr/include/sys/socket.h line 219
/* Put the current value for socket FD's option OPTNAME at protocol level LEVEL
   into OPTVAL (which is *OPTLEN bytes long), and set *OPTLEN to the value's
   actual length.  Returns 0 on success, -1 for errors.  */
extern int getsockopt (int __fd, int __level, int __optname,
		       void *__restrict __optval,
		       socklen_t *__restrict __optlen) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' #'ptr' #'ptr' )"

	^Functiongetsockopt callWith: { __fd. __level. __optname. __optval. __optlen }

]

{ #category : 'Functions' }
LibcSocket >> gnu_dev_major_: __dev [ 
	"/usr/include/sys/sysmacros.h line 26
__extension__
extern unsigned int gnu_dev_major (unsigned long long int __dev)
     __THROW __attribute_const__;"

	"Interpreted as #uint32 from #( #'uint64' )"

	^Functiongnu_dev_major callWith: { __dev }

]

{ #category : 'Functions' }
LibcSocket >> gnu_dev_makedev_: __major _: __minor [ 
	"/usr/include/sys/sysmacros.h line 32
__extension__
extern unsigned long long int gnu_dev_makedev (unsigned int __major,
					       unsigned int __minor)
     __THROW __attribute_const__;"

	"Interpreted as #uint64 from #( #'uint32' #'uint32' )"

	^Functiongnu_dev_makedev callWith: { __major. __minor }

]

{ #category : 'Functions' }
LibcSocket >> gnu_dev_minor_: __dev [ 
	"/usr/include/sys/sysmacros.h line 29
__extension__
extern unsigned int gnu_dev_minor (unsigned long long int __dev)
     __THROW __attribute_const__;"

	"Interpreted as #uint32 from #( #'uint64' )"

	^Functiongnu_dev_minor callWith: { __dev }

]

{ #category : 'Functions' }
LibcSocket >> isfdtype_: __fd _: __fdtype [ 
	"/usr/include/sys/socket.h line 274
/* FDTYPE is S_IFSOCK or another S_IF* macro defined in <sys/stat.h>;
   returns 1 if FD is open on an object of the indicated type, 0 if not,
   or -1 for errors (setting errno).  */
extern int isfdtype (int __fd, int __fdtype) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionisfdtype callWith: { __fd. __fdtype }

]

{ #category : 'Functions' }
LibcSocket >> listen_: __fd _: __n [ 
	"/usr/include/sys/socket.h line 233
/* Prepare to accept connections on socket FD.
   N connection requests will be queued before further requests are refused.
   Returns 0 on success, -1 for errors.  */
extern int listen (int __fd, int __n) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionlisten callWith: { __fd. __n }

]

{ #category : 'Functions' }
LibcSocket >> preadv_: __fd _: __iovec _: __count _: __offset [ 
	"/usr/include/sys/uio.h line 65
/* Read data from file descriptor FD at the given position OFFSET
   without change the file pointer, and put the result in the buffers
   described by IOVEC, which is a vector of COUNT 'struct iovec's.
   The buffers are filled in the order specified.  Operates just like
   'pread' (see <unistd.h>) except that data are put in IOVEC instead
   of a contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t preadv (int __fd, const struct iovec *__iovec, int __count,
		       __off_t __offset) __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' #'int64' )"

	^Functionpreadv callWith: { __fd. __iovec. __count. __offset }

]

{ #category : 'Functions' }
LibcSocket >> pselect_: __nfds _: __readfds _: __writefds _: __exceptfds _: __timeout _: __sigmask [ 
	"/usr/include/sys/select.h line 118
/* Same as above only that the TIMEOUT value is given with higher
   resolution and a sigmask which is been set temporarily.  This version
   should be used.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int pselect (int __nfds, fd_set *__restrict __readfds,
		    fd_set *__restrict __writefds,
		    fd_set *__restrict __exceptfds,
		    const struct timespec *__restrict __timeout,
		    const __sigset_t *__restrict __sigmask);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' #'ptr' #'ptr' #'ptr' )"

	^Functionpselect callWith: { __nfds. __readfds. __writefds. __exceptfds. __timeout. __sigmask }

]

{ #category : 'Functions' }
LibcSocket >> pwritev_: __fd _: __iovec _: __count _: __offset [ 
	"/usr/include/sys/uio.h line 77
/* Write data pointed by the buffers described by IOVEC, which is a
   vector of COUNT 'struct iovec's, to file descriptor FD at the given
   position OFFSET without change the file pointer.  The data is
   written in the order specified.  Operates just like 'pwrite' (see
   <unistd.h>) except that the data are taken from IOVEC instead of a
   contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t pwritev (int __fd, const struct iovec *__iovec, int __count,
			__off_t __offset) __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' #'int64' )"

	^Functionpwritev callWith: { __fd. __iovec. __count. __offset }

]

{ #category : 'Functions' }
LibcSocket >> readv_: __fd _: __iovec _: __count [ 
	"/usr/include/sys/uio.h line 39
/* Read data from file descriptor FD, and put the result in the
   buffers described by IOVEC, which is a vector of COUNT 'struct iovec's.
   The buffers are filled in the order specified.
   Operates just like 'read' (see <unistd.h>) except that data are
   put in IOVEC instead of a contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t readv (int __fd, const struct iovec *__iovec, int __count)
  __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionreadv callWith: { __fd. __iovec. __count }

]

{ #category : 'Functions' }
LibcSocket >> recvfrom_: __fd _: __buf _: __n _: __flags _: __addr _: __addr_len [ 
	"/usr/include/sys/socket.h line 174
/* Read N bytes into BUF through socket FD.
   If ADDR is not NULL, fill in *ADDR_LEN bytes of it with tha address of
   the sender, and store the actual size of the address in *ADDR_LEN.
   Returns the number of bytes read or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t recvfrom (int __fd, void *__restrict __buf, size_t __n,
			 int __flags, __SOCKADDR_ARG __addr,
			 socklen_t *__restrict __addr_len);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' #'ptr' #'ptr' )"

	^Functionrecvfrom callWith: { __fd. __buf. __n. __flags. __addr. __addr_len }

]

{ #category : 'Functions' }
LibcSocket >> recvmsg_: __fd _: __message _: __flags [ 
	"/usr/include/sys/socket.h line 202
/* Receive a message as described by MESSAGE from socket FD.
   Returns the number of bytes read or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t recvmsg (int __fd, struct msghdr *__message, int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionrecvmsg callWith: { __fd. __message. __flags }

]

{ #category : 'Functions' }
LibcSocket >> recv_: __fd _: __buf _: __n _: __flags [ 
	"/usr/include/sys/socket.h line 156
/* Read N bytes into BUF from socket FD.
   Returns the number read or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t recv (int __fd, void *__buf, size_t __n, int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' )"

	^Functionrecv callWith: { __fd. __buf. __n. __flags }

]

{ #category : 'Functions' }
LibcSocket >> select_: __nfds _: __readfds _: __writefds _: __exceptfds _: __timeout [ 
	"/usr/include/sys/select.h line 106
/* Check the first NFDS descriptors each in READFDS (if not NULL) for read
   readiness, in WRITEFDS (if not NULL) for write readiness, and in EXCEPTFDS
   (if not NULL) for exceptional conditions.  If TIMEOUT is not NULL, time out
   after waiting the interval specified therein.  Returns the number of ready
   descriptors, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int select (int __nfds, fd_set *__restrict __readfds,
		   fd_set *__restrict __writefds,
		   fd_set *__restrict __exceptfds,
		   struct timeval *__restrict __timeout);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' #'ptr' #'ptr' )"

	^Functionselect callWith: { __nfds. __readfds. __writefds. __exceptfds. __timeout }

]

{ #category : 'Functions' }
LibcSocket >> sendmsg_: __fd _: __message _: __flags [ 
	"/usr/include/sys/socket.h line 184
/* Send a message described MESSAGE on socket FD.
   Returns the number of bytes sent, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t sendmsg (int __fd, const struct msghdr *__message,
			int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionsendmsg callWith: { __fd. __message. __flags }

]

{ #category : 'Functions' }
LibcSocket >> sendto_: __fd _: __buf _: __n _: __flags _: __addr _: __addr_len [ 
	"/usr/include/sys/socket.h line 163
/* Send N bytes of BUF on socket FD to peer at address ADDR (which is
   ADDR_LEN bytes long).  Returns the number sent, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t sendto (int __fd, const void *__buf, size_t __n,
		       int __flags, __CONST_SOCKADDR_ARG __addr,
		       socklen_t __addr_len);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' #'ptr' #'uint32' )"

	^Functionsendto callWith: { __fd. __buf. __n. __flags. __addr. __addr_len }

]

{ #category : 'Functions' }
LibcSocket >> send_: __fd _: __buf _: __n _: __flags [ 
	"/usr/include/sys/socket.h line 149
/* Send N bytes of BUF to socket FD.  Returns the number sent or -1.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t send (int __fd, const void *__buf, size_t __n, int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' )"

	^Functionsend callWith: { __fd. __buf. __n. __flags }

]

{ #category : 'Functions' }
LibcSocket >> setsockopt_: __fd _: __level _: __optname _: __optval _: __optlen [ 
	"/usr/include/sys/socket.h line 226
/* Set socket FD's option OPTNAME at protocol level LEVEL
   to *OPTVAL (which is OPTLEN bytes long).
   Returns 0 on success, -1 for errors.  */
extern int setsockopt (int __fd, int __level, int __optname,
		       const void *__optval, socklen_t __optlen) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' #'ptr' #'uint32' )"

	^Functionsetsockopt callWith: { __fd. __level. __optname. __optval. __optlen }

]

{ #category : 'Functions' }
LibcSocket >> shutdown_: __fd _: __how [ 
	"/usr/include/sys/socket.h line 261
/* Shut down all or part of the connection open on socket FD.
   HOW determines what to shut down:
     SHUT_RD   = No more receptions;
     SHUT_WR   = No more transmissions;
     SHUT_RDWR = No more receptions or transmissions.
   Returns 0 on success, -1 for errors.  */
extern int shutdown (int __fd, int __how) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionshutdown callWith: { __fd. __how }

]

{ #category : 'Functions' }
LibcSocket >> sockatmark_: __fd [ 
	"/usr/include/sys/socket.h line 266
/* Determine wheter socket is at a out-of-band mark.  */
extern int sockatmark (int __fd) __THROW;"

	"Interpreted as #int32 from #( #'int32' )"

	^Functionsockatmark callWith: { __fd }

]

{ #category : 'Functions' }
LibcSocket >> socketpair_: __domain _: __type _: __protocol _: __fds [ 
	"/usr/include/sys/socket.h line 119
/* Create two new sockets, of type TYPE in domain DOMAIN and using
   protocol PROTOCOL, which are connected to each other, and put file
   descriptors for them in FDS[0] and FDS[1].  If PROTOCOL is zero,
   one will be chosen automatically.  Returns 0 on success, -1 for errors.  */
extern int socketpair (int __domain, int __type, int __protocol,
		       int __fds[2]) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' #'ptr' )"

	^Functionsocketpair callWith: { __domain. __type. __protocol. __fds }

]

{ #category : 'Functions' }
LibcSocket >> socket_: __domain _: __type _: __protocol [ 
	"/usr/include/sys/socket.h line 113
/* Create a new socket of type TYPE in domain DOMAIN, using
   protocol PROTOCOL.  If PROTOCOL is zero, one is chosen automatically.
   Returns a file descriptor for the new socket, or -1 for errors.  */
extern int socket (int __domain, int __type, int __protocol) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' )"

	^Functionsocket callWith: { __domain. __type. __protocol }

]

{ #category : 'Constants' }
LibcSocket >> sock_stream [
	^ 1
]

{ #category : 'Higher-level functions' }
LibcSocket >> tcpSocket [

	^self
		socket_: self af_inet
		_: self sock_stream
		_: 0
]

{ #category : 'Functions' }
LibcSocket >> writev_: __fd _: __iovec _: __count [ 
	"/usr/include/sys/uio.h line 50
/* Write data pointed by the buffers described by IOVEC, which
   is a vector of COUNT 'struct iovec's, to file descriptor FD.
   The data is written in the order specified.
   Operates just like 'write' (see <unistd.h>) except that the data
   are taken from IOVEC instead of a contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t writev (int __fd, const struct iovec *__iovec, int __count)
  __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionwritev callWith: { __fd. __iovec. __count }

]

{ #category : 'Functions' }
LibcSocket >> __cmsg_nxthdr_: __mhdr _: __cmsg [ 
	"/usr/include/bits/socket.h line 276
extern struct cmsghdr *__cmsg_nxthdr (struct msghdr *__mhdr,
				      struct cmsghdr *__cmsg) __THROW;"

	"Interpreted as #ptr from #( #'ptr' #'ptr' )"

	^Function__cmsg_nxthdr callWith: { __mhdr. __cmsg }

]

{ #category : 'Functions' }
LibcSocket >> __fdelt_chk_: __d [ 
	"/usr/include/bits/select2.h line 24
/* Helper functions to issue warnings and errors when needed.  */
extern long int __fdelt_chk (long int __d);"

	"Interpreted as #int64 from #( #'int64' )"

	^Function__fdelt_chk callWith: { __d }

]

{ #category : 'Functions' }
LibcSocket >> __fdelt_warn_: __d [ 
	"/usr/include/bits/select2.h line 25
extern long int __fdelt_warn (long int __d)
  __warnattr (""bit outside of fd_set selected"");"

	"Interpreted as #int64 from #( #'int64' )"

	^Function__fdelt_warn callWith: { __d }

]

{ #category : 'Functions' }
LibcSocket >> __recvfrom_chk_: __fd _: __buf _: __n _: __buflen _: __flags _: __addr _: __addr_len [ 
	"/usr/include/bits/socket2.h line 43
extern ssize_t __recvfrom_chk (int __fd, void *__restrict __buf, size_t __n,
			       size_t __buflen, int __flags,
			       __SOCKADDR_ARG __addr,
			       socklen_t *__restrict __addr_len);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'uint64' #'int32' #'ptr' #'ptr' )"

	^Function__recvfrom_chk callWith: { __fd. __buf. __n. __buflen. __flags. __addr. __addr_len }

]

{ #category : 'Functions' }
LibcSocket >> __recv_chk_: __fd _: __buf _: __n _: __buflen _: __flags [ 
	"/usr/include/bits/socket2.h line 23
extern ssize_t __recv_chk (int __fd, void *__buf, size_t __n, size_t __buflen,
			   int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'uint64' #'int32' )"

	^Function__recv_chk callWith: { __fd. __buf. __n. __buflen. __flags }

]
