!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   Processor, Object.
!
!=========================================================================

expectvalue %String
run
Object _newKernelSubclass: #Processor
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
        options: #() 
  reservedOop: 909
%

! Remove existing behavior from Processor
removeallmethods Processor
removeallclassmethods Processor
set class Processor

! ------------------- Class methods for Processor
category: 'Documentation'
classmethod:
comment
^'
 Processor provides the Smalltalk Blue Book API for the processor scheduler.
 See also class ProcessorScheduler .'
%

category: 'Private'
classmethod:
_scheduler

"Returns   ProcessorScheduler scheduler "
<primitive: 457>

self _primitiveFailed: #_scheduler
%


category: 'Process State Change'
classmethod:
yield

^ self _scheduler yield
%

category: 'Accessing'
classmethod:
activeProcess

^ self _scheduler activeProcess
%

category: 'Accessing'
classmethod:
activePriority

^ self _scheduler activePriority
%

category: 'Accessing'
classmethod:
allProcesses

^ self _scheduler allProcesses
%

category: 'Accessing'
classmethod:
readyProcesses

^ self _scheduler readyProcesses
%

category: 'Accessing'
classmethod:
waitingProcesses

^ self _scheduler waitingProcesses
%

category: 'Accessing'
classmethod:
suspendedProcesses

^ self _scheduler suspendedProcesses
%

category: 'Priorities'
classmethod:
highestPriority

^ self _scheduler highestPriority
%

category: 'Priorities'
classmethod:
timingPriority

^ self _scheduler timingPriority
%

category: 'Priorities'
classmethod:
highIOPriority

^ self _scheduler highIOPriority
%

category: 'Priorities'
classmethod:
lowIOPriority

^ self _scheduler lowIOPriority
%

category: 'Priorities'
classmethod:
userInterruptPriority

^ self _scheduler userInterruptPriority
%

category: 'Priorities'
classmethod:
userSchedulingPriority

^ self _scheduler userSchedulingPriority
%

category: 'Priorities'
classmethod:
userBackgroundPriority

^ self _scheduler userBackgroundPriority
%
category: 'Priorities'
classmethod:
systemBackgroundPriority

^ self _scheduler systemBackgroundPriority
%

category: 'Priorities'
classmethod:
lowestPriority

^ self _scheduler lowestPriority
%

!----------------
category: 'Event Scheduling'
classmethod:
cancelWhenReadable: aGsSocket signal: objToNotify

^ self _scheduler cancelWhenReadable: aGsSocket signal: objToNotify
%

classmethod:
cancelWhenWritable: aGsSocket signal: objToNotify

^ self _scheduler cancelWhenWritable: aGsSocket signal: objToNotify
% 

classmethod:
whenReadable: aGsSocket signal: objToNotify

^ self _scheduler whenReadable: aGsSocket signal: objToNotify
%

classmethod
whenWritable: aGsSocket signal: objToNotify

^ self _scheduler  whenWritable: aGsSocket signal: objToNotify
%


! ------------------- Instance methods for Processor
