!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ReadStream, PositionableStream, Stream, Object.
!
! See installStreamHierarchy.topaz for filein information
!
!=========================================================================

removeallmethods ReadStream
removeallclassmethods ReadStream

doit
ReadStream comment: 'ReadStream / ReadStreamLegacy is a PositionableStream that allows its objects to 
 be read but not written.'.
true
%

category: 'Instance Creation'
classmethod: ReadStream
new

"Disallowed.  To create a new ReadStream, use the class method on: instead."

self shouldNotImplement: #new
%

category: 'Accessing'
method: ReadStream
next

"Returns the next object that the receiver can access for reading.  Generates
 an error if an attempt is made to read beyond the end of the stream."
| pos |
(self atEnd) ifTrue: [ ^ EndOfStream signal ].
pos := position .
position := pos + 1 .
^ itsCollection at: pos 
%

method: ReadStream
nextOrNil
 "Returns the next object that the receiver can access for reading.
  Returns nil if an attempt is made to read beyond the end of the stream.
  For use with Streams whose collections do not contain nil .
"
 | pos coll res |
 pos := position .
 pos > (coll := itsCollection) size ifTrue:[ ^ nil ]. "inline atEnd check"
 res := coll at: pos .
 position := pos + 1 .
 ^ res
%


category: 'Accessing'
method: ReadStream
nextElements: count into: anObject

"Stores the next count elements that the receiver can access for reading
 into anObject.  The receiver's collection and anObject must be compatible
 SequenceableCollections.  Returns the count of elements read.

 Generates an error if an attempt is made to read beyond the end of the stream."

"Used by PassiveObject."

count <= 0 ifTrue:[ ^ 0 ].
(self atEnd)
   ifTrue: [ ^ EndOfStream signal ].

anObject replaceFrom: 1 to: 1 + count - 1 with: itsCollection startingAt: position .
position := position + count.
^ count
%

category: 'Adding'
method: ReadStream
nextPut: anObject

"Disallowed.  You cannot write to a ReadStream."

self shouldNotImplement: #nextPut:
%

category: 'Passivation - Support'
set compile_env: 0
method: ReadStream
_fastNext
  "Returns the next item on the input stream without end of stream checks.
 This may result in a bad access error instead of an end of stream error."

  | res |
  res := itsCollection at: position.
  position := position + 1.
  ^ res
%

category: 'Passivation - Support'
set compile_env: 0
method: ReadStream
_fastPosition: pos
  "Sets the position of the receiver without checking the validity of the
 argument 'pos'.  This may result in bad index errors instead of end
 of stream errors in subsequent access of the stream."

  "See bug 42596: Compatible with Legacy Stream positioning"

  position := pos
%

category: 'Passivation - Support'
set compile_env: 0
method: ReadStream
_fastPosition
  "Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n."

  "See bug 42596: Compatible with Legacy Stream positioning"

  ^ position
%
##############################################
# 46428
# Begin methods copied from readstPortable.gs
##############################################
category: 'Testing'
method: ReadStream
nextMatchFor: anObject

	"The first object is removed from the receiver's future sequence value and appended to the end of
	the receiver's past sequence values. The value that would result from sending #= to the object with
	anObject as the argument is returned.
	The results are undefined if there are no future sequence values in the receiver.

	ANSI 5.9.2.6"

	^self next = anObject.
%
! 48809 faster version using #indexOf:startingAt:ifAbsent:
category: 'Adding'
method: ReadStream
upTo: anObject
| start end |

start := position.
end := itsCollection indexOf: anObject startingAt: start ifAbsent: [ ^self upToEnd ].

"skip to the end and return the data passed over"
position := end + 1.
^itsCollection copyFrom: start to: (end - 1)
%
