!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!========================================================================


level 2
expectvalue %Array
run

"Removes empty categories from all Classes and metaclasses in Globals.
 Returns an Array describing the categories removed."

| result |
result := { }  .

Globals associationsDo: [ :globalsAssoc | | aClass |
  aClass := globalsAssoc value .

  (aClass isKindOf: Behavior) ifTrue:[ | theClass empties envId |
    theClass := aClass .
    envId := 0 .
    2 timesRepeat:[
      empties := { }  .
      theClass categorysDo:[ :categName :selectors |
          selectors size == 0 ifTrue:[
            empties add: { categName . envId } .
	  ].
      ].
      empties do:[ :anArr || aName |
        aName := anArr at:1 .
        theClass removeCategory: aName environmentId: (anArr at:2) .
        result add: { theClass . aName } .
      ].
      theClass := theClass class . "handle the metaclass on second pass"
    ].
  ].  
].
^ result
%
level 0

! remove the _unsafeSetOop: method
!
expectvalue /String
run
(Object includesSelector: #_unsafeSet11Oop:) ifTrue:[
  Object removeSelector: #_unsafeSet11Oop: .
  ^ 'removed'
  ].
^ 'not found'
% 

expectvalue /String
run
(Object includesSelector: #_unsafeSetOop:) ifTrue:[
  Object removeSelector: #_unsafeSetOop: .
  ^ 'removed'
  ].
^ 'not found'
% 

! do not remove Object(C)>>_objectForOop: method , fix 32731

