!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   SetValuedPathTerm, CollectionBasedPathTerm, PathTerm, Array, SequenceableCollection, 
!   Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods SetValuedPathTerm
removeallclassmethods SetValuedPathTerm

category: 'For Documentation Installation only'
classmethod: SetValuedPathTerm
installDocumentation

self comment: '
SetValuedPathTerm is a subclass of PathTerm that implements set-valued path terms, represented
by a * in the path.

SetValuedPathTerm implements only GemStone internals, and is not intended for direct use
by customers.'.
%

category: 'Updating Indexes'
set compile_env: 0
method: SetValuedPathTerm
addMappingsForObject: anNsc logging: aBoolean
  "Adds index dictionary entries for the objects in anNsc.  Also update the
 NSC's index list."

  | iList indexDict sz |
  (nil == anNsc _or: [ self size == 0 ])
    ifTrue: [ ^ self ].
  anNsc class isNsc
    ifFalse: [ ^ self _errorPathObjectNotAnNsc: anNsc ].
  sz := self size.
  iList := anNsc _getIndexList.
  anNsc _putInWriteSet.	" for each index that utilizes this path term "
  1 to: sz do: [ :i | iList addIndex: (self at: i) withOffset: offset + 1 nsc: anNsc ].
  sz := children size.
  indexDict := self getIndexDictionary.
  anNsc
    do: [ :setElement | 
      " insert dictionary entry mapping set element -> NSC "
      indexDict
        _at: setElement
        put: anNsc
        term: self
        logging: aBoolean.
      updateBtree ~~ nil
        ifTrue: [ self addDirectMappingFor: setElement logging: false ].
      1 to: sz do: [ :j | (children at: j) addMappingsForObject: setElement logging: aBoolean ] ]
%
category: 'Updating Indexes'
set compile_env: 0
method: SetValuedPathTerm
addMappingsUsing: mapInfo logging: aBoolean
  "Adds index dictionary entries for the objects in the NSC described by the
 mapInfo.  Also update the NSC's index list."

  | iList anNsc nextPathTerm indexDict setElementMap nextMaps dictUpdated |
  anNsc := mapInfo object.
  (nil == anNsc _or: [ self size == 0 ])
    ifTrue: [ ^ self ].
  dictUpdated := false.
  iList := anNsc _getIndexList.
  anNsc _putInWriteSet.
  1 to: self size do: [ :i | 
    " for each index that utilizes this path term "
    iList addIndex: (self at: i) withOffset: offset + 1 nsc: anNsc ].
  indexDict := self getIndexDictionary.
  1 to: mapInfo size do: [ :k | 
    " for each child mapping "
    nextMaps := mapInfo at: k.
    1 to: nextMaps size do: [ :i | 
      " there is a collection of mappings for each element in the set "
      setElementMap := nextMaps at: i.
      dictUpdated
        ifFalse: [ 
          " insert dictionary entry mapping set element -> NSC "
          indexDict
            _at: setElementMap object
            put: anNsc
            term: self
            logging: aBoolean ].
      updateBtree ~~ nil
        ifTrue: [ self addDirectMappingFor: setElementMap object logging: aBoolean ].
      (nextPathTerm := setElementMap pathTerm) ~~ nil
        ifTrue: [ nextPathTerm addMappingsUsing: setElementMap logging: aBoolean ] ].
    dictUpdated := true ]
%
category: 'Deprecated'
set compile_env: 0
method: SetValuedPathTerm
allDependencyListsFor: anNsc into: all
  "Put any dependency lists that can be found from the receiver
into the given set."

  | sz |
  self deprecated: 'SetValuePathTerm>allDependencyListsFor:into: deprecated v3.3. Use 
    DependencyList class>>depMapValues to collect dependency lists. (3.3)'.  "43886"

  (nil == anNsc _or: [ self size == 0 ])
    ifTrue: [ ^ self ].
  anNsc class isNsc
    ifFalse: [ ^ self _errorPathObjectNotAnNsc: anNsc ].
  sz := children size.
  anNsc
    do: [ :setElement | 
      | depList |
      needsDepList
        ifTrue: [ 
          depList := DependencyList for: setElement.
          depList ~~ nil
            ifTrue: [ all add: depList ] ].
      1 to: sz do: [ :j | (children at: j) allDependencyListsFor: setElement into: all ] ]
%

! deleted auditObject:occurrences:on:

category: 'Updating Indexes'
set compile_env: 0
method: SetValuedPathTerm
cleanupDependencyListFor: anNsc
  ""

  | sz iList |
  (nil == anNsc _or: [ self size == 0 ])
    ifTrue: [ ^ self ].
  anNsc class isNsc
    ifFalse: [ ^ self _errorPathObjectNotAnNsc: anNsc ].
  (iList := anNsc _indexedPaths) ~~ nil
    ifTrue: [ iList removeIndexesInPathTerm: self for: anNsc ].
  sz := children size.
  anNsc
    do: [ :setElement | 
      | depList |
      needsDepList
        ifTrue: [ 
          depList := DependencyList for: setElement.
          depList ~~ nil
            ifTrue: [ depList removeCompletelyPathTerm: self for: setElement ] ].
      1 to: sz do: [ :j | (children at: j) cleanupDependencyListFor: setElement ] ]
%
category: 'Updating Indexes'
set compile_env: 0
method: SetValuedPathTerm
getMappingInfoFor: anNsc ifObject: anObject atOffset: ivOffset replaceWith: newValue
  "Gathers all the objects, their dependency lists, and instance variable offset
 for each object in anNsc and place these in a MappingInfo object.  Returns the
 mapping info."

  | mapInfo maps iList |
  (nil == anNsc _or: [ self size == 0 ])
    ifTrue: [ ^ self _mappingInfoClass new pathTerm: self ].
  anNsc class isNsc
    ifFalse: [ 
      | exa |
      (exa := ImproperOperation new)
        reason: #'rtErrPathTermObjectNotAnNsc';
        object: anNsc;
        details: 'Expected an UnorderedCollection'.
      ^ {false.	" indicating no indexing objects were modified "
      exa} ].
  iList := anNsc _indexedPaths.
  iList ~~ nil
    ifTrue: [ 
      " for each index on the NSC ... "
      1 to: iList size by: 2 do: [ :i | 
        " for each index in which this path term is used ... "
        1 to: self size do: [ :j | 
          ((iList at: i) == (self at: j) _and: [ (iList at: i + 1) ~= (offset + 1) ])
            ifTrue: [ 
              | exa |
              (exa := ImproperOperation new)
                _number:
                    (ErrorSymbols at: #'rtErrNscParticipatesInMultipleTerms');
                object: anNsc;
                args:
                    {anNsc.
                      ((iList at: i) pathComponentsString)}.
              ^ {false.	" indicating no indexing objects were modified "
              exa} ] ] ] ].	" create a mapping info object for the NSC "
  mapInfo := self _mappingInfoClass new
    object: anNsc;
    pathTerm: self.
  updateBtree ~~ nil
    ifTrue: [ 
      maps := Array new.
      anNsc
        do: [ :setElement | 
          " the set elements mapping info contains just the set element "
          maps add: (self _mappingInfoClass new object: setElement) ].
      mapInfo addLast: maps.
      ^ mapInfo ].
  children isEmpty
    ifTrue: [ 
      maps := Array new.
      anNsc do: [ :setElement | maps add: (self _mappingInfoClass new object: setElement) ].
      mapInfo addLast: maps ]
    ifFalse: [ 
      " for each following path term "
      1 to: children size do: [ :i | 
        maps := Array new.
        anNsc
          do: [ :setElement | 
            | aMapInfo |
            " get the set elements mapping info and add it to the set "
            aMapInfo := (children at: i)
              getMappingInfoFor: setElement
              ifObject: anObject
              atOffset: ivOffset
              replaceWith: newValue.
            aMapInfo _class == self _mappingInfoClass
              ifFalse: [ ^ aMapInfo ].
            maps add: aMapInfo ].
        mapInfo addLast: maps ] ].
  ^ mapInfo
%
category: 'Updating Indexes'
set compile_env: 0
method: SetValuedPathTerm
removeMappingsFor: anNsc lastOne: aBoolean logging: doLogging
  "Removes entries in the index dictionary, index list, and dependency lists for
 the elements contained in the NSC."

  | indexDict sz |
  self size == 0
    ifTrue: [ ^ self ].
  indexDict := self getIndexDictionary.
  sz := children size.	" for each object in the NSC "
  anNsc
    do: [ :setElement | 
      | more depList lastOne |
      " remove the index dictionary entry "
      more := indexDict
        removeKey: setElement
        value: anNsc
        term: self
        logging: doLogging.
      lastOne := aBoolean _and: [ more not ].
      updateBtree ~~ nil
        ifTrue: [ 
          self removeDirectMappingFor: setElement logging: doLogging.
          needsDepList
            ifTrue: [ DependencyList removePathTerm: self for: setElement ] ].
      nil ~~ setElement
        ifTrue: [ 
          " make recursive call to remove mappings "
          1 to: sz do: [ :j | 
            (children at: j)
              removeMappingsFor: setElement
              lastOne: lastOne
              logging: doLogging ] ].
      lastOne
        ifTrue: [ 
          (depList := DependencyList for: setElement) ~~ nil
            ifTrue: [ depList removePathTerms: children for: setElement ] ] ]
%
category: 'Accessing'
set compile_env: 0
method: SetValuedPathTerm
nextObj: anObj do: aBlock
  anObj do: aBlock
%
category: 'Audit'
set compile_env: 0
method: SetValuedPathTerm
auditDepListFor: obj index: indexObj on: aString optionalSentinel: optionalSentinel
  "the set does not have a dependency list"

  self shouldNotImplement: #'auditDepListFor:index:on:optionalSentinel:'
%
category: 'Audit'
set compile_env: 0
method: SetValuedPathTerm
auditIndexDictionaryForObject: anNsc occurrences: num on: aString
  "Private.  Unsupported method for GemStone Technical Support."

  "Verifies that the given object has the correct index dictionary entries for the receiver."

  | sz indexObj newNum dictChecked |
  sz := self size.
  (nil == anNsc _or: [ sz == 0 ])
    ifTrue: [ ^ aString ].
  anNsc
    do: [ :nextObj | 
      dictChecked := false.
      1 to: sz do: [ :i | 
        " for each index that utilizes the path term "
        indexObj := self at: i.
        (indexObj isRangeEqualityIndex and: [ indexObj size == offset ])
          ifFalse: [ 
            " verify index dictionary has correct entries "
            dictChecked
              ifFalse: [ 
                | occurs |
                occurs := anNsc occurrencesOf: nextObj.
                newNum := self
                  auditDictionaryEntryFor: anNsc
                  and: nextObj
                  occurrences: num * occurs
                  on: aString.
                dictChecked := true ] ] ].
      1 to: children size do: [ :i | 
        (children at: i)
          auditIndexDictionaryForObject: nextObj
          occurrences: newNum
          on: aString ] ]
%

# deleted auditNscCounts:for:on:count: to use superclass impl, deprecated Bug 43958

category: 'Audit'
method: SetValuedPathTerm
auditNscCountsFor: anNsc on: aString count: btreeCounts
  "Private. "

  | sz |
  sz := self size.
  (nil == anNsc _or: [ sz == 0 ])
    ifTrue: [ ^ aString ].
  anNsc
    do: [ :setElement | 
      | index |
      index := 1.
      children isEmpty
        ifTrue: [ self auditDirectNscCountsFor: setElement on: aString count: btreeCounts ]
        ifFalse: [ 
          1 to: sz do: [ :i | 
            | count indexObj |
            indexObj := self at: i.
            (indexObj isRangeEqualityIndex and: [ indexObj size == offset ])
              ifTrue: [ 
                count := btreeCounts at: index.
                count == 0
                  ifTrue: [ 
                    aString
                      add: Character lf;
                      add: ' -- The number of entries in Btree [';
                      add: (self at: i) btreeRoot asOop asString;
                      add: '] for pathTerm [';
                      add: self asOop asString;
                      add: ' offset ';
                      add: offset asString;
                      add:
                          '] does not match the number of entries in the base collection (extra elements in either the base collection or btree).';
                      add: Character lf ].
                btreeCounts at: index put: count - 1.
                index := index + 1 ] ].
          1 to: children size do: [ :i | 
            (children at: i)
              auditNscCountsFor: setElement
              on: aString
              count: (btreeCounts at: index).
            index := index + 1 ] ] ]
%

category: 'Testing'
set compile_env: 0
method: SetValuedPathTerm
indicatesIndexOnNscElements
  "Returns true if the path term indicates that the index is on elements of the
 NSC itself.  This is the case if the path term ends in '*' (that is, this
 path term has no children)."

  ^ children isEmpty
%
category: 'Testing'
set compile_env: 0
method: SetValuedPathTerm
isSetValuedTerm
  "Returns true if the receiver indicates a set-valued instance variable."

  ^ true
%
category: 'Accessing'
method: SetValuedPathTerm
_nextObjectFor: anObject
  "Cannot use this shortcut method"

  self shouldNotImplement: #'_nextObjectFor:'
%
category: 'Indexing Support'
method: SetValuedPathTerm
_updateCollectionBasedIndexFor: anIndex on: anNsc offset: anOffset addingIndex: addingIndex
  "if anNsc already has an index, add/remove anIndex as appropriate"

  anNsc _indexedPaths ~~ nil
    ifTrue: [ 
      | nscOffset |
      nscOffset := anOffset + 1.
      addingIndex
        ifTrue: [ 
          anNsc _indexedPaths
            addIndex: anIndex
            withOffset: (anIndex at: anOffset) offset + 1
            nsc: anNsc ]
        ifFalse: [ anNsc _indexedPaths removeIndex: anIndex withOffset: nscOffset for: anNsc ] ]
%
category: 'Testing'
method: SetValuedPathTerm
indicatesNsc
  "Returns true, the receiver indicates that the index is on an
 instance variable that is expected to be a collection (i.e., set valued pathterm."

  ^ true
%

