!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   Stream, Object.
!
!=========================================================================

removeallmethods Stream
removeallclassmethods Stream

category: 'For Documentation Installation only'
classmethod: Stream
installDocumentation

self comment:
'Stream is an abstract superclass that represents the ability to maintain a
 position reference into a linear sequence of objects.  Concrete subclasses are
 ReadStream and WriteStream.'.
%

category: 'Portable Methods'
classmethod: Stream
installLegacyStreamImplementation

(Globals at: #PositionableStream) isLegacyStreamImplementation
  ifTrue: [ ^ false ].
self installStreamImplementationFrom: (Globals at: #GemStone_Legacy_Streams).
^true
%

category: 'Portable Methods'
classmethod: Stream
installPortableStreamImplementation

(Globals at: #PositionableStream) isPortableStreamImplementation
  ifTrue: [ ^false ].
self installStreamImplementationFrom: (Globals at: #GemStone_Portable_Streams).
^true
%

category: 'Portable Methods'
classmethod: Stream
installStreamImplementationFrom: aSymbolDictionary

Globals at: #PositionableStream  put: (aSymbolDictionary at: #PositionableStream).
Globals at: #ReadStream put: (aSymbolDictionary at: #ReadStream).
Globals at: #WriteStream put: (aSymbolDictionary at: #WriteStream).
"ReadWriteStream and FileStream defined in Portable implementation, but not in 
 Legacy implementation"
(aSymbolDictionary at: #ReadWriteStream otherwise: nil)
    ifNil: [ Globals removeKey: #ReadWriteStream ifAbsent: []]
    ifNotNil: [:readWriteStreamClass | Globals at: #ReadWriteStream put: readWriteStreamClass ].
(aSymbolDictionary at: #FileStream otherwise: nil )
    ifNil: [ Globals removeKey: #FileStream ifAbsent: []]
    ifNotNil: [:fileStreamClass | Globals at: #FileStream put: fileStreamClass ].
%

category: 'Portable Methods'
classmethod: Stream
isLegacyStreamImplementation

self subclassResponsibility: #isLegacyStreamImplementation
%

category: 'Portable Methods'
classmethod: Stream
isPortableStreamImplementation

self subclassResponsibility: #isPortableStreamImplementation
%

category: 'Enumerating'
method: Stream
do: aBlock

"Evaluates the one-argument block aBlock for each of the remaining objects that
 the receiver can access."

[self atEnd]
  whileFalse: [aBlock value: self next]
%

category: 'Accessing'
method: Stream
next

"(Subclass responsibility, ReadStream only.)  Returns the next object that the
 receiver can access for reading.  Generates an error if an attempt is made to
 read beyond the end of the stream."

Stream subclassResponsibility: #next
%

category: 'Testing'
method: Stream
atEnd

"(Subclass responsibility.)  Returns true if the receiver cannot access any more
 objects, false if it can."

Stream subclassResponsibility: #atEnd
%

category: 'Adding'
method: Stream
nextPut: anObject

"(Subclass responsibility, WriteStream only.)  Inserts anObject as the next
 element that the receiver can access for writing.  Returns anObject."

Stream subclassResponsibility: #nextPut
%

category: 'Adding'
method: Stream
nextPutAllBytes: aCharacterCollection

"(Subclass responsibility, WriteStream only.)  Inserts the byte contents of
 aCharacterCollection as the next elements that the receiver can
 access.  Returns aCharacterCollection."

Stream subclassResponsibility: #nextPutAllBytes:
%
category: 'Private'
method: Stream
_nextPutAllBytes: aCharacterCollection

^ self nextPutAllBytes: aCharacterCollection
%

category: 'Adding'
method: Stream
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection.  (WriteStream only.)"

aCollection accompaniedBy: self do: [:me :each | me nextPut: each].
^ aCollection
%

category: 'ANSI'
method: Stream
close
	"5.9.1.1

	If the receiver is a write-back stream update its stream backing store as if the message #flush was
	sent to the receiver. Then eliminate any association between the receiver and its stream backing
	store. Any system resources associated with the association should be released. The effect of
	sending any message to the receiver subsequent to this message is undefined."
%

category: 'Adding'
method: Stream
cr

"Adds a newline to the output stream. (NOT a carriage return)"
"recompiled in stream2.gs "
self nextPut: Character lf

%

category: 'Adding'
method: Stream
lf

"Adds a newline to the output stream."
"recompiled in stream2.gs"
self nextPut: Character lf
%

category: 'Adding'
method: Stream
space

"Adds a space to the output stream."

self nextPut:  $    .

%

category: 'Adding'
method: Stream
tab

"Adds a tab to the output stream."
"recompiled in stream2.gs"
self nextPut: Character tab .
%

category: 'Testing'
method: Stream
isExternal

"Returns true if the source of the receiver's information
 is external to the image, and false otherwise."

^false
%

! fix 37918/37915: add maxSize and isFull methods

category: 'Accessing'
method: Stream
maxSize

"Returns the maximum number of objects/bytes 
 that this stream can hold.  

 By default, return a large value."

^ 1000000000000
%

category: 'Testing'
method: Stream
isFull

"Returns true if there is no more room in this stream.

 By default, always return false. "

^ false
%

category: '*PetitParser-Core-Converting'
set compile_env: 0
method: Stream
asPetitStream
	^ self contents asPetitStream
%

category: 'Fileout'
method:
_fileOutAll: aString

  ^ self nextPutAll: aString
%

! Test optimized character literals implemented in Stream
level 1
expectvalue true
run
  | strm ary exp |
  strm := PrintStream on: String new .
  strm cr; lf ; space ; tab . "note cr same as lf for PrintStream"
  ary := { } .
  strm contents do:[:c | ary add: c  codePoint ] .
  ary = #( 10 10 32 9 ) ifFalse:[ ^ ary ].
  true
%
level 0

