! file system2.gs



category: 'Online Backup Support'
classmethod: System
suspendCommitsForFailover
   "For use on the master system of a hotstandby pair.
    Suspends commits, starts a checkpoint,
    and waits for completion of the checkpoint.
    Returns a DateAndTime representation of the failover timestamp.
    After this method returns, the master stone may then be shutdown , or
    commits can be resumed with System(C)>>resumeCommits .

    Requires SystemControl privilege.
    If the repository is in restore mode, signals an error, and has no effect.

    While commits are suspended,
      attempts to commit will signal an Exception ,

      reclaim activity is suspended (reclaim gems are stopped)

      markForCollection will signal an Exception when it attempts
      to acquire the gcLock ,

      epochGc will be suspended .

    The state of commits being suspended on a stone will survive shutdown or crash
    and restart of that stone, however the suspendCommits operation is not replayed
    by replay of tranlogs.

    When continuous restore reads a checkpoint containing a failover timestamp
    and the failover timestamp represents a time after the time at which
    the slave stone last started,  continuous restore will stop.
    If the failover timestamp is before the time at which
    the slave stone last started, continuous restore will continue replay
    of the transaction logs.
    The failover timestamp is printed to the slave stone's log,
    and will be returned from restoreStatus  method on the slave system.

    Failover timestamps will be printed to the logsender and logreceiver
    log files when they are read or written by those processes."

  | ts |
  ts := self _zeroArgPrim: 155 .
  ^ DateAndTime posixSeconds: ts offset: Duration zero .
%

category: 'Online Backup Support'
classmethod: System
resumeCommits

    "For use after suspendCommitsForFailover ,
     Resumes commits on a master stone and restarts reclaim gems.
     Returns a DateAndTime representation of the time
     at which commits were suspended (the failover timestamp) .

     Restoring a backup file or   startstone -R 
     also have the effect of resuming commits.

     Requires SystemControl privilege."
  | ts |
  ts := self _zeroArgPrim: 156 .
  ts == 0 ifTrue:[ Error signal:'Commits have not been suspended' ].
  ^ DateAndTime posixSeconds: ts offset: Duration zero .
%

category: 'Private'
classmethod: System
_allErrorMessagesReport

"Private."

| errorSymbolsArray symsWithNoMsg msgsWithNoSym report line errMsgsArray 
  firstNil last k |

errorSymbolsArray  := { }  .
ErrorSymbols keysAndValuesDo:[:aSym :aNum |
  aNum > errorSymbolsArray size ifTrue:[ errorSymbolsArray size: aNum ].
  (errorSymbolsArray at: aNum) ifNotNil:[
    self _halt:'Duplicate symbol for error number ' , aNum asString .
  ].
  errorSymbolsArray at: aNum put: aSym .
].
errMsgsArray := GemStoneError at: #English .
msgsWithNoSym := String new .
symsWithNoMsg := String new .
(report := String new) lf .

report add:'ERROR MESSAGES STORED IN THE REPOSITORY:'; lf; lf .
1 to: errorSymbolsArray size do:[:j | | msgParts aSym |
  aSym := errorSymbolsArray at: j .
  msgParts := errMsgsArray at: j .
  aSym ifNil:[
    msgParts ifNotNil:[
       msgsWithNoSym addAll: '*** No error symbol for error number ';
		addAll: j asString; lf .
    ]
  ] ifNotNil:[
    msgParts ifNil:[
       symsWithNoMsg addAll: '*** No message for error symbol #';
		addAll: aSym quoted; lf .
    ] ifNotNil:[
       line := j asString. 
       line addAll: ', #' ; addAll: aSym; addAll: ' :  ' ;
            addAll: (self _messageForErrorNum: j)  .
       report addAll: (line _wrapTo: 80 indentingWith: '    '); lf .
     ]
  ].
].

report lf ; add:
'Error mapping to Ansi Exception classes,
message text is generated during Exception signaling.' ; lf .
1 to: errorSymbolsArray size do:[:m |
  (errorSymbolsArray at: m) ifNil:[
    (LegacyErrNumMap at: m) ifNotNil:[:elem |
      elem _isArray ifTrue:[ 
        (elem size == 3 ifTrue:[ { elem at: 1 } ] ifFalse:[ elem at: 4 ])
          do:[:cls | report add:'  '; add: m asString ; add: ' --> ' ; add: cls name ; lf ]
      ]
    ]
  ]
].

report lf ; add:
'ERROR MESSAGES FROM errmsg.c, TEXT FROM errmsg.ht '; lf ;
add: '  (Repository message followed by errmsg.ht message, if any)'; lf; lf .

1 to: errorSymbolsArray size do:[:j | | msgFN |
  (errorSymbolsArray at: j) ifNotNil:[ :aSym | 
    (self _internalMessageForErrorNum: j) ifNotNil:[ :internalMsg | 
      msgFN := self _messageForErrorNum: j .
      msgFN ifNil:[ msgFN := 'NO MESSAGE FOR NUMBER ' , j asString ].
      (line := j asString) add: ', #' ; add: aSym; add: ' :  ' ;
           add: msgFN ; lf ; add: internalMsg .
      report add: (line _wrapTo: 80 indentingWith: '    '); lf; lf.
    ].
  ].
].

report lf ; add:'UNUSED ERROR NUMBERS:'; lf .
firstNil := 1 .
k := 1.
last := errorSymbolsArray size .
[k < last] whileTrue:[
  [ (errorSymbolsArray at: k) == nil and:[k < last] ] whileTrue:[ k := k + 1 ]. 
  k > firstNil ifTrue:[
    report add: firstNil asString ; add: ' to: '; 
		add: (k - 1) asString; lf .
  ] ifFalse:[
    report add: firstNil asString; lf .
  ].
  firstNil := nil . 
  [ (errorSymbolsArray at: k) ~~ nil and:[k < last] ] whileTrue:[ k := k + 1 ]. 
  firstNil := k .
].

report lf .
msgsWithNoSym size ~~ 0 
  ifTrue:[ report add: msgsWithNoSym ]
  ifFalse:[ report add:'No messages found without an error symbol.'].
report lf .
symsWithNoMsg size ~~ 0 
  ifTrue:[ report add: symsWithNoMsg ]
  ifFalse:[ report add: 'No error symbols found without a message.'].
report lf .
^ report
%

category: 'Notification'
classmethod: System
notifySet

"Returns an Array of the objects that were registered for notification."

^(GsBitmap newForHiddenSet: #NotifySet) asArray
%

category: 'Releasing Locks'
classmethod: System
addToCommitReleaseLocksSet: anObject

"Add anObject to the commit release locks set.  If anObject is not locked 
 by the current session, then it is not added to the set."

((self myLockKind: anObject) == #none )
  ifFalse: [(GsBitmap newForHiddenSet: #CommitReleaseLocksSet) add: anObject].
^self
%

category: 'Releasing Locks'
classmethod: System
addAllToCommitReleaseLocksSet: aCollection

"Add each element of aCollection to the commit release locks set.  If an
 element of aCollection is not locked by the current session, then that
 element is not added to the set."

aCollection accompaniedBy: (GsBitmap newForHiddenSet: #CommitReleaseLocksSet) 
   do: [:hs :each | 
     ((System myLockKind: each) == #none)
        ifFalse: [ hs add: each ]
   ].
^self
%

category: 'Releasing Locks'
classmethod: System
addToCommitOrAbortReleaseLocksSet: anObject

"Add anObject to to the commit-or-abort release locks set.  If anObject
 is not locked by the current session, then it is not added to the set."

((self myLockKind: anObject) == #none )
  ifFalse: [(GsBitmap newForHiddenSet: #CommitOrAbortReleaseLocksSet) add: anObject].
^self
%

category: 'Releasing Locks'
classmethod: System
addAllToCommitOrAbortReleaseLocksSet: aCollection

"Add each element of aCollection to the commit-or-abort release locks set. 
 If an element of aCollection is not locked by the current session, then
 it is not added to the set."

aCollection accompaniedBy: (GsBitmap newForHiddenSet: #CommitOrAbortReleaseLocksSet) 
   do: [:hs :each | 
     ((System myLockKind: each) == #none)
        ifFalse: [ hs add: each ]
   ].
^self
%

category: 'Releasing Locks'
classmethod: System
clearCommitReleaseLocksSet

"Remove all objects from the commit release locks set."

(GsBitmap newForHiddenSet: #CommitReleaseLocksSet) removeAll.
^self
%

category: 'Releasing Locks'
classmethod: System
clearCommitOrAbortReleaseLocksSet

"Remove all objects from the commit-or-abort release locks set."

(GsBitmap newForHiddenSet: #CommitOrAbortReleaseLocksSet) removeAll.
^self
%

category: 'Releasing Locks'
classmethod: System
commitReleaseLocksSetIncludes: anObject

"Returns true if anObject is in the commit release locks set. 
 Returns false otherwise."

^(GsBitmap newForHiddenSet: #CommitReleaseLocksSet) includes: anObject
%

category: 'Releasing Locks'
classmethod: System
commitOrAbortReleaseLocksSetIncludes: anObject

"Returns true if anObject is in the commit-or-abort release locks set.
 Returns false otherwise."

^(GsBitmap newForHiddenSet: #CommitOrAbortReleaseLocksSet) includes: anObject
%

category: 'Releasing Locks'
classmethod: System
removeFromCommitReleaseLocksSet: anObject

"Remove anObject from the commit release locks set.  If anObject is 
 not a member of the set, do nothing."

(GsBitmap newForHiddenSet: #CommitReleaseLocksSet) removeIfPresent: anObject
%

category: 'Releasing Locks'
classmethod: System
removeAllFromCommitReleaseLocksSet: aCollection

"Remove all elements of aCollection from the commit release locks set.
 If an element of aCollection is not a member of the set, it is ignored."

aCollection accompaniedBy: (GsBitmap newForHiddenSet: #CommitReleaseLocksSet) 
   do: [:hs :each |  hs removeIfPresent: each ].
^self
%

category: 'Releasing Locks'
classmethod: System
removeFromCommitOrAbortReleaseLocksSet: anObject

"Remove anObject from the commit-or-abort release locks set.  If anObject
 is not a member of the set, do nothing."

(GsBitmap newForHiddenSet: #CommitOrAbortReleaseLocksSet) removeIfPresent: anObject
%

category: 'Releasing Locks'
classmethod: System
removeAllFromCommitOrAbortReleaseLocksSet: aCollection

"Remove all the elements of aCollection from the commit-or-abort release
 locks set.  If an element of aCollection is not a member of the set,
 it is ignored."

aCollection accompaniedBy: (GsBitmap newForHiddenSet: #CommitOrAbortReleaseLocksSet) 
   do: [:hs :each |  hs removeIfPresent: each ].
^self
%

category: 'Private - Hidden Set'
classmethod: System
_loadOrStoreHiddenSet: hiddenSetSpecifier toOrFromFile: aString opCode: anOpCode

"Performs hidden set to bitmap file operations.

 ONLY supports hiddenSetSpecifiers from GsBitmap as Symbols

 If anOpCode is zero, read the given bitmap file into the given hidden set.
 The file must exist and be readable by the gem process.  hiddenSetSpecifier
 must be the index of a hidden set that is modifiable by customers.
 This check is bypassed if the session is logged in as SystemUser.  Extreme
 caution should be used in this case.  Be sure to call
 System>>_hiddenSetReinit: method first to ensure the hidden is empty.

 If anOpCode is one, then the given hidden set is written to the specified
 bitmap file.  The file must not already exist and the path to the file must
 be in a directory which is writable by the process.  Any valid hidden set
 specifier may be used in this case.

 If anOpCode is two, then the file is assumed to be a sorted bitmap file
 of objects produced by one of the Repository>>listInstancesInPageOrder:
 methods.  The objects are loaded into the given hidden set, but the ordering
 by page ID is lost because hidden sets are always ordered by object ID.
 No validation of the object IDs is done by this load.

 Returns true if successful, false if an error occurred.  Additional error
 information may be written stderr for the process (either the terminal
 or the gem log file)."

| bitmap |
aString _validateKindOfClass: String.
anOpCode _validateClass: SmallInteger.

bitmap := GsBitmap newForHiddenSet: hiddenSetSpecifier.
anOpCode = 0 ifTrue: [ bitmap readFromFile: aString. ^ true ].
anOpCode = 1 ifTrue: [ bitmap writeToFile: aString. ^ true ].

anOpCode > 1 ifTrue: [ Error signal:'opCode ' , anOpCode asString , ' not supported' ].
%

