! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================

expectvalue %String
run
CBuffer _newKernelSubclass: #TraversalBuffer
  instVarNames: #(#travResultOop #resultIsSpecial #clampOop #retrievalFlags
                  #level)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #() 
  reservedOop: nil
%

! Remove existing behavior from TraversalBuffer
removeallmethods TraversalBuffer
removeallclassmethods TraversalBuffer

category: 'For Documentation Installation only'
classmethod
installDocumentation

self comment:
'TraversalBuffer represents an instance of the C type GciTravBufType, which is
 defined in $GEMSTONE/include/gcicmn.ht .  Various traversal functions defined
 in $GEMSTONE/include/gci.hf  take a pointer to a GciTravBufType as an argument.

Constraints:
	offset: SmallInteger
	travResultOop: Object
	resultIsSpecial: Object
	clampOop: Object
	retrievalFlags: Object
	level: Object'.
%


! ------------------- Class methods for TraversalBuffer
! ------------------- Instance methods for TraversalBuffer
category: 'Accessing - Traversal'
method: TraversalBuffer
actualBufferSize

"Return the actual size of the traversal buffer.
 The result is value of the field GciTravBufType.usedBytes in receiver.
 Deprecated"

self deprecated: 'TraversalBuffer>>actualBufferSize deprecated in v3.2. Use usedBytes instead'.
^ self _zeroArgPrim: 16.
%
method: TraversalBuffer
usedBytes
"Return the actual size of the traversal buffer.
 The result is value of the field GciTravBufType.usedBytes in receiver."

^ self _zeroArgPrim: 16.
%
category: 'Updating - Traversal'
method: TraversalBuffer
advanceValueBufferOop

"Advance to the next oop in the value buffer, if that advance
 would not go beyond the end of the value buffer.
 Returns true if the internal pointer was advanced.
 Returns false if the internal pointer is already pointing to
 the last oop in the value buffer, in which case the pointer
 is unchanged."

^ self _zeroArgPrim: 29.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
bytesToEnd

"Return the number of bytes from the current pointer to the end of the buffer."

^ self _zeroArgPrim: 24.
%
category: 'Testing - Traversal'
method: TraversalBuffer
complete

"Return buffHdr.complete"

^ self _zeroArgPrim: 2.
%
category: 'Copying'
method: TraversalBuffer
copyObjectReportInto: aTBuffer

"Copy the current object report into the given TraversalBuffer.
Return whether the copy was successful."

^ self _oneArgPrim: 13 arg: aTBuffer.
%
category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsByte

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_BYTE"

^ self _zeroArgPrim: 14.
%
category: 'Testing'
method: TraversalBuffer
currentObjectIsClampedFromCallback

"Return whether the current object report is clamped by having the
traversal callback place a _remoteNil in the value buffer."

^ self objSize == 1 and:
[ self currentValueBufferOopIsSpecial and:
[ self valueBufferSpecialOop == _remoteNil ] ]
%
category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsInvariant

"Return ((GciObjRepHdrSType *)buffHdr.current)->isInvariant"

^ self _zeroArgPrim: 6.
%
category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsNsc

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_NSC"

^ self _zeroArgPrim: 15.
%
category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsOop

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_OOP"

^ self _zeroArgPrim: 13.
%
category: 'Testing - Traversal'
method: TraversalBuffer
currentObjectIsSpecial

"Return ((GciObjRepHdrSType *)buffHdr.current)->objImpl == GC_FORMAT_SPECIAL"

^ self _zeroArgPrim: 12.
%
category: 'Testing - Traversal'
method: TraversalBuffer
currentValueBufferOopIsSpecial

"Return whether the current oop in the value buffer stream is special format."

^ self _zeroArgPrim: 30.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
firstOffset

"Return ((GciObjRepHdrSType *)buffHdr.current)->firstOffset"

^ self _zeroArgPrim: 11.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
getByteObject

"The current report must be for a class with byte indexed instance variables.
 Answer a new object of the report's class, containing only the bytes that are in
 the current report. Note that if the firstOffset is not 1, the indices of bytes
 in the resulting object will not be the same as in the object partially described
 by the report."

^ self _zeroArgPrim: 21.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
getByteObjectInto: byteObj

"If necessary, resize the given byteObj to the size of the object described by
 the current object report (which should be for an object of a byte class).
 Put the bytes contained in the current object report into the given byteObj. 
 If this is a subset of all of the bytes in the object described by the report, 
 those bytes will be put at their proper indices, and bytes at other indices
 will remain unchanged (contrast with the behavior of #getByteObject)."

^ self _oneArgPrim: 12 arg: byteObj.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
idxSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->idxSize"

^ self _zeroArgPrim: 9.
%
category: 'Updating - Traversal'
method: TraversalBuffer
incrementActualSize: value

"Increment GciTravBufType.usedBytes of the receiver. Deprecated"

self deprecated: 'TraversalBuffer>>incrementActualSize: deprecated in v3.2. Use incrementUsedBytes: instead.'.
^ self _oneArgPrim: 11 arg: value.
%
method: TraversalBuffer
incrementUsedBytes: value

"Increment GciTravBufType.usedBytes of the receiver.  
 The new value of GciTravBufType.usedBytes is limited to 
 a maximum of GciTravBufType.allocatedBytes ."

^ self _oneArgPrim: 11 arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
initTraversalBuffer

"Initialize the receiver to look like an empty traversal buffer.
 The first object report header is memset to zero ."

^ self _zeroArgPrim: 22.
%
category: 'Initialization'
method: TraversalBuffer
initialize

"Initialize a new instance."

travResultOop := nil.
resultIsSpecial := true.
clampOop := nil.
level := 0.
retrievalFlags := 0.
%
category: 'Testing'
method: TraversalBuffer
isCompleteObjectReport

"Return whether the current object report contains the last byte or oop of the object.
 If this method answers true, and #firstOffset answers 1, the object report
 contains all bytes or oops of the object."

^ self currentObjectIsByte
  ifTrue: [ (self firstOffset + self valueBuffSize) > self objSize ]
  ifFalse: [ (self firstOffset + self numberOfValueBuffOops) > self objSize ]
%
category: 'Testing'
method: TraversalBuffer
isEmptyObjectReport

"Return whether the current object report is empty."

^ ( self valueBuffSize == 0 and: [ self objSize > 0 ] )
%
category: 'Testing'
method: TraversalBuffer
isLastObjectInBuffer

"Return whether the current object report is for the last object in the logical buffer
(which includes buffers returned from moreTraversal).
For use when reading a buffer."

^ self complete and: [ self isLastObjectReport ]
%
category: 'Testing - Traversal'
method: TraversalBuffer
isLastObjectReport

"Return whether the current object report is the last report in the buffer
  for reading the buffer."

^ self _zeroArgPrim: 18.
%
category: 'Testing - Traversal'
method: TraversalBuffer
isPartial

"Return whether the current object report is a partial report."

^ self _zeroArgPrim: 26.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
namedSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->namedSize"

^ self _zeroArgPrim: 7.
%
category: 'Updating - Traversal'
method: TraversalBuffer
makeObjectReportOverlayed

"Return ((GciObjRepHdrSType *)buffHdr.current)->isOverlayed = TRUE"
^ self _zeroArgPrim: 25.
%

category: 'Updating - Traversal'
method: TraversalBuffer
nextObjectReport

"Advance to the next object report for reading from the buffer.
 Return whether there is another."

^ self _zeroArgPrim: 17.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
numberOfValueBuffOops

"Return number of oops contained in the value buffer."

^ self valueBuffSize // 4
%
category: 'Accessing - Traversal'
method: TraversalBuffer
objId

"Return ((GciObjRepHdrSType *)buffHdr.current)->objId"

^ self _zeroArgPrim: 3.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
objSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->objSize"

^ self _zeroArgPrim: 8.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
objectReportHeaderSize

"Return sizeof(GciObjRepHdrSType)."

^ self _zeroArgPrim: 23.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
oclass

"Return ((GciObjRepHdrSType *)buffHdr.current)->oclass"

^ self _zeroArgPrim: 4.
%
category: 'Accessing'
method: TraversalBuffer
resultIsSpecial

   "Return the value of the instance variable 'resultIsSpecial'."
   ^resultIsSpecial
%
category: 'Updating'
method: TraversalBuffer
resultIsSpecial: newValue

   "Modify the value of the instance variable 'resultIsSpecial'."
   resultIsSpecial := newValue
%
category: 'Deprecated'
method: TraversalBuffer
segment
	self deprecated: 'TraversalBuffer>>segment deprecated in v3.0 and above; use objectSecurityPolicy'.
	^self objectSecurityPolicy.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
objectSecurityPolicy

"Return ((GciObjRepHdrSType *)buffHdr.current)->objectSecurityPolicy"

^ self _zeroArgPrim: 5.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setBytes: byteObj startingAt: index

"Populate the current object report ((GciObjRepSType *)buffHdr.current)
 from the given byte object. u.bytes is populated with bytes from byteObj
 starting at the given index and ending with the last byte of byteObj. If 
 that many bytes will not fit in the receiver, as many bytes as will fit are
 populated and false is answered. If all fit, true is answered.
 In any case, the report's firstOffset is set to index, and the 
 valueBuffSize is set to the number of bytes in the report.
 If false is answered, you may send #valueBuffSize to help determine
 the start offset to use in the next buffer."

^ self _twoArgPrim: 0 arg: byteObj arg: index.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setComplete: value

"Set buffHdr->complete."

^ self _oneArgPrim: 15 arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setFirstObjectReport

"Set the pointer to the first object report."

^ self _zeroArgPrim: 19.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setFirstOffset: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->firstOffset"

^ self _oneArgPrim: 9 arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setFormat: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->objImpl where

-1 indicates GC_FORMAT_SPECIAL
0 indicates GC_FORMAT_OOP
1 indicates GC_FORMAT_BYTE
2 indicates GC_FORMAT_NSC
"

^ self _oneArgPrim: 10 arg: value.
%
method: TraversalBuffer
setByteSwizzle: value
 "value is a SmallInteger, 0..3 per GciByteSwizEType in gci.ht,
    gci_byte_swiz_none = 0,     
    gci_byte_swiz_2_bytes = 1,  
    gci_byte_swiz_4_bytes = 2,
    gci_byte_swiz_8_bytes = 3
  
  On a fetch traversal, the server fills in the bits specified by
   swiz_kind_mask in GciObjRepHdrSType (in gci.ht), and the
  transport layer swizzles accordingly.

  On a store traveral the client is responsible for filling in the
  swiz_kind_mask  bits as follows, for each object report whose
  object's class is a subclass of one of the following classes .
     server class    swizzle bits
     -------------   -----------
     LargeInteger    gci_byte_swiz_4_bytes
     SmallFloat      gci_byte_swiz_4_bytes
     Float           gci_byte_swiz_8_bytes
     DoubleByteString  gci_byte_swiz_2_bytes
     QuadByteString  gci_byte_swiz_4_bytes
     BitSet          gci_byte_swiz_4_bytes
  All other reports should have the swiz_kind_mask  bits == 0.
"
^  self _oneArgPrim: 26 arg: value
%
category: 'Updating - Traversal'
method: TraversalBuffer
setIdxSize: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->idxSize"

^ self _oneArgPrim: 7 arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setIsInvariant: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->isInvariant."

^ self _oneArgPrim: 4 arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setNamedSize: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->namedSize"

^ self _oneArgPrim: 5 arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setNextObjectReport

"Advance to the next object report for writing to the buffer.  
The next object report header is memset to zero .
 You must send this message after you complete writing 
 each object to the buffer, including the last object.
 Answers false if there is not enough room in the buffer
 for another object header, true otherwise."

^ self _zeroArgPrim: 27.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setObjId: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->objId"

^ self _oneArgPrim: 1 arg: value.
%

! setObjSize: deleted ; objSize now derived from idxSize and namedSize

category: 'Updating - Traversal'
method: TraversalBuffer
setOclass: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->oclass"

^ self _oneArgPrim: 2 arg: value.
%
category: 'Deprecated'
method: TraversalBuffer
setSegmentId: value
self deprecated: 'TraversalBuffer>>setSegmentId: deprecated v3.0, use setObjectSecurityPolicyId:'.
^ self setObjectSecurityPolicyId: value
%
category: 'Updating - Traversal'
method: TraversalBuffer
setObjectSecurityPolicyId: value

"value must be a legal objectSecurityPolicyId, a SmallInt in range 0..16rFFFF"

^ self _oneArgPrim: 3 arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
setValueBuffSize: value

"Set ((GciObjRepHdrSType *)buffHdr.current)->valueBuffSize.
 Not needed after setBytes:startingAt: ."

^ self _oneArgPrim: 8 arg: value.
%
category: 'Accessing'
method: TraversalBuffer
clampOop

   "Return the value of the instance variable 'clampOop'."
   ^clampOop
%
category: 'Updating'
method: TraversalBuffer
clampOop: newValue

   "Modify the value of the instance variable 'clampOop'."
   clampOop := newValue
%
category: 'Accessing'
method: TraversalBuffer
level

   "Return the value of the instance variable 'level'."
   ^level
%
category: 'Updating'
method: TraversalBuffer
level: newValue

   "Modify the value of the instance variable 'level'."
   level := newValue
%
category: 'Accessing'
method: TraversalBuffer
retrievalFlags

   "Return the value of the instance variable 'retrievalFlags'."
   ^retrievalFlags
%
category: 'Updating'
method: TraversalBuffer
retrievalFlags: newValue

   "Modify the value of the instance variable 'retrievalFlags'."
   retrievalFlags := newValue
%
category: 'Accessing'
method: TraversalBuffer
travResultOop

   "Return the value of the instance variable 'travResultOop'."
   ^travResultOop
%
category: 'Updating'
method: TraversalBuffer
travResultOop: newValue

   "Modify the value of the instance variable 'travResultOop'."
   travResultOop := newValue
%
category: 'Accessing - Traversal'
method: TraversalBuffer
valueBuffSize

"Return ((GciObjRepHdrSType *)buffHdr.current)->valueBuffSize"

^ self _zeroArgPrim: 10.
%
category: 'Updating - Traversal'
method: TraversalBuffer
valueBufferAt: i putRemoteOop: value

"Set ((GciObjRepSType *)buffHdr.current)->u.oops[offset] = value.  Return whether 
the insertion was allowed."

^ self _twoArgPrim: 2 arg: i arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
valueBufferAt: i putSpecial: value

"Set ((GciObjRepSType *)buffHdr.current)->u.oops[offset] = value.  Return whether 
the insertion was allowed."

^ self _twoArgPrim: 1 arg: i arg: value.
%
category: 'Updating - Traversal'
method: TraversalBuffer
valueBufferPutOverlayAt: i

"Set ((GciObjRepSType *)buffHdr.current)->u.oops[offset] = OOP_OVERLAY.
Return whether the insertion was allowed."

self makeObjectReportOverlayed.
^ self _oneArgPrim: 14 arg: i.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
valueBufferRemoteOop

"Return the next remote oop in the value buffer, which is non-special."

^ self _zeroArgPrim: 20.
%
category: 'Accessing - Traversal'
method: TraversalBuffer
valueBufferSpecialOop

"Return the next oop, which is special format, in the value buffer."

^ self _zeroArgPrim: 31.
%
category: 'Accessing'
method: TraversalBuffer
varyingEndOffset

"Return the end point for updating the varying portion of the receiver."

^ self numberOfValueBuffOops - self namedSize + self firstOffset - 1
%
category: 'Accessing'
method: TraversalBuffer
varyingStartOffset

"Return the starting point for updating the varying portion of the receiver."

| start firstOffset namedSize |

firstOffset := self firstOffset.
namedSize := self namedSize.

start := 1.
( firstOffset > 1 and: [ firstOffset > namedSize ] )
  ifTrue: [ start := firstOffset - namedSize ].
^ start
%
