!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: Deprecated.gs 23817 2010-07-14 16:59:48Z otisa $
!
!=========================================================================

expectvalue %String
run
Notification _newKernelSubclass: 'Deprecated'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #() 
  reservedOop: nil
%

set class Deprecated
removeallmethods Deprecated
removeallclassmethods Deprecated

category: 'Documentation'
classmethod: Deprecated
comment

^'Deprecated is used to signal methods that are deprecated.
See Object>>#deprecated: for suggested use.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object' 
%

run
  | assoc |
  Globals at:#DeprecationEnabled put: nil .
  assoc := Globals associationAt: #DeprecationEnabled.
  assoc  objectSecurityPolicy == SystemObjectSecurityPolicy ifTrue:[
     assoc objectSecurityPolicy: DataCuratorObjectSecurityPolicy .
  ].
  ^ true
%

category: 'signaledException'
classmethod: Deprecated
deprecatedAction

  "returns one of #ignore, #log, #logstack #error"

  ^ DeprecationEnabled ifNil:[ #ignore ]
%

category: 'signaledException'
classmethod: Deprecated
doErrorOnDeprecated
  "signal an error to the application when deprecated: is sent."

  DeprecationEnabled := #error
%

category: 'signaledException'
classmethod: Deprecated
doLogOnDeprecated
  "When deprecated: is sent, log the argument to a file."

  DeprecationEnabled := #log
%
classmethod: Deprecated
doLogStackOnDeprecated
  "When deprecated: is sent, log the argument and the call stack to a file."

  DeprecationEnabled := #logstack
%

category: 'signaledException'
classmethod: Deprecated
doNothingOnDeprecated
  "Sends of deprecated: will do nothing"

  DeprecationEnabled := nil
%

classmethod: Deprecated
logFile
  | key tmps |
  key := #Deprecated_logFile.
  ((tmps := SessionTemps current) at: key otherwise: nil) ifNotNil:[:f | 
     f == #nil ifTrue:[ ^ nil ] ifFalse:[ ^ f ] 
  ]. 
  self logFilePath ifNotNil:[:path| 
    (GsFile openAppendOnServer: path) ifNotNil:[:f |
      tmps at: key put: f .
      ^ f
    ].
  ].
  tmps at: key put: #nil .
  ^ nil
%

category: 'signaledException'
classmethod: Deprecated
logFilePath

  | path key tmps |
  key := #Deprecated_logFilePath  .
  (path := (tmps := SessionTemps current) at: key otherwise: nil) ifNotNil:[ 
    ^ path
  ].
 ^ [
    path := System gemLogPath . 
    path size > 0 ifTrue:[ path add: $/ . ] .
    path add: 'Deprecated';  add: System gemProcessId asString; add: '.log' .
    tmps at: key put: path . "cache the path "        
    path.
  ] onException: Error do:[:ex |  
    ex return: nil
  ]
%
category: 'Instance initialization'
method: Deprecated
initialize
  gsNumber := ERR_Deprecated.
  gsResumable := true .
  gsTrappable := true .
%

! fixed 43624
category: 'signaledException'
method: Deprecated
defaultAction

  DeprecationEnabled ifNil:[ "ignore" ] 
    ifNotNil:[ :action | 
       action == #'error' ifTrue: [ self _signalGciError ]
                    ifFalse:[ self recordStackToLog: action ]
    ]
%

category: 'signaledException'
method: Deprecated
recordStackToLog: action

 [ | eol string |
   action == #logstack ifTrue:[
     eol := '
    ' .
     (string := 'Deprecated method call at ' , DateAndTime now printStringWithRoundedSeconds) 
       add: eol;
       add: self description ; add: eol .
       string add: (GsProcess stackReportToLevel: 20) ; lf .
   ] ifFalse:[
     string := self description . string lf 
   ].
   self class logFile ifNotNil:[ :f|
     f nextPutAll: string; flush .  
   ] ifNil:[
     GsFile gciLogServer: string
   ] 
 ] onSynchronous: AbstractException do:[:ex |
    ex return: nil  "ignore the exception"
 ]
%


! replace methods from object.gs now that class Deprecated is defined
! fixes 43457

category: 'Deprecated Notification'
method: Object 
deprecated: aString
  "Methods that send this message are considered deprecated, with <aString> providing
   details on the deprecation.  <aString> should include the class and method name, 
   the version in which the method is deprecated, and what to do instead.  
   Deprecated methods are supported for the current version, but may be removed in 
   a future release."

  DeprecationEnabled ifNotNil:[ ^ Deprecated signal: aString ].
  ^ self
%

method: Object
deprecatedNotification: aString
  "Methods that send this message are considered deprecated, with <aString> providing
   details on the deprecation.  See Object>>deprecated: for details."

  DeprecationEnabled ifNil:[ ^ self "ignore" ].
  Deprecated signal: aString.
%

