fileformat utf8
set compile_env: 0
! ------------------- Class definition for GciErrSType
expectvalue /Class
doit
CByteArray subclass: 'GciErrSType'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #( disallowGciStore)

%
expectvalue /Class
doit
GciErrSType comment: 
'
	"$GEMSTONE/include/gci.ht line 221
/*========================================================================
 *  GCI Error message specification
 *========================================================================
 */

class GciErrSType {
public:
  OopType       category;                      /* error dictionary       */
  OopType       context;  /* GemStone Smalltalk execution state , a GsProcess */
  OopType       exceptionObj;  /* an instance of AbstractException, or nil; may be nil
                                 if error was not signaled from Smalltalk execution */
  OopType       args[GCI_MAX_ERR_ARGS];        /* arguments to error text */
  int          number;                        /* GemStone error number  */
  int          argCount;                      /* num of arg in the args[]*/
  unsigned char fatal;                         /* nonzero if err is fatal */
  // Since Gs64 v3.2.0  message and reason are Utf8 .
  char          message[GCI_ERR_STR_SIZE + 1]; /* null-termated Utf8 error text */
  char          reason[GCI_ERR_reasonSize + 1]; /* null terminated Utf8 */

  // If you change this struct,  Smalltalk client FFI code may
  //  need smalltalk code changes.

  inline void init(void) {
    category = OOP_NIL;
    exceptionObj = OOP_NIL;
    number = 0;
    context = OOP_NIL;
    argCount = 0;
    fatal = FALSE;
    message[0] = ''\0'';
    reason[0] = ''\0'';
    args[0] = OOP_ILLEGAL;
  }

  GciErrSType() { init(); }
  ~GciErrSType() { }

  GciErrSType(GciErrSType *src);

  void setError(int errNum, const char* msg);
  void setFatalError(int errNum, const char* msg);

  void appendStr(const char* str); // appends str to message
};"
'
%
! ------------------- Remove existing behavior from GciErrSType
expectvalue /Metaclass3       
doit
GciErrSType removeAllMethods.
GciErrSType class removeAllMethods.
%
set compile_env: 0
! ------------------- Class methods for GciErrSType
category: 'Instance Creation'
classmethod: GciErrSType
new

	^self gcMalloc: 2168.
%
category: 'Instance Creation'
classmethod: GciErrSType
on: aCByteArray

	^self withAll: aCByteArray.
%
! ------------------- Instance methods for GciErrSType
category: 'Accessing'
method: GciErrSType
argCount

	^self int32At: 108.
%
category: 'Updating'
method: GciErrSType
argCount: anObject

	self 
		int32At: 108
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
args

	| array offset |
	array := Array new: 10.
	offset := 24.
	1 to: array size do: [:i | 
		array at: i put: (self uint64At: offset).
		offset := offset + 8.
	].
	^array.
%
category: 'Updating'
method: GciErrSType
args: aSequenceableCollection

	| offset |
	offset := 24.
	1 to: aSequenceableCollection size do: [:i | 
		self 
			uint64At: offset
			put: (aSequenceableCollection at: i).
		offset := offset + 8.
	].
%
category: 'Accessing'
method: GciErrSType
category

	^self uint64At: 0.
%
category: 'Updating'
method: GciErrSType
category: anObject

	self 
		uint64At: 0
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
context

	^self uint64At: 8.
%
category: 'Updating'
method: GciErrSType
context: anObject

	self 
		uint64At: 8
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
exceptionObj

	^self uint64At: 16.
%
category: 'Updating'
method: GciErrSType
exceptionObj: anObject

	self 
		uint64At: 16
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
fatal

	^self uint8At: 112.
%
category: 'Updating'
method: GciErrSType
fatal: anObject

	self 
		uint8At: 112
		put: anObject.
%
category: 'Initialization'
method: GciErrSType
initialize
%
category: 'Initialization'
method: GciErrSType
initialize: aCByteArray

	1 to: (self size min: aCByteArray size) do: [:i | 
		self uint8At: i put: (aCByteArray uint8At: i).
	].
%
category: 'Accessing'
method: GciErrSType
message

	^self _stringFromBytes: (self 
		byteArrayFrom: 113
		to: 1137).
%
category: 'Updating'
method: GciErrSType
message: aByteArray

	self
		replaceFrom: 113
		to: 112 + (1025 min: aByteArray size)
		with: aByteArray
		startingAt: 1.
%
category: 'Accessing'
method: GciErrSType
number

	^self int32At: 104.
%
category: 'Updating'
method: GciErrSType
number: anObject

	self 
		int32At: 104
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
reason

	^self _stringFromBytes: (self 
		byteArrayFrom: 1138
		to: 2162).
%
category: 'Updating'
method: GciErrSType
reason: aByteArray

	self
		replaceFrom: 1138
		to: 1137 + (1025 min: aByteArray size)
		with: aByteArray
		startingAt: 1.
%
category: 'Conversion'
method: GciErrSType
_stringFromBytes: aByteArray

	| index |
	index := aByteArray indexOf: 0.
	^aByteArray
		at: 1 
		sizeBytes: 1 
		stringSize: (0 == index ifTrue: [aByteArray size] ifFalse: [index - 1]).
%
