! ========================================================================
! GciError.gs
!
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
! ========================================================================

expectvalue %String
doit
(Error subclass: 'GciError'
	instVarNames: #( gciErrSType externalSession originalNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #()) definition
%

! ------------------- Class comment for GciError
doit
GciError comment: 
'This class is part of the External Sessions implementation and 
represents an execution Error from the GCI interface to the external session.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	gciErrSType: Object
	externalSession: Object
	originalNumber: Object
'.
true
%

doit
GciError category: 'External Sessions'.
true
%

! Remove existing behavior from GciError
doit
GciError removeAllMethods.
GciError class removeAllMethods.
true
%
! ------------------- Class methods for GciError
category: 'signalling'
set compile_env: 0
classmethod: GciError
signal: aGciErrSType in: anExternalSession
	self new
		signal: aGciErrSType 
		in: anExternalSession
    details: nil 
%
classmethod: GciError
signal: aGciErrSType in: anExternalSession details: aString
	self new
		signal: aGciErrSType 
		in: anExternalSession
    details: aString 
%
! ------------------- Instance methods for GciError
category: 'accessing'
set compile_env: 0
method: GciError
actualExceptionClassOr: aBlock
	"Answer the class of the actual exception if there is one,
	 or the result of evaluating aBlock if not."

	| actualCls |
	actualCls := (LegacyErrNumMap atOrNil: self number ) ifNotNil: [ :a | a atOrNil: 1].
	^actualCls ifNil: aBlock
%
category: 'accessing'
set compile_env: 0
method: GciError
category

	^gciErrSType category.
%
category: 'updating'
set compile_env: 0
method: GciError
clearStack

  (originalNumber ~~ nil and:[ originalNumber < 4000]) ifTrue:[
         externalSession clearStackFor: gciErrSType .
  ].
%
category: 'accessing'
set compile_env: 0
method: GciError
context

	^gciErrSType context.
%
category: 'updating'
set compile_env: 0
method: GciError
continue
	"Continue code execution in GemStone after an error.
	See GciContinue() in the GemBuilder for C manual for details."

	^externalSession continue: gciErrSType context.
%
category: 'updating'
set compile_env: 0
method: GciError
continueWith: anObject
	"This function is a variant of the continue method, except 
	that it allows you to modify the call stack before attempting 
	to continue the suspended Smalltalk execution.
	See GciContinueWith() in the GemBuilder for C manual for details."

	^externalSession 
		continue: gciErrSType context
		with: anObject.
%
category: 'accessing'
set compile_env: 0
method: GciError
externalErrorNumber

	^gciErrSType number.
%
category: 'accessing'
set compile_env: 0
method: GciError
gciErrSType 

	^gciErrSType
%
category: 'testing'
set compile_env: 0
method: GciError
matchesClasses: expClass
	"expClass is either a Class or an Array of Classes"

	| actualCls |
	actualCls := self actualExceptionClassOr: [^false].
	expClass _isArray
		ifTrue: [^expClass anySatisfy: [:aCls | actualCls isSubclassOf: aCls]]
		ifFalse: [^actualCls isSubclassOf: expClass]
%
category: 'accessing'
set compile_env: 0
method: GciError
originalNumber
  ^ originalNumber
%
category: 'signalling'
set compile_env: 0
method: GciError
signal: aGciErrSType in: anExternalSession
  ^ self signal: aGciErrSType in: anExternalSession details: nil 
%
method: GciError
error: aGciErrSType in: anExternalSession details: aString
  self _error: aGciErrSType in: anExternalSession .
	self stack ifNotNil: [:stack | messageText lf ; add: stack].
  aString ifNotNil:[ messageText add:', '; add: aString asString].
  self details: messageText. 
%
method: GciError
signal: aGciErrSType in: anExternalSession details: aString
  self error: aGciErrSType in: anExternalSession details: aString ;
     signal .
%

method: GciError
_error: aGciErrSType in: anExternalSession
	gciErrSType := aGciErrSType.
	externalSession := anExternalSession.
  aGciErrSType ifNil:[
    originalNumber := 4100 "GCI_ERR_BAD_SESSION_ID".
    messageText := 'invalid session' copy .
  ] ifNotNil:[
     (originalNumber := gciErrSType number) == 1001 ifTrue: [^self signalCompileError].
     messageText := gciErrSType message .
     messageText size > 0 ifTrue:[ messageText addAll:', ' ].
     messageText add: gciErrSType reason .
  ].
	"avoid killing current session with fatal errors"
	(originalNumber between: 4000 and: 4999) ifTrue: [
		messageText add: ' original number: ' , originalNumber asString.
		"and self number is inherited value 2710"
	] ifFalse: [
		self _number: originalNumber.
	].
%


category: 'signalling'
set compile_env: 0
method: GciError
signalCompileError

	| delimiter |
	self details: gciErrSType message.
	gsArgs := gciErrSType args.
	gsArgs size: gciErrSType argCount.
	gsArgs := gsArgs collect: [:each | 
		externalSession resolveResult: each toLevel: 4.
	].
	messageText := String withAll: 'Compile error(s): '.
	delimiter := ''.
	gsArgs first do: [:each | 
		messageText
			addAll: delimiter;
			addAll: (each at: 3);
			addAll: ' (error #';
			addAll: (each at: 1) printString;
			addAll: ') at offset ';
			addAll: (each at: 2) printString.
		delimiter := '; '.
	].
	self signal.
%
category: 'accessing'
set compile_env: 0
method: GciError
stack
  gciErrSType ifNil:[ ^ nil ].
	gciErrSType context == nil asOop ifTrue: [^nil].	"NO CALL IN PROGRESS"
	self externalErrorNumber >= 4000 ifTrue: [^nil].	"NOT A RUNTIME ERROR"
  ^ externalSession _getStackForOop: gciErrSType context .
%
