!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! file  GsNMethodIr.gs
!  support for invoking code generator from Smalltalk
! 
!=========================================================================
run
(GsCurrentSession currentSession resolveSymbol: #GsComMethNode) ifNil:[
  "need   
     System myUserProfile symbolList add: GsCompilerClasses .
   commit , logout, login 
  "
  Error signal:'You must add GsCompilerClasses to your symbolList.'
].
true
%

set class GsNMethod

category: 'Compiler Access'

run
(GsNMethod _classVars associationAt:#TraceIR)
  objectSecurityPolicy: DataCuratorObjectSecurityPolicy  .
true
%

classmethod:
traceIR: anInt

 "set value of class variable controlling printing of IR inputs to
  generateFromIR: .  printing is with GsFile gciLogServer:  .

  anInt == 0 means  no tracing ,
        == 1 means  log source line number of each method node
        == 2 means  full print of IR graph for each method
"

  TraceIR := anInt .
%

classmethod:
generateFromIR: aGsComMethNode

 "Invokes the code generator to generate an instance of GsNMethod from the
  specified IR graph.
  May be used for anonymous methods or for methods to be installed in a class.
  Caller of this method is responsible for installing in the
  method dictionary of an appropriate class.

  Returns a GsNMethod if the compilation
  succeeded with no warnings or errors, or an Array of of the form
    { (GsNMethod , or nil if the compilation has errors) .
       (nil or an Array of error descriptors as described for
        compileMethod:dictionaries:category: ) .
       (nil or a String describing warnings)
     } .

  Each element of the 'Array of error descriptors'
  is an Array of size 3 or 4, containing the elements:
   1. The GemStone error number.
   2. Offset into the source string where the error occurred.
   3. Error message text, if available, or nil.
   4. Internal compiler error text, if the error is internal.
 "
TraceIR ~~ 0 ifTrue:[
  TraceIR == 1 ifTrue:[
    aGsComMethNode fileName ifNotNil:[
      GsFile gciLogServer: '--IR: ' , aGsComMethNode summary
    ].
  ].
  TraceIR > 1 ifTrue:[ | strm |
    strm := IndentingStream newPrinting .
    aGsComMethNode printFormattedOn: strm .
    GsFile gciLogServer: strm contents .
    "  following code to be enabled after filein for debugging only,"
    "  SessionTemps not defined at this point in slowfilein  "
    " false ifTrue:[ |  hist |
        hist := SessionTemps current at:#AllIrs otherwise: nil .
        hist == nil ifTrue:[
           SessionTemps current at:#AllIrs put:( hist := { } ).
        ].
        hist addLast: aGsComMethNode .
      ].
    "
  ].
].
^ self _generateFromIR: aGsComMethNode
%

classmethod:
_generateFromIR: aGsComMethNode

 "Invokes the code generator to generate an instance of GsNMethod from the
  specified IR graph.
  May be used for anonymous methods or for methods to be installed in a class.
  Caller of this method is responsible for installing in the
  method dictionary of an appropriate class.

  Returns a GsNMethod if the compilation
  succeeded with no warnings or errors, or an Array of of the form
    { (GsNMethod , or nil if the compilation has errors) .
       (nil or an Array of error descriptors as described for
        compileMethod:dictionaries:category: ) ,
       (nil or a String describing warnings)
    }  .

  Each element of the 'Array of error descriptors'
  is an Array of size 3 or 4, containing the elements:
   1. The GemStone error number.
   2. Offset into the source string where the error occurred.
   3. Error message text, if available, or nil.
   4. Internal compiler error text, if the error is internal.
 "

<primitive: 679>
self _primitiveFailed: #generateFromIR: args: { aGsComMethNode }
%


