!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!
! $Id: setpathterm.gs 31614 2013-10-09 17:47:16Z dhenrich $
!
! classes created in idxclasses.topaz
!=========================================================================

! ------------------- Class comment for AbstractBagEnumerator
expectvalue %Boolean
doit
AbstractBagEnumerator comment: 
'AbstractBagEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from AbstractBagEnumerator
removeallmethods AbstractBagEnumerator
removeallclassmethods AbstractBagEnumerator

! ------------------- Class methods for AbstractBagEnumerator
! ------------------- Instance methods for AbstractBagEnumerator
category: 'accessing'
set compile_env: 0
method: AbstractBagEnumerator
evaluator: anEvaluator
  evaluator := anEvaluator.
  bag := evaluator nsc _asIdentityBag
%
category: 'querying'
set compile_env: 0
method: AbstractBagEnumerator
findAllValuesFor: aValue
  ^ self findAllValuesFor: aValue and: nil
%
category: 'querying'
set compile_env: 0
method: AbstractBagEnumerator
findAllValuesFor: aValue1 and: aValue2
  | theBlock tmpHolder result |
  theBlock := doBlock.
  theBlock
    ifNil: [ 
      tmpHolder := evaluator tmpHolder.
      theBlock := [ :each | tmpHolder add: each ] ].
  result := evaluator isIndexOnRootNsc
    ifTrue: [ self _findRootValues: aValue1 and: aValue2 do: theBlock ]
    ifFalse: [ 
      evaluator isCollectionBased
        ifTrue: [ self _findTraversedCollectionBasedValues: aValue1 and: aValue2 do: theBlock ]
        ifFalse: [ 
          self _createIvOffsetCache.
          self _findTraversedValues: aValue1 and: aValue2 do: theBlock ] ].
  ^ doBlock ifNil: [ tmpHolder completeBag ] ifNotNil: [ result ]
%
category: 'accessing'
set compile_env: 0
method: AbstractBagEnumerator
selector: aSelector
  selector := aSelector
%
category: 'traversing'
set compile_env: 0
method: AbstractBagEnumerator
traversePathFor: anObject endObjDo: aBlock
  | endObj |
  self _createIvOffsetCache.
  endObj := self _traversePathForObject: anObject.
  endObj ~~ #'_incompletePathTraversal'
    ifTrue: [ aBlock value: endObj ]
%
category: 'testing'
set compile_env: 0
method: AbstractBagEnumerator
value: aValue and: ignored test: endObj
  ^ endObj perform: selector with: aValue
%
category: 'private'
set compile_env: 0
method: AbstractBagEnumerator
_createIvOffsetCache
  self _createIvOffsetCacheFor: evaluator
%
category: 'private'
set compile_env: 0
method: AbstractBagEnumerator
_findNonNilRootValues: aValue1 and: aValue2 do: aBlock
  1 to: bag size do: [ :i | 
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [ 
        (self value: aValue1 and: aValue2 test: obj)
          ifTrue: [ aBlock value: obj ] ] ]
%
category: 'private'
set compile_env: 0
method: AbstractBagEnumerator
_findRootValues: aValue1 and: aValue2 do: aBlock
  1 to: bag size do: [ :i | 
    | obj |
    obj := bag _at: i.
    (self value: aValue1 and: aValue2 test: obj)
      ifTrue: [ aBlock value: obj ] ]
%
category: 'private'
set compile_env: 0
method: AbstractBagEnumerator
_findTraversedCollectionBasedValues: aValue1 and: aValue2 do: aBlock
  | obj |
  1 to: bag size do: [ :i | 
    (obj := bag _at: i) ~~ nil
      ifTrue: [ 
        evaluator
          traverse: obj
          do: [ :endObj | 
            (self value: aValue1 and: aValue2 test: endObj)
              ifTrue: [ aBlock value: obj ] ] ] ]
%
category: 'private'
set compile_env: 0
method: AbstractBagEnumerator
_findTraversedValues: aValue1 and: aValue2 do: aBlock
  "This method assumes that the evaluator is not over a collection-based instance variable."

  1 to: bag size do: [ :i | 
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [ 
        | endObj |
        endObj := evaluator
          _traverse: obj
          cachedOffsets: ivOffsetCache2
          cachedClasses: ivOffsetCache1
          incomplete: #'_incompletePathTraversal'.
        endObj ~~ #'_incompletePathTraversal'
          ifTrue: [ 
            (self value: aValue1 and: aValue2 test: endObj)
              ifTrue: [ aBlock value: obj ] ] ] ]
%
category: 'private'
set compile_env: 0
method: AbstractBagEnumerator
_traversePathForObject: obj
  "This method assumes that the evaluator is not over a collection-based instance variable."

  ^ evaluator
    _traverse: obj
    cachedOffsets: ivOffsetCache2
    cachedClasses: ivOffsetCache1
    incomplete: #'_incompletePathTraversal'
%
expectvalue %Boolean
doit
AbstractBagEnumerator category: 'Index-Enumerators'.
true
%

expectvalue %Boolean
! ------------------- Class comment for BagEnumerator
doit
BagEnumerator comment: 
'BagEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from BagEnumerator
removeallmethods BagEnumerator
removeallclassmethods BagEnumerator

! ------------------- Class methods for BagEnumerator
! ------------------- Instance methods for BagEnumerator
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareEqual
  selector := #'_idxForCompareEqualTo:'
%
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareGreaterThan
  selector := #'_idxForCompareGreaterThan:'
%
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareGreaterThanOrEqual
  selector := #'_idxForCompareGreaterThanOrEqualTo:'
%
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareIdentical
  selector := #'=='
%
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareLessThan
  selector := #'_idxForCompareLessThan:'
%
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareLessThanOrEqual
  selector := #'_idxForCompareLessThanOrEqualTo:'
%
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareNotEqual
  selector := #'_idxForCompareNotEqualTo:'
%
category: 'accessing'
set compile_env: 0
method: BagEnumerator
compareNotIdentical
  selector := #'~~'
%
expectvalue %Boolean
doit
BagEnumerator category: 'Index-Enumerators'.
true
%


expectvalue %Boolean
! ------------------- Class comment for BagUnicodeEnumerator
doit
BagUnicodeEnumerator comment: 
'BagUnicodeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from BagUnicodeEnumerator
removeallmethods BagUnicodeEnumerator
removeallclassmethods BagUnicodeEnumerator

! ------------------- Class methods for BagUnicodeEnumerator
! ------------------- Instance methods for BagUnicodeEnumerator
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareEqual
  selector := #'_idxForCompareEqualTo:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
evaluator: anEvaluator
  super evaluator: anEvaluator.
  collator := anEvaluator collator
%
category: 'testing'
set compile_env: 0
method: BagUnicodeEnumerator
value: aValue and: ignored test: endObj
  ^ endObj perform: selector with: aValue with: collator
%
expectvalue %Boolean
doit
BagUnicodeEnumerator category: 'Index-Enumerators'.
true
%

expectvalue %Boolean
! ------------------- Class comment for BagRangeEnumerator
doit
BagRangeEnumerator comment: 
'BagRangeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from BagRangeEnumerator
removeallmethods BagRangeEnumerator
removeallclassmethods BagRangeEnumerator

! ------------------- Class methods for BagRangeEnumerator
! ------------------- Instance methods for BagRangeEnumerator
category: 'accessing'
set compile_env: 0
method: BagRangeEnumerator
compareGreaterThanAndLessThan
  selector := #'_idxForCompareGreaterThan:'.
  selector2 := #'_idxForCompareLessThan:'
%
category: 'accessing'
set compile_env: 0
method: BagRangeEnumerator
compareGreaterThanAndLessThanOrEqual
  selector := #'_idxForCompareGreaterThan:'.
  selector2 := #'_idxForCompareLessThanOrEqualTo:'
%
category: 'accessing'
set compile_env: 0
method: BagRangeEnumerator
compareGreaterThanOrEqualAndLessThan
  selector := #'_idxForCompareGreaterThanOrEqualTo:'.
  selector2 := #'_idxForCompareLessThan:'
%
category: 'accessing'
set compile_env: 0
method: BagRangeEnumerator
compareGreaterThanOrEqualAndLessThanOrEqual
  selector := #'_idxForCompareGreaterThanOrEqualTo:'.
  selector2 := #'_idxForCompareLessThanOrEqualTo:'
%
category: 'testing'
set compile_env: 0
method: BagRangeEnumerator
value: aValue1 and: aValue2 test: endObj
  ^ (endObj perform: selector with: aValue1)
    and: [ endObj perform: selector2 with: aValue2 ]
%
expectvalue %Boolean
doit
BagRangeEnumerator category: 'Index-Enumerators'.
true
%
category: 'accessing'
set compile_env: 0
method: AbstractBagEnumerator
doBlock: aBlock
  doBlock := aBlock
%
category: 'private'
set compile_env: 0
method: AbstractBagEnumerator
_createIvOffsetCacheFor: anEvaluator
  | cache |
  cache := anEvaluator _createIvOffsetCache.
  ivOffsetCache1 := cache at: 1.
  ivOffsetCache2 := cache at: 2
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareGreaterThan
  selector := #'_idxForCompareGreaterThan:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareGreaterThanOrEqual
  selector := #'_idxForCompareGreaterThanOrEqualTo:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareIdentical
  "use BagEnumerator for identity comparisons"

  self shouldNotImplement: #'compareIdentical'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareLessThan
  selector := #'_idxForCompareLessThan:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareLessThanOrEqual
  selector := #'_idxForCompareLessThanOrEqualTo:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareNotEqual
  selector := #'_idxForCompareNotEqualTo:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeEnumerator
compareNotIdentical
  "use BagEnumerator for identity comparisons"

  self shouldNotImplement: #'compareNotIdentical'
%

! Remove existing behavior from PathPathBagEnumerator
removeallmethods PathPathBagEnumerator
removeallclassmethods PathPathBagEnumerator

expectvalue %Boolean
! ------------------- Class comment for PathPathBagEnumerator
doit
PathPathBagEnumerator comment:
'PathPathBagEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! ------------------- Class methods for PathPathBagEnumerator
! ------------------- Instance methods for PathPathBagEnumerator
category: 'accessing'
set compile_env: 0
method: PathPathBagEnumerator
evaluator2: anObject

   "Modify the value of the instance variable 'evaluator2'."
   evaluator2 := anObject
%
category: 'querying'
set compile_env: 0
method: PathPathBagEnumerator
findAllValues
  | theBlock tmpHolder result |
  theBlock := doBlock.
  theBlock
    ifNil: [ 
      tmpHolder := evaluator tmpHolder.
      theBlock := [ :each | tmpHolder add: each ] ].
  result := evaluator isIndexOnRootNsc
    ifTrue: [ 
      self _createIvOffsetCacheFor: evaluator2.
      self _findRootValuesDo: theBlock ]
    ifFalse: [ 
      evaluator2 isIndexOnRootNsc
        ifTrue: [ 
          self _createIvOffsetCacheFor: evaluator.
          self _findRootValuesDo: theBlock ]
        ifFalse: [ 
          evaluator isCollectionBased
            ifTrue: [ self _findTraversedCollectionBasedValuesDo: theBlock ]
            ifFalse: [ 
              self _createIvOffsetCache.
              self _createIvOffsetCache2For: evaluator2.
              self _findTraversedValuesDo: theBlock ] ] ].
  ^ doBlock ifNil: [ tmpHolder completeBag ] ifNotNil: [ result ]
%
category: 'querying'
set compile_env: 0
method: PathPathBagEnumerator
findAllValuesFor: aValue1
  self shouldNotImplement: #'findAllValuesFor:'
%
category: 'querying'
set compile_env: 0
method: PathPathBagEnumerator
findAllValuesFor: aValue1 and: aValue2
  self shouldNotImplement: #'findAllValuesFor:and:'
%
category: 'testing'
set compile_env: 0
method: PathPathBagEnumerator
value: aValue and: ignored test: endObj
  self shouldNotImplement: #'value:and:test:'
%
category: 'testing'
set compile_env: 0
method: PathPathBagEnumerator
value: aValue test: endObj
  ^ evaluator isIndexOnRootNsc
    ifTrue: [ endObj perform: selector with: aValue ]
    ifFalse: [ aValue perform: selector with: endObj ]
%
category: 'querying'
set compile_env: 0
method: PathPathBagEnumerator
_createIvOffsetCache2For: anEvaluator
  | cache |
  cache := anEvaluator _createIvOffsetCache.
  ivOffsetCache3 := cache at: 1.
  ivOffsetCache4 := cache at: 2
%
category: 'querying'
set compile_env: 0
method: PathPathBagEnumerator
_findRootValuesDo: aBlock
  "evaluator isIndexOnRootNsc ... true"

  1 to: bag size do: [ :i | 
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [ 
        | endObj |
        endObj := evaluator2
          _traverse: obj
          cachedOffsets: ivOffsetCache2
          cachedClasses: ivOffsetCache1
          incomplete: #'_incompletePathTraversal'.
        endObj ~~ #'_incompletePathTraversal'
          ifTrue: [ 
            (self value: obj test: endObj)
              ifTrue: [ aBlock value: obj ] ] ] ]
%
category: 'querying'
set compile_env: 0
method: PathPathBagEnumerator
_findTraversedCollectionBasedValuesDo: aBlock
  | obj |
  1 to: bag size do: [ :i | 
    (obj := bag _at: i) ~~ nil
      ifTrue: [ 
        evaluator
          traverse: obj
          do: [ :endObj1 | 
            evaluator2
              traverse: obj
              do: [ :endObj2 | 
                (self value: endObj1 test: endObj2)
                  ifTrue: [ aBlock value: obj ] ] ] ] ]
%
category: 'querying'
set compile_env: 0
method: PathPathBagEnumerator
_findTraversedValuesDo: aBlock
  "This method assumes that the evaluator is not over a collection-based instance variable."

  1 to: bag size do: [ :i | 
    | obj |
    (obj := bag _at: i) ~~ nil
      ifTrue: [ 
        | endObj1 |
        endObj1 := evaluator
          _traverse: obj
          cachedOffsets: ivOffsetCache2
          cachedClasses: ivOffsetCache1
          incomplete: #'_incompletePathTraversal'.
        endObj1 ~~ #'_incompletePathTraversal'
          ifTrue: [ 
            | endObj2 |
            endObj2 := evaluator2
              _traverse: obj
              cachedOffsets: ivOffsetCache4
              cachedClasses: ivOffsetCache3
              incomplete: #'_incompletePathTraversal'.
            endObj2 ~~ #'_incompletePathTraversal'
              ifTrue: [ 
                (self value: endObj1 test: endObj2)
                  ifTrue: [ aBlock value: obj ] ] ] ] ]
%

expectvalue %Boolean
doit
PathPathBagEnumerator category: 'Index-Enumerators'.
true
%

! ------------------- Class comment for PathPathBagUnicodeEnumerator
expectvalue %Boolean
doit
PathPathBagUnicodeEnumerator comment:
'PathPathBagUnicodeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from PathPathBagUnicodeEnumerator
removeallmethods PathPathBagUnicodeEnumerator
removeallclassmethods PathPathBagUnicodeEnumerator

! ------------------- Class methods for PathPathBagUnicodeEnumerator
! ------------------- Instance methods for PathPathBagUnicodeEnumerator
category: 'accessing'
set compile_env: 0
method: PathPathBagUnicodeEnumerator
evaluator: anEvaluator
  super evaluator: anEvaluator.
  collator := anEvaluator collator
%
category: 'accessing'
set compile_env: 0
method: PathPathBagUnicodeEnumerator
value: aValue test: endObj
  ^ evaluator isIndexOnRootNsc
    ifTrue: [ endObj perform: selector with: aValue with: collator ]
    ifFalse: [ aValue perform: selector with: endObj with: collator ]
%

expectvalue %Boolean
doit
PathPathBagUnicodeEnumerator category: 'Index-Enumerators'.
true
%

! ------------------- Class comment for BagUnicodeRangeEnumerator
expectvalue %Boolean
doit
BagUnicodeRangeEnumerator comment:
'BagUnicodeRangeEnumerator is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from BagUnicodeRangeEnumerator
removeallmethods BagUnicodeRangeEnumerator
removeallclassmethods BagUnicodeRangeEnumerator

! ------------------- Class methods for BagUnicodeRangeEnumerator
! ------------------- Instance methods for BagUnicodeRangeEnumerator
category: 'accessing'
set compile_env: 0
method: BagUnicodeRangeEnumerator
compareGreaterThanAndLessThan
  selector := #'_idxForCompareGreaterThan:collator:'.
  selector2 := #'_idxForCompareLessThan:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeRangeEnumerator
compareGreaterThanAndLessThanOrEqual
  selector := #'_idxForCompareGreaterThan:collator:'.
  selector2 := #'_idxForCompareLessThanOrEqualTo:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeRangeEnumerator
compareGreaterThanOrEqualAndLessThan
  selector := #'_idxForCompareGreaterThanOrEqualTo:collator:'.
  selector2 := #'_idxForCompareLessThan:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeRangeEnumerator
compareGreaterThanOrEqualAndLessThanOrEqual
  selector := #'_idxForCompareGreaterThanOrEqualTo:collator:'.
  selector2 := #'_idxForCompareLessThanOrEqualTo:collator:'
%
category: 'accessing'
set compile_env: 0
method: BagUnicodeRangeEnumerator
evaluator: anEvaluator
  super evaluator: anEvaluator.
  collator := anEvaluator collator
%
category: 'testing'
set compile_env: 0
method: BagUnicodeRangeEnumerator
value: aValue1 and: aValue2 test: endObj
  ^ (endObj perform: selector with: aValue1 with: collator)
    and: [ endObj perform: selector2 with: aValue2 with: collator ]
%
expectvalue %Boolean
doit
BagUnicodeRangeEnumerator category: 'Index-Enumerators'.
true
%

