!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Description - 
!   This file contains the subset of bomlast.gs used for 
!   both initial filein and repository upgrade. 
!   (bomlast.gs is not used for upgrade).
!=========================================================================

! Fix up methods that would have contained forward reference to PrintStream.
!  PrintStream requires execution to create class; execution not
!  possible until filein2 stage, but we need Object>>printString in 
!  filein1 in order to make topaz execution work ... 
category: 'Formatting'

method: Object
describe

"Returns an instance of a subclass of CharacterCollection describing the
 receiver.  This method is required by Topaz and by GemStone internal error
 handling.  Any reimplementation must conform to the following rules:

 * This method must not return nil.

 * This method must return an instance of a subclass of CharacterCollection."

^ [ self printString ] onException: Error do:[:ex | '<error during Object>>describe>' ]
%

method: Object
describe1K

"Returns an instance of a subclass of CharacterCollection describing the
 receiver.   Result has a max size of 1024 elements.
 This method is required by Topaz and by GemStone internal error
 handling.  Any reimplementation must conform to the following rules:
 
 * This method must not return nil.
 
 * This method must return an instance of a subclass of CharacterCollection."
  
^ [ | ws |
    ws := PrintStream printingOn: String new maxSize: 1024 .
    self printOn: ws.
    ws _collection
  ] onException: Error do:[:ex | '<error during Object>>describe1K>' ]
% 


method: Object
printString

"Returns a CharacterCollection whose contents are a displayable representation of the
 receiver."

"This method uses the printOn: method to create the String."

| ws str |

str := String new.

ws := PrintStream printingOn: str.  

self printOn: ws.
 "contents might have been converted to another subclass of CharacterCollection."
^ ws _collection
%


! compile methods that contain forward references to Float if they are compiled
! earlier in the filein when building a fresh GemStone repository.

! fixed 46702
category: 'Converting'
method: Integer
asDecimalFloat

"Returns a DecimalFloat representing the receiver."

<primitive: 137>

| factor sum radix |

sum := 0.0F0 .
radix := 4294967295.0F0 .
factor := self sign asFloat.
1 to: self size do: [:i |
  sum := (self _digitAt: i) * factor + sum.
  factor := factor * radix 
].
^sum
%

category: 'Truncation and Rounding'
method: Number
ceiling

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as positive infinity.  In particular, returns the
 receiver if the receiver is an integer."

(self <= 0.0)
   ifTrue: [^self truncated]
   ifFalse: [^self negated floor negated truncated]
%

category: 'Arithmetic'
method: Number
degreesToRadians

"Assuming the receiver represents an angle in degrees, returns the angle
 in radians."

^ self / 57.29577951308232
%

category: 'Arithmetic'
method: Number
radiansToDegrees

"Assuming the receiver represents an angle in radians, returns the angle
 in degrees."

^ self * 57.29577951308232
%

method: GsMethodDictionary
rebuildTable: newSize

"Rebuilds the method dictionary by populating a larger method dictionary
 first and doing a (primitive) become:"

"This is a reimplementation of the method in object.gs to handle
instances that have a dependency list."

<primitive: 2001>
| prot |
prot := System _protectedMode .
[
  | newGsMethodDict depList |

  tableSize = newSize ifTrue:[ 
    ^ self "no change in table size" 
  ].
  collisionLimit == 536870911 ifTrue:[
    ^ self 		"avoid recursive rebuild"
  ].

  newGsMethodDict := self class new: (newSize * 2).
  newGsMethodDict valueConstraint: valueConstraint.
  newGsMethodDict keyConstraint: keyConstraint.
  
  self keysAndValuesDo: [ :aKey :aValue |
    newGsMethodDict at: aKey put: aValue.
    ].
  
  (depList := DependencyList for: self) ~~ nil
    ifTrue: [ DependencyList set: nil for: self ].
  
  newGsMethodDict _becomeDictionary: self.
  
  depList ~~ nil
    ifTrue: [ DependencyList set: depList for: self ].
] ensure:[
  prot _leaveProtectedMode
]
%

expectvalue %String
run
  "Per ANSI 5.6.8  , additional names for Float, to fix bug 40876"
| report |
report := String new .
{ #FloatE . #FloatD . #FloatQ } do:[:k |
  (Globals includesKey: k) ifFalse:[
     Globals at: k put: Float .
     (Globals associationAt: k) immediateInvariant .
     report add: 'added ' ; add: k ; lf .
  ].
].
report
%

!--------------------------------------

category: 'Repository Conversion'
method: Class
_unsafeDisallowSubclasses

""

self _unsafeAt: 2 "offset of format"
           put: (format bitOr: 32 "subclasses disallowed bit") .
self _refreshClassCache: false
%

category: 'Repository Conversion'
method: Class
_unsafeMakeClassNp

""

self _unsafeAt: 2 "offset of format"
           put: (format bitOr: 16r800"instancesNP bit" ) .
self _refreshClassCache: false
%

!--------------------------------------
run
| list |
  list := { Behavior . Class . ObsoleteMetaclass . Repository . UserProfileSet . 
     AbstractUserProfileSet . 
     CompiledMethod . Float . DecimalFloat . SmallFloat . SmallDouble . 
     Symbol . DoubleByteSymbol . 
     UnimplementedFloat1 . UnimplementedFloat2 . 
     MethodContext . Block . SelectionBlock . 
     GsObjectSecurityPolicy . SymbolList . System . UndefinedObject . UserProfile . Boolean . 
     Character . SmallInteger . Integer . LargeInteger . 
     JISCharacter . StackSegment . 
     StackBuffer . Activation . Process . VariableContext . BlockClosure . 

     ExecBlock . ExecutableBlock . SimpleBlock . ComplexBlock . ComplexVCBlock . 
     GsMethod . GsNMethod . GsNativeCode . 
     GsProcess . GsMethodDictionary . GsStackBuffer . 

     SelectBlock . BtreeBasicInteriorNode . BtreeBasicLeafNode . BasicSortNode . 
     RcIndexBucket . RcIndexBucketWithCache . RcIndexDictionary . NscBuilder . 

     "PathTerm . ConstrainedPathTerm . SetValuedPathTerm"  "fix bug 11484"
     }.

  list do: [ :aClass | aClass _unsafeDisallowSubclasses ] .

  list do: [ :aClass |
     aClass subclassesDisallowed ifFalse:[ ^ 'Error on ' , aClass name ].
     ] .
  ^ true
%
run
Semaphore _unsafeMakeClassNp .  "set instancesNonPersistent"
ProcessorScheduler _unsafeMakeClassNp .  "set instancesNonPersistent"
^ true
%

run
Class removeSelector: #_unsafeDisallowSubclasses .
Class removeSelector: #_unsafeMakeClassNp .
^ true
%

!-------------------
expectvalue %SmallInteger
run
"Disallow GCI create/store of instances of Metaclasses.
 We don't patch customer classes.  Newly created metaclasses will get this
 automatically."
| count |
count := 0 .
Class class _structuralUpdatesDisallowed ifFalse:[
  Globals valuesDo:[:v |
    v isBehavior ifTrue:[ | m |
      (m := v class) isMeta ifTrue:[
        m _disallowGciCreateStore . count := count + 1
      ]
    ]
  ].
].
^ count
%
!-------------------
! gss64 v3.2 , disallow structural update on a bunch of classes 
!  to restrict use of instVarAt:put: 
expectvalue %SmallInteger
run
| count |
count := 0 .
Globals valuesDo:[:v |
  (v isBehavior and:[v isSubclassOf: AbstractException]) ifTrue:[
      v _structuralUpdatesDisallowed ifFalse:[
        v _disallowGciCreateStore . count := count + 1 ]
  ]
].
^ count
%
expectvalue %SmallInteger
run
| count |
count := 0 .
{ CBuffer .
  CCallin .
  CCallout .
  CFunction .
  ClassHistory .
  Delay .
  ExecBlock2 .
  GsObjectSecurityPolicy .
  GsProcess .
  GsSocket  .
  GsStackBuffer .
  ProcessorScheduler .
  Semaphore .
  UserSecurityData .
  VariableContext .
} do:[:v |
      v _structuralUpdatesDisallowed ifFalse:[
        v _disallowGciCreateStore . count := count + 1 ] ].
^ count
%
!-------------------
run
| list blk |

" allow adding instance variables to the following classes.  fixes bug 6569"
list := { UserProfile } .

blk := [ :aClass |
          aClass _unsafeAt: 4 "instVarNames"
                 put: (Array withAll: (aClass instVarAt: 4)) .
          aClass _refreshClassCache: false
       ].
list do: blk .
^ true
%
commit

! check some classhistories that were changed in bom.c in 3.4 upgrade/filein
run
| ver | (ver := Symbol currentVersion) == Symbol ifTrue:[ ^ true ] ifFalse:[ ^ ver ]
%
run
| ver | (ver := DoubleByteSymbol currentVersion) == DoubleByteSymbol ifTrue:[ ^ true ] ifFalse:[ ^ ver ]
%
run
| ver | (ver := QuadByteSymbol currentVersion) == QuadByteSymbol ifTrue:[ ^ true ] ifFalse:[ ^ ver ]
%
run
| ver | (ver := String currentVersion) == String ifTrue:[ ^ true ] ifFalse:[ ^ ver ]
%

! adjust existing UserProfiles to grant new inverse privileges
run
| priv setBlk clearBlk inversePrivs newPrivs LF |
System myUserProfile userId = 'SystemUser' ifFalse:[ nil error:'wrong user'].
LF := Character lf .
newPrivs := #( #SessionPriority ) .
inversePrivs := #( #NoPerformOnServer #NoUserAction
             #NoGsFileOnServer #NoGsFileOnClient ) .
setBlk := [ :aUp :anArray :name | 
  anArray do:[ :aPriv | aUp addPrivilege: aPriv ] .
  GsFile gciLogClient:'set ', name , ' priv bits for ' , aUp userId , LF .
].
clearBlk := [ :aUp :anArray :name | 
  anArray do:[ :aPriv | aUp deletePrivilege: aPriv] .
  GsFile gciLogClient:'cleared ', name, ' priv bits for ' , aUp userId , LF .
].
AllUsers do:[ :aUp | | uid |
  uid := aUp userId .
  (UserProfile isSpecialUserId: uid) ifTrue:[
    (uid = 'SystemUser' or:[ uid = 'DataCurator']) ifTrue:[
      clearBlk value: aUp value: inversePrivs value: 'inverse' .
      setBlk value: aUp value: newPrivs value: 'new' .
      uid = 'DataCurator' ifTrue:[ aUp deletePrivilege: #CompilePrimitives].
      uid = 'SystemUser' ifTrue:[ aUp addPrivilege: #CompilePrimitives ].
    ] ifFalse:[  "gcuser, symboluser, nameless"
      setBlk value: aUp value: inversePrivs value: 'inverse' . 
      aUp deletePrivilege: #CompilePrimitives .
    ].
  ] ifFalse:[
    "preexisting customer user profiles not affected. 
     If customers have blindly set all priv bits those Up's need adjustment.
    "
  ].
]. 
^ true
%
level 1
expectvalue %Array
run
(AllUsers userWithId:'SystemUser') privileges
%
expectvalue %Array
run
(AllUsers userWithId:'DataCurator') privileges
%
expectvalue %Array
run
(AllUsers userWithId:'GcUser' ifAbsent:[^ #()] ) privileges
%
expectvalue %Array
run
(AllUsers userWithId:'SymbolUser' ifAbsent:[^ #()]) privileges
%
expectvalue %Array
run
(AllUsers userWithId:'Nameless' ifAbsent:[^ #()]) privileges
%
level 0
commit

expectvalue false
send ConversionStatus at: 1 

!--------------------------------------
! Create class documentation for kernel classes that are only placeholders.

category: 'For Documentation Installation only'
classmethod: System
installPlaceholderDocumentation

" list of placeholder classes for other products "
{ GsfClassDefinitionInfo . GsfModificationLog }
  do: [ :aClass |
    aClass comment: 
aClass name, ' is a placeholder for another related GemStone product that has 
not currently been installed.' 
  ].

" list of placeholder classes within the server "
{ UnimplementedFloat1 . UnimplementedFloat2 }
  do: [ :aClass |
    aClass comment: 
aClass name, ' implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.'. 
  ].
%

!--------------------------------------
! Install class documentation for kernel classes only.

run
| classes |
[ System installPlaceholderDocumentation] on: Deprecated do: [:ex | ex resume].

classes := ClassSet new.
(Globals values) do: [ :each |
  ( (each isKindOf: Class)
      and:[(each class includesSelector: #installDocumentation)] )
  ifTrue: [ classes add: each.  ].
  ].
classes do: [ :aClass | 
  [
    aClass installDocumentation .
    GsFile gciLogServer:'installed doc for ', aClass name  . 
  ] on: Error do:[:ex | | nm |
    nm := [ aClass name ] on: Error do:[:ex | aClass asOop asString ] .
    GsFile gciLogServer:'skipped class ' , nm , ' due to ' , ex asString .
  ]
] .
classes do: [ :aClass |
  [ 
    (aClass class) removeSelector: #installDocumentation .
  ] on: Error do:[:ex | "ignore" ].
  [ 
    (aClass class) removeCategory: 'For Documentation Installation only'.
  ] on: Error do:[:ex | "ignore" ]
].
^true
%
commit

!------------------------------------------------------------
! Make various methods in the indexing subsystem 'protected'
!  now done via compilation directives during method compilation
!------------------------------------------------------------

!------------------------------------------------------------
! Make various classes in the indexing subsystem 'protected'.
! This prevents accessing an instance through structural access
! 31162: also protect classes for code security.
!------------------------------------------------------------
!
run
" list of classes which will be protected "
{ GsObjectSecurityPolicySet . 
   SetValuedPathTerm . 
   SetValuedPathEvaluator . UserSecurityData . 
"31162"
   GsMethod . Class . GsMethodDictionary . SymbolDictionary . SymbolList . 
   UserProfile
 }
    do: [ :aClass | aClass _makeProtected ].

^ true
%
lev 1
obj AbstractCharacter
lev 0
commit

!------------------------------------------------------------
! Build the dictionary of configuration file parameters
!------------------------------------------------------------
run
Globals at:#ConfigurationParameterDict put:
(System _configFileParameterDict) .
^ true
%
!------------------------------------------------------------
! Build the dictionary of software version information parameters
!------------------------------------------------------------
run
"dictionary to translate names to internal identifiers"
Globals at:#VersionParameterDict put:
(System _versionParameterDict) .
^ true
%

! build the set of classes for which instances are disallowed
run
Globals at:#InstancesDisallowed put:
 ( IdentitySet withAll:
  { Activation . Character . Behavior . Block . BlockClosure . Boolean . 
      Class . GsMethod . ComplexBlock . ComplexVCBlock . DateTime . 
      ExecBlock . ExecutableBlock . Float . DecimalFloat . SmallFloat . BinaryFloat . 
      Integer . JISCharacter . 
      LargeInteger . ObsoleteMetaclass . MethodContext . Number . Process . 
      Repository . GsObjectSecurityPolicy . SelectBlock . SelectionBlock . SimpleBlock . 
      SmallInteger . StackBuffer . StackSegment . System . UndefinedObject . 
      UserProfile . VariableContext }) .
^ true
%
commit

!------------------------------------------------------------
! Create collating tables for raw ASCII collating order for use with
! String compare methods  in category 'Other comparisons'
!------------------------------------------------------------
run
| a |
a := String new .
0 to: 255 do:[:j| a add: (Character withValue: j )].
Globals at:#AsciiCollatingTable put: a .
a immediateInvariant .
^ a size == 256
%
run
| a |
a := DoubleByteString new .
0 to: 255 do:[:j| a add: (Character withValue: j )].
Globals at:#DoubleByteAsciiCollatingTable put: a .
a immediateInvariant .
^ a size == 256
%
run
| a |
a := QuadByteString new .
0 to: 255 do:[:j| a add: (Character withValue: j )].
Globals at:#QuadByteAsciiCollatingTable put: a .
a immediateInvariant .
^ a size == 256
%

!-----------
!  ensure bom has created the old canonicalized float zeros

! old oop 1873
expectvalue %Float
obj @239617

! old oop 1875
expectvalue %SmallFloat
obj @239873


! reset weak refs array 
expectvalue true
run
Globals at: #GcWeakReferences put: Array new.
^ true
%

! Define SharedDependencyLists if not present
expectvalue %String
run
(Globals at: #SharedDependencyLists) ifNil: [ 
  Globals at: #SharedDependencyLists put: DepListTable new  .
  ^ 'created SharedDependencyLists'
].
^ 'SharedDependencyLists unchanged'
%

! add legacyIndex option to default GsIndexOptions, if upgrading from
! 3.3.x or before
expectvalue %String
run
(Globals includesKey: #GsDefaultIndexOptions) ifFalse: [
    "prior to 3.4.0, #GsDefaultIndexOptions not present in Globals"

    "dbf originated prior to 3.4.0, when legacy indexes were the only
     option, after upgrade to 3.4, legacy indexes should be the default."
    GsIndexOptions default: GsIndexOptions legacyIndex  .
    ^ 'set GsDefaultIndexOptions to legacy' .
].
^ 'GsDefaultIndexOptions unchanged'
%


!-------------
! removal of _unsafesetoop method done later in filein


!------------------------------------------------------------
! fixes 31329 , 31540 - Remove references to Geode
!------------------------------------------------------------

expectvalue %String
run
" remove references to geode without creating Symbols unnecessarily"
| result geodeKeys globalsKeys removeList report |
result := String new .
geodeKeys := { 'Geode' . 'GeodeGlobals' . 'GeodeLauncher' . 
		'GeodeMaint' . 'GeODEDbfHistory' . 'ObsoleteGeode' }.
globalsKeys := Globals keys . "collection of Symbols"
removeList := Array new .
geodeKeys do:[ :aGeod |
  globalsKeys do:[ :aGlb | 
     aGlb asString = aGeod ifTrue:[ removeList add: aGeod ]
  ].
].
report := String new .
removeList do:[ :aKey |
  Globals removeKey: aKey asSymbol .
  report add: ' removed ' , aKey , ' ; ' .
  ].
^ report .
%


!------------------------------------------------------------
! Fix 31942, disallow gci store to instances of SymbolList .
! If customers have created subclasses of SymbolList , those are not
! changed .
expectvalue true
run
SymbolList _disallowGciCreateStore .
^ SymbolList _structuralUpdatesDisallowed
%

commit

expectvalue true
run
 "Check that certain kernel classes have only one version defined.
  The virtual machine contains optimizations which assume that
  the classes checked below have only one version, and thus the
  virtual machine can skip looking at the classHistory when doing
  certain isKindOf checks on arguments to primitives.  
  See fix 32339"

| clsList |
clsList := { AbstractCharacter . 
  Array . 
  ExecBlock . 
  ExecutableBlock . 
  GsNMethod . 
  GsProcess . 
  GsSocket . 
  IdentityBag . 
  Interval . 
  SequenceableCollection . 
  SmallFloat . 
  SmallDouble . 
  VariableContext  }.

clsList do:[ :aCls | | hist val sz |
  hist := aCls classHistory .
  sz := hist size .
  sz == 1 ifFalse:[ 
    nil error:'classHistory for ' , aCls name , ' too big' 
  ].
  val := hist at: 1 .
  val == aCls ifFalse:[
    nil error:'classHistory for ' , aCls name , ' is corrupt'
  ].
].   
"primitives for Float do not check classHistory, but explicitly
 check arguments for both SmallDouble and Float ."
true ifTrue:[ | hist val sz |
  hist := Float classHistory .
  sz := hist size .
  sz == 1 ifFalse:[
    nil error: 'classHistory for Float has wrong size.'
  ].
  val := hist at: 1 .
  val == Float ifFalse:[
    nil error:'classHistory for Float, bad value at:1' . 
  ].
].
^ true
%

expectvalue %String
run
| dcSeg |
dcSeg := Globals at:#DataCuratorObjectSecurityPolicy .
AllUsers objectSecurityPolicy == dcSeg ifTrue:[
  ^ 'objectSecurityPolicy ok'
] ifFalse:[
  AllUsers objectSecurityPolicy: dcSeg .
  AllUsers do:[ :aUp | 
    aUp objectSecurityPolicy == dcSeg ifFalse:[ aUp objectSecurityPolicy: dcSeg].
  ].
  ^ 'changed objectSecurityPolicy'
]
%
lev 1
obj AbstractCharacter
lev 0

expectvalue %String
run
	"ensure Association for FdcResults is in DataCurator objectSecurityPolicy"
| res dcSeg |
dcSeg := Globals at:#DataCuratorObjectSecurityPolicy .
(Globals includesKey:#FdcResults) ifTrue:[
  (Globals associationAt:#FdcResults) objectSecurityPolicy: dcSeg .
  res := 'changed objectSecurityPolicy of FdcResults' .
] ifFalse:[
  dcSeg setCurrentWhile:[
    Globals at:#FdcResults put: nil .
    res := 'created FdcResults' . 
  ]
].
^ res 
%

! v3.1 deleted code for fix 38848, UserSecurityData class is fixed up by bom.c

!------------------------------------------------------------
! Remove behavior from obsolete classes if repository originated
!  on Gs64 v2.3 or prior.  bom.c code run in first conversion session
!  has already renamed them !  to Obsolete*  if they existed.
!------------------------------------------------------------
expectvalue %String
run
 | names report eol |
 names := { 
  'ObsoleteExceptionA' . 
  'ObsoleteError' . 
  'ObsoleteMessageNotUnderstood' . 
  'ObsoleteZeroDivide' . 
  'ObsoleteNotification' . 
  'ObsoleteWarning' . 
  'ObsoleteTestFailure' . 
  'ObsoleteResumableTestFailure' . 
  'ObsoleteExceptionHandler' . 
  'ObsoleteExceptionSet' . 
  'ObsoleteFailedMessage' }.
 "Obsolete subclasses of  Number handled in respective files previous to here"
 report := String new .
 eol := Character lf .
 names do:[ :aName | | aSym aCls |
   (aSym := Symbol _existingWithAll:aName) ~~ nil ifTrue:[
     aCls := Globals at: aSym otherwise: nil .
     aCls ~~ nil ifTrue:[
       aCls removeAllMethods .
       aCls class removeAllMethods .
       report addAll: aName , ' removed all methods' .
     ] ifFalse:[
       report addAll: aName , ' not found in Globals'.
     ].
   ] ifFalse:[
     report addAll: aName , ' symbol does not exist'.
   ].
   report add: eol .
 ].
^ report 
%

! 42240: Code to convert description fields into comment methods
! deleted as part of 3.1 comment redesign.

expectvalue %String
run
  "Move GsCompilerIRNode and subclasses to a GsCompilerClasses dictionary
   and/or remove them from Globals."
  | dict rpt |
  rpt := String new .
  (dict := Globals at: #GsCompilerClasses otherwise: nil) ifNotNil:[
    rpt add: 'GsCompilerClasses exists' ; lf .
  ] ifNil:[ | irNodeCls |
    rpt add: 'created GsCompilerClasses' ; lf .
    (dict := SymbolDictionary new) name: #GsCompilerClasses .
    irNodeCls := Globals at:#GsCompilerIRNode .
    Globals associationsDo:[ : assoc | | val |
      val := assoc _value .
      val isBehavior ifTrue:[
        ((val isSubclassOf: irNodeCls) 
           or:[ val name == #IndentingStream]) ifTrue:[ 
          dict addAssociation: assoc 
        ].
      ].
    ]. 
    Globals at:#GsCompilerClasses put: dict .
  ].
  dict keys do:[ :aKey |
    aKey ~~ #GsCompilerClasses ifTrue:[ 
      (Globals includesKey: aKey) ifTrue:[
         Globals removeKey: aKey .
         rpt add: 'removed ' , aKey ; lf . 
      ].
    ].
  ]. 
  (Globals includesKey:#IndentingStream) ifTrue:[
    dict addAssociation: (Globals associationAt:#IndentingStream).
    Globals removeKey:#IndentingStream.
    rpt add: 'removed #IndentingStream'; lf .
  ].
  Globals removeKey:#isInternedNeedsSymbolCheck ifAbsent:[
    rpt add: 'isInternedNeedsSymbolCheck not found'; lf 
  ].
  ^ rpt.
%

! fix 42260
expectvalue %String
run
  "Remove GsRdbConnection if not being used by GemConnect"
  | rpt |
  rpt := String new .
  rpt add: 'Checking GsRdbConnection status..'; lf .
  (Globals includesKey: #GsRdbConnection) ifTrue: [
    (Globals includesKey: #GsOracleConnection)
    ifTrue: [ 
      rpt add: 'GemConnect installed: GsRdbConnection retained.'; lf ]
    ifFalse: [
      Globals removeKey: #GsRdbConnection.
      rpt add: 'Class GsRdbConnection not used: removed.'; lf .
  ]].
^ rpt
%

! fixed 44130 , 44134, 45331 , 47864
! additions to list of obsolete classes to fix 44134
expectvalue %String
run
  "Move selected obsolete classes to ObsoleteClasses, to fix 40985"
  | rpt dict |
  rpt := String new .
  (dict := Globals at: #ObsoleteClasses otherwise: nil) ifNotNil:[
    rpt add: 'ObsoleteClasses exists' ; lf .
  ] ifNil:[
    rpt add: 'created ObsoleteClasses' ; lf .
    (dict := SymbolDictionary new ) name: #ObsoleteClasses .
    Globals at:#ObsoleteClasses put: dict . 
  ].
  #(   Activation
       Block
       CompiledMethod
       GsCloneList
       ExecutableBlock ComplexBlock ComplexVCBlock SimpleBlock
       MethodContext  Process StackSegment StackBuffer
       GsMethod 
       JapaneseString JISCharacter JISString InvariantEUCString EUCString EUCSymbol
       Obsolete23ClampSpecification
       Obsolete23GsFile
       ObsoleteClampSpecification
       ObsoleteDateTime
       ObsoleteDictionary
       ObsoleteGsFile
       ObsoleteIdentityCollisionBucket
       ObsoleteIdentityDictionary
       ObsoleteLanguageDictionary
       ObsoleteRcCollisionBucket
       ObsoleteSymbol
       ObsoleteSymbolAssociation
       ObsoleteSymbolDictionary
       ObsoleteSymbolKeyValueDictionary
       ObsoleteSymbolListDictionary
       ObsoleteSymbolSet
       ObsoleteVariableContext
       ReenterBlock
       SelectionBlock
       ObsoleteTestCase
       ObsoleteTestResource
       ObsoleteExampleSetTest
       ObsoleteResumableTestFailureTestCase
       ObsoleteSimpleTestResourceTestCase
       ObsoleteSUnitTest
      ObsoleteError ObsoleteException ObsoleteExceptionHandler ObsoleteExceptionSet 
      ObsoleteFailedMessage ObsoleteMessageNotUnderstood ObsoleteNotification 
      ObsoleteResumableTestFailure 
      ObsoleteTestFailure ObsoleteWarning ObsoleteZeroDivide
      ObsoleteSetValuedPathEvaluator
      ObsoleteConstrainedPathTerm
      ObsoleteConstrainedPathEvaluator
      ObsoleteSetValuedPathTerm
      ObsoletePathEvaluator
      ObsoleteIndexedQueryEvaluator
      ObsoleteEqualityIndexQueryEvaluator
      ObsoleteIdentityIndexQueryEvaluator
      ObsoleteAbstractIndexSpecification
      ObsoleteEqualityIndexSpecification
      ObsoleteIdentityIndexSpecification
      ObsoleteRcEqualityIndexSpecification
      ObsoletePathSorter
      ObsDoubleByteSymbol
      ObsDoubleByteString
      ObsFloat
      ObsLargeNegativeInteger
      ObsLargePositiveInteger
      ObsoleteDateTime50
      ObsoleteGsProcess
      ObsoleteGsRdbConnection
      ObsoleteGsSocket
      ObsoleteMetaclass
      ObsoleteTimeZone ObsoleteTimeZone2
      ObsQuadByteString
      ObsQuadByteSymbol
      ObsSmallFloat
      ObsMultiByteString
      OldRepository
      Regexp RegexpError
    ) do:[:sym | 
         (Globals associationAt: sym otherwise: nil ) ifNotNil:[:assoc|
           dict addAssociation: assoc .
           rpt add: 'added ' , sym ; lf .
         ]
  ].
  dict keys do:[ :aKey |
    aKey ~~ #ObsoleteClasses ifTrue:[
      (Globals includesKey: aKey) ifTrue:[
         Globals removeKey: aKey .
         rpt add: 'removed from Globals:  ' , aKey ; lf .
      ].
    ].
  ].
  ^ rpt
%
run
"Install class variable used to support recompile of instances of GsMethod
 to produce instances of GsNMethod .  This dictionary names the classes
 for which it is NOT valid to reuse the existing literal variables in a method."

| cNames dict |
 cNames := #(  "classes for which want to use the current definition when recompiling"
   "triples:  key in association after 3.x upgrade, sourceName, 
		3.x lookup key if different than sourceName"

   "classes normally moved to ObsoleteClasses"
   #Obsolete23ClampSpecification #ClampSpecification nil
   #ObsoleteError #Error nil
   #ObsoleteException #Exception nil
   #ObsoleteExceptionHandler #ExceptionHandler nil
   #ObsoleteExceptionSet #ExceptionSet nil
   #ObsoleteFailedMessage #FailedMessage nil
   #Obsolete23GsFile #GsFile nil
   #ObsoleteGsProcess #GsProcess nil
   #ObsoleteGsSocket #GsSocket nil
   #ObsoleteMessageNotUnderstood #MessageNotUnderstood nil
   #ObsoleteNotification #Notification nil
   #ObsoleteResumableTestFailure #ResumableTestFailure nil
   #ObsoleteTestFailure #TestFailure nil
   #ObsoleteVariableContext #VariableContext nil
   #ObsoleteWarning #Warning nil
   #ObsoleteZeroDivide #ZeroDivide  nil
   #ExecutableBlock #ExecutableBlock #ExecBlock
   "classes in Globals"

   #ObsQuadByteString  #QuadByteString nil
   #ObsDoubleByteSymbol #DoubleByteSymbol nil
   #ObsDoubleByteString #DoubleByteString nil
   #ObsLargeNegativeInteger #LargeNegativeInteger  #LargeInteger
   #ObsLargePositiveInteger #LargePositiveInteger  #LargeInteger
   #ObsSmallFloat  #SmallFloat nil
   #ObsFloat       #Float   nil
   #FixedPoint     #ScaledDecimal  #FixedPoint "use FixedPoint in oldCode" 

   "ObsoleteTimeZone   not handled"
   "ObsoleteMetaclass  not handled"
   "ObsoleteIgnoredException  not handled"

   #ObsoleteClampSpecification #ClampSpecification nil 

   #ObsoleteAbstractIndexSpecification #AbstractIndexSpecification nil
   #ObsoleteConstrainedPathEvaluator   #ConstrainedPathEvaluator   nil
   #ObsoleteConstrainedPathTerm	       #ConstrainedPathTerm   nil
   #ObsoleteEqualityIndexQueryEvaluator #EqualityIndexQueryEvaluator   nil
   #ObsoleteEqualityIndexSpecification  #EqualityIndexSpecification   nil
   #ObsoleteIdentityIndexQueryEvaluator #IdentityIndexQueryEvaluator   nil
   #ObsoleteIdentityIndexSpecification  #IdentityIndexSpecification   nil
   #ObsoleteIndexedQueryEvaluator      #IndexedQueryEvaluator   nil
   #ObsoletePathEvaluator              #PathEvaluator   nil
   #ObsoletePathSorter                 #PathSorter   nil
   #ObsoleteSetValuedPathEvaluator #SetValuedPathEvaluator   nil
   #ObsoleteSetValuedPathTerm      #SetValuedPathTerm   nil
).
 dict := SymbolDictionary new .
 1 to: cNames size by: 3 do:[:j | | obsName newName vArr srcName oldCls |
   obsName := cNames at: j .         "key in 3.x association for obsolete class"
   newName :=   cNames at: j + 1 .   "key to lookup in 3.x Globals"
   srcName :=  (cNames at: j + 2) ifNil:[ newName ].
   oldCls := Globals at:obsName ifAbsent:[ 
               (Globals at:#ObsoleteClasses) at: obsName otherwise:nil ] .
   oldCls ifNotNil:[ vArr := { oldCls . newName . srcName }.
     dict at: obsName put:  vArr .
     dict at: newName put: vArr .
   ].
 ].
 dict at:#ExceptionA put: { Globals at:#ObsoleteExceptionA otherwise: nil . 
	 		     #Exception } .
 ( (ObsoleteClasses at: #GsMethod) _resolveClassVar: #ObsoleteClassesDict) value: dict .
 GsNMethod _addClassVar: #ObsoleteClassesDict value: dict . 
 true
%

! fix 42259
expectvalue %String
run
| seg |
(seg := Globals at:#PublishedSegment otherwise:nil) ifNil:[
  Globals at:#PublishedSegment put: PublishedObjectSecurityPolicy.
  ^ 'Installed key PublishedSegment'
] ifNotNil:[
  (seg == PublishedObjectSecurityPolicy) ifFalse:[  
    ^ 'PublishedSegment refers to some other object'.
  ].
  ^ 'PublishedSegment already present'
].
%

! fix 42240 -- upgrade comment handling of Global classes to 3.1 protocol

expectvalue true
run

  | errors lf |
  errors := false.
  lf := Character lf.
  GsFile gciLogServer: 
    'Converting comments in Global classes to 3.1 standard.'.

  Globals classesDo: [:aUserProfile :aSymbolDictionary :aClass |
    [ aClass upgradeComments ] 
    on: Error do: [:ex | | lf |
        lf := Character lf.
        errors := true.
        GsFile gciLogServer:
           'ERROR: Class ' , aClass name asString , 
           ' failure during comment upgrade: ' , lf ,
           ex description asString , lf ,
           '---------------------------------' , lf ,
           (GsProcess stackReportToLevel: 300) , lf ,
           '---------------------------------' , lf.
  ]].

  " Trigger a final internal error if any errors seen during scan.."
  errors ifTrue: [ 
    InternalError signal: 'Problem with comment conversion - check log' ].

  GsFile gciLogServer: ' ' , lf , ' '.
^ true
%
commit

! clear constraints on system classes
expectvalue true
run
  Globals classesDo: [:aUserProfile :aSymbolDictionary :aClass |
    [aClass _constraints ifNotNil:[
      GsFile gciLogServer:'clearing constraints on class ' , aClass asOop asString .
      aClass _clearConstraints .
    ]] on: Deprecated do: [:ex | ex resume].
  ] .
  ^ true .
%
commit

! special handling for class definitions built during slow filein (#44253)
input $upgradeDir/GciLibraryA.gs 
commit
! fixed 43689
doit
  "The text report files are shipped in $GEMSTONE/doc"

  | blk |
  blk := [ :fName :digestName | | f r v |
    f := GsFile openReadOnServer: '$upgradeDir/', fName  .
    f ifNil:[ 
      GsFile gciLogServer:'generating ', fName .
      r := CHeader _gciStructReport .
      (GsFile openWriteOnServer: '$upgradeLogDir/', fName ) nextPutAll: r ; close .
    ] ifNotNil:[ 
      GsFile gciLogServer:'found ', fName .
      r := f contents . f close
    ].
    Globals at: digestName put: (v := r md5sum asHexString immediateInvariant) .
    GsFile gciLogServer: digestName , ' := ' , v .
  ].
  blk value: 'gciStructs.txt'   value: #GciStructsMd5 .  
  blk value: 'gcitsStructs.txt' value: #GciTsStructsMd5.

true
%

! fix 44744
expectvalue %SmallInteger
run
 | count | count := 0 .
 { GsQueryGrammar .
   GsQueryParser .
   PPCompositeParser .
   PPMemento .
   PPMemoizedParser .
   PPStream .
   PPToken .
   PPFailure .
   ProfMonitorEntry } do:[:cls |
     cls classHistory do:[:aVers | aVers ~~ cls ifTrue:[ 
         count := count + 1 .
         aVers removeAllMethods . aVers class removeAllMethods.
         GsFile gciLogServer: 'removed methods from class ' , aVers asOop asString
       ]
     ]
   ] .
  ^ count 
% 
! expectvalue %Array
! run
! SystemRepository markForCollection .
! "expect Array of size zero"
! GsNMethod allInstances select:[:m | m methodCompilerVersion < 4]
! %

commit


category: 'Repository Conversion'
method: Object
_unsafeSet11Oop: aPositiveInteger

  "aPositiveInteger must be the integer value of a gs64v1.1 OopType" 

  <primitive: 385>
  ^ self _primitiveFailed: #_unsafeSet11Oop: args: { aPositiveInteger }
%


category: 'Repository Conversion'
method: Object
_unsafeSetOop: aPositiveInteger

  "aPositiveInteger must be the integer value of a gs64v2.x OopType" 

  <primitive: 535>
  ^ self _primitiveFailed: #_unsafeSetOop: args: { aPositiveInteger }
%
commit

run
GsObjectSecurityPolicy setCurrent: (Globals at:#DataCuratorObjectSecurityPolicy) while:[
  | newDict published publishedSeg gbRef migrateBlock createBlock |

  "convert AllGroups to a dictionary."
  AllGroups class == SymbolKeyValueDictionary ifFalse:[
    newDict :=  SymbolKeyValueDictionary new: 53 .
    AllGroups do:[ :aStr | | sym newGroup | 
      sym := Symbol withAll: aStr .
      newGroup := UserProfileGroup _primNewWithName: sym .
      newDict at: sym put: newGroup .
      ].
    AllGroups := newDict .
    ].


  createBlock := [:str|
     (UserProfileGroup groupWithName: str otherwise: nil) 
    ifNil:[ UserProfileGroup newGroupWithName: str ]
  ].

  createBlock value: 'System' ;
              value: 'Publishers' ;
	      value: 'Subscribers' ;
	      value: 'SymbolUser' ;
	      value: 'DataCuratorGroup' .

  publishedSeg := (Globals at:#SystemRepository) at: 6 .  
  gbRef := Globals at:#PublishedObjectSecurityPolicy otherwise: nil .
  publishedSeg == gbRef ifFalse:[ nil error:'invalid PublishedObjectSecurityPolicy ref' ].

  publishedSeg group: 'Subscribers' authorization: #read  ;
    group: 'Publishers'  authorization: #write .

"Create Published if it does not yet exist"
  (System myUserProfile objectNamed: #Published) 
    ifNil:[
       GsObjectSecurityPolicy setCurrent: publishedSeg while:[
          (published := SymbolDictionary new) name: #Published .
    ].
  ].
    
  migrateBlock := [:idSet| |arrayOfStrings newSet |
    (idSet size > 0) ifTrue:[ "Weeds out nils"
      arrayOfStrings := idSet asArray .
      idSet removeAll: idSet .
       arrayOfStrings do:[:obj|
           obj class == UserProfileGroup 
	     ifTrue:[ idSet add: obj ]
	     ifFalse:[  |newGroup|
	       obj _validateClass: String .
               newGroup := AllGroups at: obj otherwise: nil .
               newGroup notNil ifTrue:[ idSet add: newGroup ]]]]
   ].

  SystemRepository _migrateGroups: migrateBlock .
    

  AllUsers do:[:aUserPro | 
    aUserPro _migrateGroups: migrateBlock .
    published notNil ifTrue:[ aUserPro symbolList addLast: published ] .
    aUserPro addGroup: 'Subscribers' .    
    ].
    
  (AllUsers userWithId: 'DataCurator') 
     addGroup: 'System' ;
     addGroup: 'Publishers';
     addGroup:'DataCuratorGroup' .

  (AllUsers userWithId: 'SystemUser') 
     addGroup: 'System' ;
     addGroup: 'Publishers' .

"Minimum password length is 1 as of 3.4.  Zero-length password now used for passwordless login."
  (AllUsers minPasswordSize == 0)
    ifTrue:[ AllUsers minPasswordSize: 1 ] .
    
  (Globals at: #DataCuratorObjectSecurityPolicy) group:'DataCuratorGroup' authorization: #write .

"Initialize AllKerberosPrincipals global if needed."
  (Globals at: #AllKerberosPrincipals otherwise: nil) 
    ifNil:[ |allPrins|
      allPrins := SymbolKeyValueDictionary new: 103.
      allPrins _unsafeSetOop: 157953 .
      Globals at: #AllKerberosPrincipals put: allPrins .
    ].
].
^ true
%

run
"Change instvar spare1 to kerberosPrincipal"
((UserProfile _instVarNames at: 7) == #kerberosPrincipal) ifFalse:[
  UserProfile _instVarNames at: 7 put: #kerberosPrincipal ] .
^ true  
%

run
" Set the NbyteWords swizzle option in some byte format classes, so it
  shows up in the result of Class>>definition.  ominit.c synthesizes the
  in-memory swizzle info for the classes if needed when class is faulted in.
  Part of fix 47516."
| blk |
blk := [:cls :aSym | | fmt newFmt |
   fmt := cls format .
   newFmt := cls _addByteSwizzle: aSym toFormat: fmt newClassName: cls name signed: false . 
   newFmt = fmt ifTrue:[
     GsFile gciLogServer: cls name, ' no change'.
   ] ifFalse:[
     cls _unsafeAt: 2 put: newFmt .
     GsFile gciLogServer: cls name, ' old format ', fmt asString, ' new format ', newFmt asString
   ].
].
{ DoubleByteString . 
  DoubleByteSymbol . 
  Unicode16  .
  Utf16         
} do:[:aCls | blk value: aCls value: #'2byteWords' ].

{ LargeInteger  .
  QuadByteString .
  QuadByteSymbol .
  Unicode32 .
  SmallFloat .
  BitSet .
} do:[:aCls | blk value: aCls value: #'4byteWords' ].

{  Float
} do:[ :aCls | blk value: aCls value: #'8byteWords' ].
true
%


expectvalue true
run
Object removeSelector: #_unsafeSetOop: .
Object removeSelector: #_unsafeSet11Oop: .
^ true
%
commit

! end of bomlastconv.gs
