! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! ========================================================================

category: '*PetitParser-Core-Converting'
set compile_env: 0
method: Collection
asChoiceParser
	^ PPChoiceParser withAll: (self collect: [ :each | each asParser ])
%
category: '*PetitParser-Converting'
set compile_env: 0
method: Collection
asParser    
	"Create a range of characters between start and stop."

	(self allSatisfy: [ :e | e isKindOf: Character ]) ifTrue: [ 
		| charSet |
		charSet := PPCharSetPredicate on: [ :char | self includes: char ] .
     	^ PPPredicateObjectParser on: charSet message: 'One of these charactes expected: ', self printString.
	].


	^ super asParser
	"
		($a to:$f) asParser parse:'a'
		($a to:$f) asParser parse:'g'
	"
%
category: '*PetitParser-Core-Converting'
set compile_env: 0
method: Collection
asSequenceParser
	^ PPSequenceParser withAll: (self collect: [ :each | each asParser ])
%
category: 'Private'
method: Collection
_indexObjectsFor: pathArrays
  "Returns an Array of index objects (either PathEvaluators or
 RangeEqualityIndexes) that correspond to the paths described
 in the pathArrays (each element is an Array of Strings)."

  | pathArray indexObj indexObjs k sz |
  indexObjs := {}.
  1 to: pathArrays size do: [ :i | 
    pathArray := pathArrays at: i.
    indexObj := self _findRangeIndexWithPath: pathArray.
    indexObj == nil
      ifTrue: [  | holder |
        indexObj := PathEvaluator new nsc: self.
        1 to: pathArray size do: [ :j | indexObj addLast: (pathArray at: j) ].
        holder := { indexObj  } .
        indexObj  := nil .
        indexObj :=  PathEvaluator asMostSpecificType: holder .

        indexObjs isEmpty
          ifTrue: [ indexObjs add: indexObj ]
          ifFalse: [ 
            " don't add a duplicate path "
            k := 1.
            sz := indexObjs size.
            [ k <= sz and: [ (indexObj hasSamePathAs: (indexObjs at: k)) not ] ]
              whileTrue: [ k := k + 1 ].
            k > sz
              ifTrue: [ indexObjs add: indexObj ] ] ]
      ifFalse: [ indexObjs add: indexObj ] ].
  ^ indexObjs
%

category: 'Converting'
method: Collection
asGsBitmap

"Returns a GsBitmap with the contents of the receiver."

^GsBitmap withAll: self asArray
%
