!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   EUCString, JapaneseString, CharacterCollection, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods EUCString
removeallclassmethods EUCString

category: 'For Documentation Installation only'
classmethod: EUCString
installDocumentation

self comment:
'Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteStrings/QuadByteStings.

 This class represents Japanese strings in Extended Unix Code format.'.
%

category: 'Formatting'
classmethod: EUCString
charSize

"Returns the number of bytes that make up a character"
^1
%

category: 'Formatting'
method: EUCString
charSize

"Returns the number of bytes that make up a character"
^1
%

category: 'Accessing'
method: EUCString
at: anIndex

"Returns the JISCharacter at the specified index."

<primitive: 244>

(anIndex _isSmallInteger)
ifTrue:[ ^ self _errorIndexOutOfRange: anIndex]
ifFalse:[^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError
%

category: 'Accessing'
method: EUCString
size

"Returns the number of JISCharacters in the receiver."

<primitive: 76>

self _primitiveFailed: #size .
self _uncontinuableError
%

category: 'Updating'
method: EUCString
at: anIndex put: aCharacter

"Stores aCharacter at the specified location."

<primitive: 243>
| charClass |
charClass := aCharacter class .
(charClass == JISCharacter or:[ charClass == Character]) ifFalse:[
  ^ self at: anIndex put: aCharacter asJISCharacter .
  ].
(anIndex _isSmallInteger)
ifTrue:[ ^ self _errorIndexOutOfRange: anIndex]
ifFalse:[^ self _errorNonIntegerIndex: anIndex].

self _primitiveFailed: #at:put: args: { anIndex . aCharacter } .
self _uncontinuableError
%

category: 'Updating'
method: EUCString
size: anInteger

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to nil."

<primitive: 245>

(anInteger _isSmallInteger)
ifTrue:[^ self _errorIndexOutOfRange: anInteger]
ifFalse:[^ self _errorNonIntegerIndex: anInteger].

self _primitiveFailed: #size: args: { anInteger } .
self _uncontinuableError
%

category: 'Formatting'
method: EUCString
asEUCString

"Returns the receiver."

"This reimplementation of from JapaneseString is crucial !."

^self
%

! category: 'Formatting'
! method: EUCString
! describe
! 
! "If the receiver is less than half a megabyte, quote it.
!  Otherwise, return the receiver."
! 
! self _basicSize > 500000
!   ifTrue: [ ^self ]
!   ifFalse: [ ^self quoted ]
! %

category: 'Converting'
method: EUCString
asSymbolKind

"Returns a copy of the receiver as an instance of Symbol."

^ self asSymbol
%

category: 'Comparing'
method: EUCString
= aCharCollection

"Returns true if all of the corresponding Characters in the receiver and
 argument are equal.  Returns false otherwise."

<primitive: 77>

^ super = aCharCollection
%

category: 'Comparing'
method: EUCString
< aCharCollection

"Returns true if the receiver collates before the argument.  Returns false
 otherwise."

((aCharCollection isKindOf: EUCString) or: [ aCharCollection isKindOf: String])
  ifTrue: [ ^(self _EUCcompare: aCharCollection) == -1]
  ifFalse: [ ^super < aCharCollection ]
%

category: 'Comparing'
method: EUCString
<= aCharCollection

"Returns true if the receiver collates before the argument or if all of the
 corresponding Characters in the receiver and argument are equal.  Returns
 false otherwise."

((aCharCollection isKindOf: EUCString) or: [ aCharCollection isKindOf: String])
  ifTrue: [ ^(self _EUCcompare: aCharCollection) <= 0]
  ifFalse: [ ^super <= aCharCollection ]
%

category: 'Comparing'
method: EUCString
> aCharCollection

"Returns true if the receiver collates after the argument.  Returns false
 otherwise."

((aCharCollection isKindOf: EUCString) or: [ aCharCollection isKindOf: String])
  ifTrue: [ ^(self _EUCcompare: aCharCollection) == 1]
  ifFalse: [ ^super > aCharCollection ]
%

category: 'Comparing'
method: EUCString
>= aCharCollection

"Returns true if the receiver collates after the argument or if all of the
 corresponding Characters in the receiver and arguments are equal.  Returns
 false otherwise."

((aCharCollection isKindOf: EUCString) or: [ aCharCollection isKindOf: String])
  ifTrue: [ ^(self _EUCcompare: aCharCollection) >= 0]
  ifFalse: [ ^super >= aCharCollection ]
%

category: 'Comparing'
method: EUCString
_EUCcompare: aCharCollection

"Returns -1 if self < aCharCollection, returns 0 if self = aCharCollection,
 and returns 1 if self > aCharCollection."

<primitive: 78>

^ self _primitiveFailed: #_EUCcompare: args: { aCharCollection }
%

! _hashCaseSensitive: deleted

! deleted copyFrom:to:into:startingAt: prim 246

category: 'Searching'
method: EUCString
indexOf: aCharacter startingAt: startIndex

"Returns the index of the first occurrence of aCharacter in the receiver,
 not preceding startIndex.  If the receiver does not contain aCharacter,
 this returns zero."

<primitive: 79>

^super indexOf: aCharacter startingAt: startIndex
%

category: 'Adding'
method: EUCString
add: aCharOrCharCollection

"Appends aCharOrCharCollection to the receiver.  The argument
 aCharOrCharCollection must be a CharacterCollection or a kind of
 AbstractCharacter."

<primitive: 242>

^ super add: aCharOrCharCollection
%

category: 'Adding'
method: EUCString
addAll: aCharOrCharCollection

"Equivalent to add: aCharOrCharCollection."

<primitive: 242>

^ super addAll: aCharOrCharCollection
%

category: 'Adding'
method: EUCString
addLast: aCharOrCharCollection

"Equivalent to add: aCharOrCharCollection."

<primitive: 242>

^ super addLast: aCharOrCharCollection
%

category: 'Adding'
method: EUCString
insertAll: aCharOrCharCollection at: anIndex

"Inserts aCharOrCharCollection at the specified index."

<primitive: 241>

anIndex _validateClass: SmallInteger.
(anIndex > (self size + 1))
ifTrue:[ ^ self _errorIndexOutOfRange: anIndex]
ifFalse:[ ^ super insertAll: aCharOrCharCollection at: anIndex]
%

category: 'Converting'
method: EUCString
asSymbol

"Returns a Symbol that contains the same bytes as the receiver."

^ (DoubleByteString withAll: self) asSymbol
%

category: 'Formatting'
method: EUCString
printString

"Returns an EUCString whose contents are a displayable representation of the
 receiver."

| ws str |

str := Unicode16 new.
ws := PrintStream printingOn: str.
self printOn: ws.
^str
%

! added trapping of error 2281 so we can get consistent error reports
!  in methtst, etc .
category: 'Formatting'
method: EUCString
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

1 to: (self size min: 200) do:[:j |
  aStream nextPut: (Character codePoint: (self codePointAt: j))
].
%

! removed asArrayOfPathTerms

category: 'Deprecated'
method: EUCString
_isValidPathTermName

"Returns true if the receiver is a valid term in a path expression."

self deprecated:'_isValidPathTermName deprecated (EUCString not supported path terms)'.
^ false
%
category: 'Accessing'
method: EUCString
codePointAt: anIndex

^ (self at: anIndex) eucValue
%

category: 'Updating'
method: EUCString
codePointAt: anIndex put: aValue

^ self at: anIndex put:(JISCharacter withEUCValue: aValue)
%

