!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   GsNativeCode, Object
!
!=========================================================================

removeallmethods GsNativeCode
removeallclassmethods GsNativeCode

category: 'For Documentation Installation only'
classmethod: GsNativeCode
installDocumentation

self comment:
'GsNativeCode is a compiled form of the executable code for a GemStone
 Smalltalk method, compiled to execute on a specific processor.

 Instances exist only in memory, they are not committed to disk.' .
%

set class GsNativeCode

! ------------------- Class methods for GsNativeCode
category: 'Disallowed'
classmethod:
new: aSize

"Disallowed.  You cannot create new instances of GsNativeCode."

self shouldNotImplement: #new:
%

category: 'Disallowed'
classmethod:
new

"Disallowed.  You cannot create new instances of GsNativeCode."

self shouldNotImplement: #new
%

! ------------------- Instance methods for GsNativeCode
category: 'Private'
method:
_myNmethod

<primitive: 677>
^ self _primitiveFailed: #_myNmethod
%

category: 'Disallowed'
method:
_objectSecurityPolicy: anObjectSecurityPolicy

"Disallowed."
self shouldNotImplement:#objectSecurityPolicy:
%

category: 'Disallowed'
method:
at: anOffset put: aVal

"Disallowed."
self shouldNotImplement:#at:put:
%
category: 'Disallowed'
method:
basicAt: anOffset put: aValue

"Disallowed."
self shouldNotImplement:#basicAt:put:
%
category: 'Disallowed'
method:
squeakBasicAt: anOffset put: aValue

"Disallowed."
self shouldNotImplement:#squeakBasicAt:put:
%

category: 'Disallowed'
method:
objectSecurityPolicy: anObjectSecurityPolicy

"Disallowed."
self shouldNotImplement:#objectSecurityPolicy:
%

category: 'Disallowed'
method:
size: aSize

"Disallowed."
self shouldNotImplement:#size:
%

category: 'Disallowed'
method:
_at: anOffset put: aVal

"Disallowed."
self shouldNotImplement:#_at:put:
%

category: 'Disallowed'
method:
_basicAt: anOffset put: aVal

"Disallowed."
self shouldNotImplement:#_basicAt:put:
%

category: 'Disallowed'
method:
_basicSize: aSize

"Disallowed."
self shouldNotImplement:#_basicSize:
%

category: 'Disallowed'
method:
_primitiveAt: anOffset put: aVal

"Disallowed."
self shouldNotImplement:#_primitiveAt:put:
%

category: 'Disallowed'
method:
passivate

"Disallowed."
self shouldNotImplement:#passivate
%

category: 'Disallowed'
method:
copy
"Disallowed."
self shouldNotImplement:#copy
%

