!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   InvariantArray, Array, SequenceableCollection, Collection, Object.
!
!=========================================================================

removeallmethods InvariantArray
removeallclassmethods InvariantArray

category: 'For Documentation Installation only'
classmethod: InvariantArray
installDocumentation

self comment:
'An InvariantArray is an Array that is made to be invariant (immutable) when it
 is committed, if it is not already invariant before then.  Unless otherwise
 handled explicitly, an InvariantArray that has not yet been committed is still
 modifiable.  Array literals are always invariant; if you assign one to a
 variable, then the object to which the variable refers cannot be changed.

 Immutability implies that the Array''s size, ordering of elements, and
 element membership cannot be changed.  Thus, if an object is an element of the
 Array, that same object must remain an element of the Array, and it must remain
 located at its current index.  Immutability does not imply that the element
 object itself cannot be changed, but only that its relation to the Array is
 immutable.' .
%
