!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ISOLatin, String, CharacterCollection, SequenceableCollection, Collection,
!   Object.
!
!=========================================================================

expectvalue %String
run
  String _newKernelSubclass: 'ISOLatin'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
      options: #()
    reservedOop: 757 .
%

removeallmethods ISOLatin
removeallclassmethods ISOLatin

category: 'For Documentation Installation only'
classmethod: ISOLatin
installDocumentation

self comment:
'ISOLatin is a subclass of String which provides means for GemStone Smalltalk
 applications to extend the behavior of String with native-language-specific
 sorting or other behavior.

 ISOLatin inherits all of its behavior from String, and thus inherits the
 the English ASCII defaults for character set interpretation, as provided
 by the C runtime library and by Unix.

 It is the user''s responsibility to create a subclass of ISOLatin and
 implement appropriate comparison methods in the subclass if an application
 requires language-specific sorting or comparison semantics.'.

%

category: 'Formatting'
method: ISOLatin
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

aStream _collection class == String ifTrue:[ aStream _convertToISOLatin ].

^ super printOn: aStream
%

