!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
!=========================================================================

category: '*PetitParser-Core-Converting'
set compile_env: 0
method: Object
asParser
	"Answer a parser accepting the receiving object."

	^ PPPredicateObjectParser expect: self
%
category: '*PetitParser-Core-Testing'
set compile_env: 0
method: Object
isPetitFailure
	^ false
%
category: '*PetitParser-Core-Testing'
set compile_env: 0
method: Object
isPetitParser
	^ false
%
category: 'Testing'
set compile_env: 0
method: Object
_literalEqual: anotherLiteral
  "For two literals to be _literalEqual, their class must be identical and  
   otherwise equal"

  ^ self class == anotherLiteral class and: [ self = anotherLiteral ]
%
category: 'Testing'
set compile_env: 0
method: Object
_refersToLiteral: literal
  "Answer true if literal is identical to any literal in receiver, even if imbedded 
   in further structures. 
   Object is the end of the imbedded structure path so return false."

  ^ false
%

category: 'Formatting'
method: Object
asEUCString

"Returns an EUCString that represents the receiver."

self deprecated: 'Object>>asEUCString is deprecated in 3.0 and later'.
^EUCString withAll: (self asString)
%

! Fix 38056
category: 'Repository Conversion'
classmethod: Object
fixReferencesAfterConversionFromDirectory: string

"Attempt to old objects to special objects as follows:
	SmallFloat ->		SmallDouble
	Float ->		SmallDouble
	ObsLargePositiveInteger ->	SmallInteger
	ObsLargeNegativeInteger ->	SmallInteger

Note: some instances may not be converted for the following reasons:
	Instance is in an IdentitySet or IdentityBag larger than 2024 elements.
	Instances is in an Array or other oop collection larger than 2024 elements.
	Value of the instance is out of range of the new special object class."

| fn aString refs objs2ndPass alreadyFixed |
  refs := GsBitmap newForHiddenSet: #Customer1.
  objs2ndPass := GsBitmap newForHiddenSet: #Customer2.
  alreadyFixed := GsBitmap newForHiddenSet: #Customer5.
  refs removeAll.
  objs2ndPass removeAll.
  alreadyFixed removeAll.

"Load in the 2 bitmaps that contain refs to LargeInts and Floats"
aString := String withAll: string.
(aString last == $/)
	ifFalse:[aString add: '/'].
fn := String new.
fn addAll: aString; addAll: 'AllLrgIntRefs.bm'.
(GsFile existsOnServer: fn)
	ifTrue:[refs readFromFile: fn]
	ifFalse:[self halt: ('Cannot open file ', fn) ].

fn size: 0; addAll: aString; addAll: 'AllFloatRefs.bm'.
"This one is optional because 6.1.5 conversion does not produce AllFloatRefs.bm"
(GsFile existsOnServer: fn)
	ifTrue:[refs readFromFile: fn].

(refs size) == 0
	ifTrue:[^false].

[ | array |
  System transactionMode: #autoBegin.
  System signalAlmostOutOfMemoryThreshold: 70 .

  [ array := refs enumerateWithLimit: 2000 startingAfter: 0. 
    array size == 0] whileFalse:[
	1 to: array size do:[:n| |obj|
		obj := array at: n.
		obj fixReferencesInFirstPass
			ifTrue:[obj fixRefsAfterConversion] "do it now"
			ifFalse:[objs2ndPass add: obj]. "save it for later"
	        refs removeAll: array.
	].
  ].
  System commitTransaction ifFalse:[ Object halt: 'error: commit failure!'].
  [ array := objs2ndPass enumerateWithLimit: 2000 startingAfter: 0. array size == 0] whileFalse:[
     1 to: array size do:[:n| |obj|
	obj := array at: n.
	obj fixRefsAfterConversion.
        objs2ndPass removeAll: array
     ].
  ].
  System commitTransaction ifFalse:[Object halt: 'error: commit failure!'].
  ^ alreadyFixed size

] onException: AlmostOutOfMemory do:[:ex |
  "do a commit..."
  System commitTransaction
	   ifFalse:[Object halt: 'error: commit failure!'].
   "run another markSweep, to see if we can drop below the threshold..."
  System _vmMarkSweep.
  System signalAlmostOutOfMemoryThreshold: 70 .
  System enableAlmostOutOfMemoryError. "re-enable the exception"
  ex resume
].		
%
