!=========================================================================
! Copyright (C) GemTalk Systems 2010-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class ObsoleteGsProcess
removeallmethods
removeallclassmethods

category: 'Documentation'
classmethod: 
comment
^ '
 Instances of ObsoleteGsProcess are the committed state of
 suspended Smalltalk processes or continuations from a Gs64 v2.x VM .
 Their execution cannot be resumed by the Gs64 v3.0 VM .
 Instance creation is disallowed.

Constraints:
	stackDepth: SmallInteger
	controlStack: GsStackBuffer
	arStack: GsStackBuffer
	inUserActionCount: SmallInteger
	interruptFlag: SmallInteger
	fltStatus: String
	recursionsToStCount: SmallInteger
	protectedMode: SmallInteger
	asyncEventsDisabled: Boolean
	remoteProcess: Object
	priority: SmallInteger
	block: ExecutableBlock
	args: Array
	signalTime: SmallInteger
	blockResult: Object
	clientData: Object
	location: Object
	_lastGciProcess: ObsoleteGsProcess
	_debugMode: Boolean
	isTerminated: Boolean
	group: Integer
	environment: AbstractDictionary'
%

category: 'Instance creation'
classmethod: 
new
  self shouldNotImplement: #new
%
classmethod: 
new: aSize
  self shouldNotImplement: #new:
%
category: 'Instance creation'
classmethod: 
_basicNew
  self shouldNotImplement: #_basicNew
%
classmethod: 
_basicNew: aSize
  self shouldNotImplement: #_basicNew: 
%


