!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: positio1.gs 19139 2008-05-30 23:48:14Z stever $
!
! Superclass Hierarchy:
!   PositionableStream, Stream, Object.
!
! See installStreamHierarchy.topaz for filein information
!
!=========================================================================

! fix for Bug #41532

category: 'ANSI Methods'
classMethod: PositionableStream
compilePositionMethods

"Compile ANSI, Legacy or Warning as default methods (see bug #39503)"

| flag selector string |
flag := Globals at: #'PositionableStream_position' ifAbsent: [#'Legacy'].
selector := 
	flag == #'ANSI'		ifTrue:  [#'positionA'] ifFalse: [
	flag == #'Legacy'	ifTrue:  [#'positionL'] ifFalse: [
	flag == #'Warning'	ifTrue:  [#'positionW'] ifFalse: [
	self error: 'Invalid value for flag!']]].
string := (self compiledMethodAt: selector) sourceString.
string := (string copyFrom: 1 to: 8) , (string copyFrom: 10 to: string size).
self
	compileMethod: string
	dictionaries: GsCurrentSession currentSession symbolList
	category: 'Positioning' environmentId: 0 .
selector := (selector , ':') asSymbol.
string := (self compiledMethodAt: selector) sourceString.
string := (string copyFrom: 1 to: 8) , (string copyFrom: 10 to: string size).
self
	compileMethod: string
	dictionaries: GsCurrentSession currentSession symbolList
	category: 'Positioning' environmentId: 0 .
^true.
%

! See Bug #39503 for some background. Customers can modify this global 
! to ensure that updates keep the expected behavior (whether legacy or ANSI)

run
Globals
	at: #'PositionableStream_position'
	ifAbsentPut: [(Globals includesKey: #'DbfHistory') 
		ifTrue:  [#'Legacy']	"this is a database upgrade so keep old behavior"
		ifFalse: [#'ANSI']		"this is a new database; switch to #'ANSI' in 3.0"
	].
PositionableStream compilePositionMethods.
%
