!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcBtreeBasicLeafNode, BtreeBasicLeafNode, BtreeLeafNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeBasicLeafNode
removeallclassmethods RcBtreeBasicLeafNode

category: 'For Documentation Installation only'
classmethod: RcBtreeBasicLeafNode
installDocumentation

self comment:
'A RcBtreeBasicLeafNode represents an exterior node of a B-tree for which a binary
search can be done for a key. Updates to instances of this class are logged and 
can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger' .
%

! ------------------- Class methods for RcBtreeBasicLeafNode
! ------------------- Instance methods for RcBtreeBasicLeafNode
category: 'Updating'
method: RcBtreeBasicLeafNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeBasicLeafNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeBasicLeafNode
btreeAt: aKey put: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := super at: aKey put: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
category: 'Constants'
method: RcBtreeBasicLeafNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeBasicInteriorNode
%
category: 'Removing'
method: RcBtreeBasicLeafNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeBasicLeafNode
removeKey: aKey value: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := super removeKey: aKey value: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
