!=========================================================================
! Copyright (C) GemTalk Systems 2010-2020.  All Rights Reserved.
!
! $Id: AbstractException2.gs $
!
!=========================================================================

! fix 41428
category: 'Private'
method: AbstractException
_errNumPrefix
  ^ '(error '
%

method: AbstractException
_description: subclassDetails

  "Create the full GemStone message text if needed, 
   save it in messageText instVar , and return it.
   Should be invoked by #description in a subclass. "

  messageText ifNotNil:[ :s | ^ s ].
  ^ [ | str num |
      (str := String withAll:'a ') add: self class name ; add: ' occurred ' .
      str add: self _errNumPrefix , (num := gsNumber) asString ; add: $) . 
      gsReason ifNotNil:[ :r| str add:', reason:' ; add: r asString ].
      subclassDetails ifNotNil:[
        "details instVar already included in subclassDetails if desired"
         str add:', '; add: subclassDetails .
      ] ifNil:[ | d |
        (d := gsDetails) ifNil:[
          d := (LegacyErrNumMap atOrNil: num) ifNotNil:[:m | m atOrNil: 3].
        ].
        d ifNotNil:[ 
          d _isArray ifTrue:[ "details is a legacy message template"
            str add:', ' ; add: (self _legacyDetails: d).
          ] ifFalse:[
            str add:', ' ; add: d asString "ANSI details" .
          ]
        ].
      ].
      messageText := str .
      str
    ] onException: Error do:[ :ex | | s |
      s := 'error during Exception>>description'.
      [  
        messageText := s 
      ] onSynchronous: AbstractException do:[ :exB | 
        exB return "ignore errors during assignment"
      ].
      ex return: s
    ].
% 

classmethod: AbstractException
legacyNumberToClasses: aSmallInt
  "returns nil , a Class or an Array of Classes"
  |arr|
  arr := LegacyErrNumMap atOrNil: aSmallInt .
  "arr is { aClass . aReasonString . legacyTemplateStringOrNil }
      or { firstClass . aReasonString . legacyTemplateStringOrNil.
                { list of split classes...} } 
      per code in errordict.gs "

  arr ifNotNil:[ 
    (arr atOrNil: 4) ifNotNil:[ :arrayOfClasses | ^ arrayOfClasses] .
    ^ arr atOrNil:1  "a single class"
  ].
  ^ nil
%

classmethod: AbstractException
legacyNumberToClass: aSmallInt
  "returns a Class"
  |arr|
  arr := LegacyErrNumMap atOrNil: aSmallInt .
  "arr is { aClass . aReasonString . legacyTemplateStringOrNil }
      or { firstClass . aReasonString . legacyTemplateStringOrNil.
                { list of split classes...} } 
      per code in errordict.gs "

  arr ifNotNil:[ 
    ^ (arr atOrNil:1 ) ifNil:[ Error ].
  ].
  ^ Error 
%

! v3.0.1 more careful checking of gsNumber
method: AbstractException
_matchesExpectedLegacyNumber: aSmallInt
  "used by topaz EXPECTERROR command, returns true if 
   receiver is one of the classes produced by specified error number,
   false otherwise. "
^ [ | arr |
    (arr := LegacyErrNumMap atOrNil: aSmallInt) ifNil:[ ^ false ]. 
    (arr atOrNil: 4) ifNotNil:[ :inner | 
      (arr atOrNil: 1) ifNotNil:[ :c | (self isKindOf: c) ifTrue:[ ^ true ]].
      inner do:[:aClass | (self isKindOf: aClass) ifTrue:[ ^ true ]]
    ].
    (arr atOrNil: 1) ifNotNil:[ :c | 
       ^ (self isKindOf: c) and: [ self gsNumber == aSmallInt ]
    ].
    false
  ] onException: Error do:[:ex | ex return: false ]
%


! fixed 41414 , 41409 , 41814 , 45626
method: CompileError
asString
  | str |  
  str := String new .
  self errorDetails: str . "ensure error details are are populated"
  ^ self _description: str
%
method: CompileError
errorDetails
  ^ self errorDetails: nil
%
method: CompileError
errorDetails: resStr
  "Fill in the error message for each element of the error details,
   as a side effect of returning the error details. 
   Append the text of each element to non-nil resStr ."
  gsArgs ifNotNil:[ :arr |
    (arr atOrNil: 1) ifNotNil:[ :errorArrays | | numErrs n |
       numErrs := errorArrays size .
       n := 1 .
       [ n <= numErrs ] whileTrue:[ | anErr msg |
         anErr := errorArrays at: n . 
         (msg := anErr atOrNil: 3) ifNil:[ "message not yet filled in" | errNum |
            (errNum := anErr atOrNil: 1 ) _isSmallInteger ifTrue:[ 
              msg := LegacyErrNumMap atOrNil: errNum .
              msg _isOneByteString ifFalse:[ msg := 'unknown compiler error'].
              anErr at: 3 put: msg .
            ]
          ] ifNotNil:[ "messages already filled in"
            resStr ifNil:[ n := numErrs "early exit" ]
          ].
          resStr ifNotNil:[
            n > 1 ifTrue:[ resStr add:'; ' ].
            resStr add: msg ; add: $  .
            (anErr atOrNil: 4) ifNotNil:[:v | resStr add: $  ; add: v ].
            (anErr atOrNil: 5) ifNotNil:[:v | resStr add: $  ; add: v ].
          ].
          n := n + 1 .
       ].
       ^ errorArrays
    ].
  ].
  ^ { { 1075"STDB_MALFORMED_COMPILER_ERROR" . 1 . 'malformed CompilerError'  } }
%

method: CompileError
gsArguments
  | ed |
  ed := self errorDetails "ensure error details are populated" .
  ^ gsArgs ifNil:[ { ed . nil"no source string" } ].
%

category: 'Formatting'
method: Error
asString
^ self _description:(
  [ | str nArgs d |
    d := (LegacyErrNumMap atOrNil: gsNumber) ifNotNil:[:m | m atOrNil: 3].
    d ifNil:[  "no legacy error formatting, get generic details"
      1 to: (nArgs := gsArgs size)  do:[:n | | elem |
        str ifNil:[ str := String new ].
        elem := gsArgs atOrNil: n .
        (elem _isSymbol or:[ elem _isOneByteString]) ifTrue:[ str add: elem ]
           ifFalse:[  elem _isSmallInteger ifTrue:[ str add: elem asString ]
              ifFalse:[ str add: 'a ' ; add: elem class name ]].
        n < nArgs ifTrue:[ str add: ', ' ]
      ].
      gsDetails ifNotNil:[ :x | 
        str ifNil:[ str := String new ].
        str add:', '; add: x  asString 
      ].
    ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)
%

