!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   BitSet, Object.
!
!=========================================================================
removeallmethods BitSet
removeallclassmethods BitSet

category: 'Documentation'
classmethod: 
comment
^ 
'A BitSet is an array of bits , with a maximum size of  130144 bits.
 BitSets will grow as needed up to the maximum size, to accomodate 
 bits being set. 
 Usage requiring a set bigger than 130144 elements should use
 an IdentitySet, or hidden sets in class System.
' 
%

category: 'Instance creation'
classmethod:
new: numberOfBits
  "allocated size is always a multiple of 4 bytes, 
   all bits in the result are set to zero."

^ super new: ((numberOfBits + 31) // 32) * 4
%


category: 'Accessing'
method:
size

"return the allocated size in bits"

^ super size * 8
%

method:
at: offset
"Return the specified bit, result is 0 or 1.
 offset is a zero-based SmallInteger, 
 0 specifies the least significant bit.  
 offset < 0 generates an error. 
 0 is returned for any offset > allocated size. "
 
<primitive: 748>
offset _validateClass: SmallInteger.
offset < 0 ifTrue:[ offset _error: #errArgTooSmall args:{ 0 } ].
self _primitiveFailed: #at: args: { offset }
%

method:
countBits
"return the number of bits set in the receiver"

<primitive: 749>
self _primitiveFailed: #countBits
%

category: 'Updating'
method:
clear
  "set all bits in receiver to zero, returns receiver.
   does not change allocated size of receiver."
<primitive: 750>
self _primitiveFailed: #clear
%

method:
at: offset put: aValue

"offset is zero-based, 0 specifies the least significant bit.
 aValue must be 0 or 1 .  
 Returns previous state of the specified bit. "

<primitive: 751>
offset _validateClass: SmallInteger.
offset < 0 ifTrue:[ offset _error: #errArgTooSmall args:{ 0 } ].
(aValue == 0 or:[ aValue == 1]) ifFalse:[ 
  aValue _error: #rtErrArgOutOfRange args:{ 0 . 1 } ].
self _primitiveFailed: #at:put: args: { offset . aValue }
%


method:
bitAnd: aBitSet

"clear bits in the receiver which are not also set in the argument.
 aBitSet must be an instance of the class of the receiver. 
 Returns receiver. "

<primitive: 752>
aBitSet _validateInstanceOf: self class .
self _primitiveFailed: #bitAnd: args: { aBitSet }
%

method:
bitOr: aBitSet

"Set bits in the receiver that are set in the argument
 Grows receiver as needed.
 aBitSet must be an instance of the class of the receiver.
 Returns receiver. "

<primitive: 753>
aBitSet _validateInstanceOf: self class .
self _primitiveFailed: #bitOr: args: { aBitSet }
%

method:
bitXor: aBitSet
"Sets receiver to be the exclusive-or of the receiver with argument.
 Grows receiver as needed. 
 aBitSet must be an instance of the class of the receiver.
 Returns receiver."
<primitive: 754>
aBitSet _validateInstanceOf: self class .
self _primitiveFailed: #bitXor: args: { aBitSet }
%

method:
bitInvert
"Inverts the  bits of the receiver."

<primitive: 755>
self _primitiveFailed: #bitInvert
%

method:
size: numberOfBits

 "change the allocated size. allocated size is always a multiple of 4 bytes,
  rounded up from the specifed size.
  If the new size is larger than current size, 
   newly allocated bits will be set to zero."
 
super size: ((numberOfBits + 31) // 32) * 4
%

