! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
! ========================================================================

run
"Remove old versions of some classes so old code not kept alive by class history."
#( #CPreprocessorToken #CPreprocessor ) do:[:sym |
    Globals removeKey: sym ifAbsent:[ GsFile gciLogServer: sym , ' not found' ]
].
true
% 

! ------------------- Class definition 
expectvalue /Class
doit
ReadStreamPortable subclass: 'CPreprocessorStream'
  instVarNames: #( file line cppArchMType )
  classVars: #( )
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()

%
expectvalue /Class
doit
CPreprocessorStream comment: 

'This class is internal to the FFI implementation and 
implements a stream that can track file names and line numbers from 
debug info emitted by /usr/bin/cpp, and parsed by a CPreprocessor.
Instance variables
  file  a String,  path to a file.
  line  a SmallInteger , a line number .
  cppArchMType  nil or a SmallInteger .
'
%
expectvalue /Class
doit
CPreprocessorStream category: 'FFI'
%
! ------------------- Remove existing behavior from
expectvalue /Metaclass3       
doit
CPreprocessorStream removeAllMethods.
CPreprocessorStream class removeAllMethods.
%
set compile_env: 0
set class CPreprocessorStream
! ------------------- Class methods 

! ------------------- Instance methods 
category: 'Accessing'
method:
line
  ^ line
%
method:
file
  "Returns a String, a file name"
  ^ file
%
method:
cppArchMType
  ^ cppArchMType
%
method:
line: aLineNumber
  line := aLineNumber
%
method:
file: aFileName
  file := aFileName
%
method:
cppArchMType: aSmallInt
  cppArchMType := aSmallInt
%

