! Gs64 v3.4 ,  CompileWarning create in bom.c , else exists in previous version

removeallmethods CompileWarning
removeallclassmethods CompileWarning
set class CompileWarning

category: 'Documentation'
classmethod: 
comment
^'CompileWarning is a Warning (Notification) signaled when a warning
is found during the compiling of a method or expression. Developer
tools might handle this Exception and report the warning to the user.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object'
%

! CompileWarning inherits defaultAction from Warning 
classmethod:
signal: aString method: aMethod
  | ex |
  (ex := self new) args: { aString . aMethod } ;
     signal
%
method:
method
  ^ gsArgs at: 2 
%
method:
warningString
  ^ gsArgs at: 1
%

method: 
asString
^ self _description:(
  [ | str |
    str := String new .
    gsArgs ifNotNil:[:d| | meth cls |
      meth := d at: 2 .
      str add: 'Warning ' ; add:( d at: 1) ; add: ' in ' .
      cls := meth inClass .
      str add: cls name .
      cls isMeta ifTrue:[ str add: ' class' ].
      str add: ' >> ' ; add: meth selector .
    ].
    str 
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)
%
category: 'Instance initialization'
method:
initialize
  gsNumber := ERR_CompileWarning .
  gsResumable := true .
  gsTrappable := true .
%
