! ========================================================================
! GsX509ExternalSession.gs
!
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
! ========================================================================


! Provide placeholders for references to classes that cannot be generated yet.
! (The classes will be generated during the "bomlastconv.gs" phase.
doit
	Globals
		at: #GciLibrary
			ifAbsentPut: [nil];
		at: #GciErrSType
			ifAbsentPut: [nil]. 
	^true
%

expectvalue %String
doit
GsExternalSession _newKernelSubclass: 'GsX509ExternalSession'
	instVarNames: #(username)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #()
	reservedOop: nil
%

! ------------------- Class comment for GsX509ExternalSession
doit
GsX509ExternalSession comment: 
'GsX509ExternalSession is a variant of GsExternalSession which uses an X509 certificate as
login credentials rather than a user id and password.

Example:

| p s |
p := GemStoneX509Parameters
      newFromPemFilesWithNetldiPort: ''54321''
      netldiHost: ''localhost''
      certificate: ''DataCurator.chain.pem''
      caCertificate: ''stoneCA-gs64stone.cert.pem''
      privateKey: ''DataCurator.privkey.pem'' .
s := GsX509ExternalSession newWithX509Parameters: p.
s login .

'.
true
%

doit
GsX509ExternalSession category: 'X509'.
true
%

! Remove existing behavior from GsX509ExternalSession
doit
GsX509ExternalSession removeAllMethods.
GsX509ExternalSession class removeAllMethods.
true
%
! ------------------- Class methods for GsX509ExternalSession


category: 'Instance Creation'
classmethod: GsX509ExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: aUsername password: aPassword

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:
%

category: 'Instance Creation'
classmethod: GsX509ExternalSession
newWithX509Parameters: aGemStoneX509Parameters

self gciLibrary .
^ self new initializeWithX509Parameters: aGemStoneX509Parameters
%

category: 'Instance Creation'
classmethod: GsX509ExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: gsUsername password: gsPassword hostUsername: hostUsername hostPassword: hostPassword

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:hostUsername:hostPassword:
%

category: 'Instance Creation'
classmethod: GsX509ExternalSession
newDefault

self shouldNotImplement: #newDefault
%

! ------------------- Instance methods for GsX509ExternalSession
category: 'Parameters'
method: GsX509ExternalSession
gemNRS: anNRS

  self shouldNotImplement: #gemNRS:
%
category: 'Parameters'
method: GsX509ExternalSession
hostPassword: aString

  self shouldNotImplement: #hostPassword:
%
category: 'Parameters'
method: GsX509ExternalSession
hostUsername: aString

  self shouldNotImplement: #hostUsername:
%
category: 'Private'
method: GsX509ExternalSession
initialize

^ self initializeWithX509Parameters: GemStoneX509Parameters new
%

category: 'Private'
method: GsX509ExternalSession
initializeWithX509Parameters: aGemStoneX509Parameters

	gciErrSType := self class gciErrSTypeClass new.
	parameters := aGemStoneX509Parameters .
	self loggingToServer.
%

category: 'Private'
method: GsX509ExternalSession
initializeDefaultResources

self shouldNotImplement: #initializeDefaultResources
%

category: 'Private'
method: GsX509ExternalSession
_gemHost

^ parameters netldiHost
%

! fix 47319, set username
category: 'Public'
method: GsX509ExternalSession
login

	| result lib |
	stoneSessionId ifNotNil: [
		ImproperOperation signal: 'Stone session ' , stoneSessionId printString , 
			' already associated with this GsX509ExternalSession!'.
	].
  lib := self _gciLibrary .	
	result := lib GciX509Login_: parameters asGciX509LoginArg .
	0 == result ifTrue: [
    self _signalIfError: lib .
		self error: 'Login failed for unknown reason!'.
	].
	gciSessionId := lib GciGetSessionId.
  self _postLogin: lib .
  username := self executeString:'System myUserProfile userId' .
	self log: 'GsX509ExternalSession login: ' , self _describe.
%


category: 'Parameters'
method: GsX509ExternalSession
password: aString
  self shouldNotImplement: #password:
%

category: 'Parameters'
method: GsX509ExternalSession
stoneNRS: anNRS

  self shouldNotImplement: #stoneNRS:
%
category: 'Parameters'
method: GsX509ExternalSession
username: aString

 self shouldNotImplement: #username:
%

category: 'Parameters'
method: GsX509ExternalSession
username
  ^ username
%
