set compile_env: 0
! ------------------- Class definition for JsonParser
expectvalue /Class
doit
PPCompositeParser subclass: 'JsonParser'
  instVarNames: #( array character element
                    elements escape exp frac
                    int json member members
                    number object sign string
                    value)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()

%
expectvalue /Class
doit
JsonParser comment: 
'https://www.json.org/

json
    element

value
    object
    array
    string
    number
    "true"
    "false"
    "null"

object
    ''{'' ws ''}''
    ''{'' members ''}''

members
    member
    member '','' members

member
    ws string ws '':'' element

array
    ''['' ws '']''
    ''['' elements '']''

elements
    element
    element '','' elements

element
    ws value ws

string
    ''"'' characters ''"''

characters
    ""
    character characters

character
    ''0020'' . ''10ffff'' - ''"'' - ''\''
    ''\'' escape

escape
    ''"''
    ''\''
    ''/''
    ''b''
    ''n''
    ''r''
    ''t''
    ''u'' hex hex hex hex

hex
    digit
    ''A'' . ''F''
    ''a'' . ''f''

number
    int frac exp

int
    digit
    onenine digits
    ''-'' digit
    ''-'' onenine digits

digits
    digit
    digit digits

digit
    ''0''
    onenine

onenine
    ''1'' . ''9''

frac
    ""
    ''.'' digits

exp
    ""
    ''E'' sign digits
    ''e'' sign digits

sign
    ""
    ''+''
    ''-''

ws
    ""
    ''0009'' ws
    ''000a'' ws
    ''000d'' ws
    ''0020'' ws'
%
expectvalue /Class
doit
JsonParser category: 'Kernel'
%
! ------------------- Remove existing behavior from JsonParser
expectvalue /Metaclass3       
doit
JsonParser removeAllMethods.
JsonParser class removeAllMethods.
%
set compile_env: 0
! ------------------- Class methods for JsonParser
! ------------------- Instance methods for JsonParser
category: 'other'
method: JsonParser
array

	^((	$[ asParser , #space asParser star , $] asParser) 	==> [:tokens | #()])
	| ((	$[ asParser , elements , $] asParser) 					==> [:tokens | tokens at: 2])
%
category: 'other'
method: JsonParser
character

	^(($\ asParser , escape) 											==> [:tokens | tokens at: 2])
	| (($" asParser not , $\ asParser not , #any asParser) 	==> [:tokens | tokens at: 3])
%
category: 'other'
method: JsonParser
element

	^value trim
%
category: 'other'
method: JsonParser
elements

	^(element , ($, asParser , elements) star) ==> [:tokens | 
		(tokens at: 2) isEmpty
			ifTrue: [Array with: (tokens at: 1)]
			ifFalse: [(Array with: (tokens at: 1)) , (((tokens at: 2) at: 1) at: 2)]]
%
category: 'other'
method: JsonParser
escape

	^$" asParser
	| $\ asParser
	| $/ asParser
	| ($b asParser ==> [:tokens | Character codePoint: 8])
	| ($n asParser ==> [:tokens | Character lf])
	| ($r asParser ==> [:tokens | Character cr])
	| ($t asParser ==> [:tokens | Character tab])
	| (($u asParser , (#hex asParser times: 4) flatten) ==> [:tokens | Character codePoint: ('16r' , (tokens at: 2)) asNumber])
%
category: 'other'
method: JsonParser
exp

	^(($E asParser | $e asParser) , sign optional , #digit asParser plus) flatten
%
category: 'other'
method: JsonParser
frac

	^($. asParser , #digit asParser plus flatten) ==> [:tokens | '.' , tokens last]
%
category: 'other'
method: JsonParser
int

	^(sign optional , #digit asParser plus) flatten
%
category: 'other'
method: JsonParser
json

	^element
%
category: 'other'
method: JsonParser
member

	^(string trim , $: asParser , element) ==> [:tokens | (tokens at: 1) -> (tokens at: 3)]
%
category: 'other'
method: JsonParser
members

	^(member , ($, asParser , members) star) ==> [:tokens | 
		| assoc more |
		assoc := tokens at: 1.
		more := tokens at: 2.
		more isEmpty ifTrue: [
			Dictionary with: assoc
		] ifFalse: [
			((more at: 1) at: 2)	"ignore the comma"
				add: assoc;
				yourself.
		].
	]
%
category: 'other'
method: JsonParser
number

	^(int , frac optional , exp optional) ==> [:tokens | ((tokens at: 1) , ((tokens at: 2) ifNil: ['']) , ((tokens at: 3) ifNil: [''])) asNumber]
%
category: 'other'
method: JsonParser
object

	^((	${ asParser , #space asParser star , $} asParser) 	==> [:tokens | Dictionary new])
	| ((	${ asParser , members , $} asParser) 					==> [:tokens | tokens at: 2])
%
category: 'other'
method: JsonParser
sign

	^$+ asParser
	| $- asParser
%
category: 'other'
method: JsonParser
start

	^json
%
category: 'other'
method: JsonParser
string

	^($" asParser , character star , $" asParser) ==> [:tokens | String withAll: (tokens at: 2)]
%
category: 'other'
method: JsonParser
value

	^(array
	| object
	| string
	| ('true' asParser ==> [:tokens | true])
	| ('false' asParser ==> [:tokens | false])
	| ('null' asParser ==> [:tokens | nil])
	| number) memoized
%

