!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: SortBlockNode.gs 38383 2016-01-08 18:22:35Z lalmarod $
!
! Superclass Hierarchy:
!   SortBlockUnicodeNode, SortBlockNode, 
!   BtreeLeafNode, BtreeNode, Array, SequenceableCollection, Collection,
!   Object.
!
!=========================================================================

expectvalue %String
run
| oldCls newCls |
oldCls := Globals at:#SortBlockUnicodeNode otherwise: nil .
oldCls ifNil:[
  SortBlockNode _newKernelSubclass: 'SortBlockUnicodeNode'
    instVarNames: #( #collator )
    classVars: #()
    classInstVars: #()
    poolDictionaries: #()
    inDictionary: Globals
        options: #() 
    reservedOop: nil.
  newCls := (Globals at:#SortBlockUnicodeNode) .
  ^ 'created new class: ' , newCls definition
] ifNotNil:[
  ^ 'existing class: ' , oldCls definition
]
%

! Remove existing behavior 

set class SortBlockUnicodeNode
removeallmethods 
removeallclassmethods 

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'SortBlockUnicodeNode is a concrete class that along with the class BlockSorter implements the 
 behavior used to sort collections efficiently. It is an interface to an algorithm based 
 on an efficient merge-sort.

Constraints:
	numElements: SmallInteger
	blockSorter: Object
	totalElements: Object'.
%

category: 'Updating'
method:
blockSorter: aBlockSorter collator: anIcuCollator

blockSorter := aBlockSorter .
collator := anIcuCollator
%

category: 'Comparison Operators'
method:
_compareEntryAt: index1
lessThanNode: aNode
entryAt: index2
useValue: aBoolean

"Perform a < comparison between the entries at the given indexes.
 The default implementation uses no encryption."

| o1 o2 blk |
" first compare the keys "
((blk := blockSorter sortBlock) value: (o1 := self _at: index1)  
                               value: (o2 := aNode _at: index2) value: collator)
   ifTrue: [ ^ true ]
   ifFalse: [
      " if using the values and keys are equal, use the OOP of the value "
      (blk value: o2  value: o1 value: collator ) 
        ifFalse: [ ^ (self _at: index1 - 1) identityHash < (aNode _at: index2 - 1) identityHash ]
        ifTrue: [ ^ false ]
     ]
%
category: 'Comparison Operators'
method:
_compareKey: aKey greaterThanEntryAt: index

  ^ blockSorter sortBlock value: (self _at: index) value: aKey value: collator
%
category: 'Comparison Operators'
method:
_compareKey: aKey lessThanEntryAt: index

  ^ blockSorter sortBlock value: aKey value: (self _at: index) value: collator
%
category: 'Updating'
method:
_insertDuplicateKey: aKey value: aValue atIndex: insertionIndex
  "The given key is already present in the receiver, so insert the entry
 in a secondary sort node (creating it if necessary)."

  | val newNode sortArray |
  " get the existing value "
  val := self _at: insertionIndex.
  val class == SortNodeArray
    ifTrue: [ 
      " value is already sort nodes on the secondary sort path "
      blockSorter _addObject: aValue inNodes: val ]
    ifFalse: [ 
      " create sort node for the secondary sort path and put it in a sort Array "
      newNode := blockSorter sortNodeClassForSort new: self sizeForSecondarySorts.
      newNode blockSorter: blockSorter collator: collator .
      sortArray := SortNodeArray with: newNode .
      self _basicAt: insertionIndex put: sortArray.
      blockSorter _addObject: aValue inNodes: sortArray.
      blockSorter _addObject: val inNodes: sortArray ]
%
