expectvalue /String
run
(SequenceableCollection byteSubclass: 'Uint16Array'
  classVars:#() classInstVars:#() poolDictionaries:#() inDictionary: Globals
  options: #( #'2byteWords' ) ) definition
%

set class Uint16Array
removeallmethods
removeallclassmethods

category: 'For Documentation Installation only'
classmethod:
installDocumentation
 
self comment:
'Instances of Uint16Array are byte format arrays that store 16 bit unsigned integers.
For an instance loaded into memory, the integers are in machine native byte order.'
%

category: 'Instance Creation'
classmethod:
new: aSize

^ self _basicNew:  aSize * 2
%

category: 'Accessing'
method:
size

"Returns the number of elements in the receiver."

^ self _basicSize // 2.
%

category: 'Updating'
method: 
size: anInteger

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to zero."

^ super _basicSize: 2 * anInteger 
%

!same primitives as DoubleByteString >> codePointAt: , codePointAt:put:
category: 'Accessing'
method: 
at: anOffset

"Returns a 16 bit unsigned integer as a SmallInteger."

<primitive: 1072>
(anOffset _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anOffset]
  ifFalse: [^ self _errorNonIntegerIndex: anOffset].
^ self _primitiveFailed: #at: args: { anOffset } .
%

category: 'Updating'
method:
at: anOffset put: aValue

"aValue must be a SmallInteger representable as a 16bit unsigned integer.
 returns aValue ."

<primitive: 1074>
aValue _validateClass: SmallInteger .
(aValue < 0 or:[ aValue > 65535]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ 0 . 65535 }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #at:put: args: { anOffset . aValue }
%


!-----------------------------------------------
expectvalue /String
run
(SequenceableCollection byteSubclass: 'Uint32Array'
  classVars:#() classInstVars:#() poolDictionaries:#() inDictionary: Globals
  options: #( #'4byteWords' ) ) definition
%

set class Uint32Array
removeallmethods
removeallclassmethods

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'Instances of Uint32Array are byte format arrays that store 32 bit unsigned integers.
For an instance loaded into memory, the integers are in machine native byte order.'
%

category: 'Instance Creation'
classmethod:
new: aSize

^ self _basicNew:  aSize * 4
%

category: 'Accessing'
method:
size

"Returns the number of elements in the receiver."

^ self _basicSize // 4.
%

category: 'Updating'
method: 
size: anInteger

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to zero."

^ super _basicSize: 4 * anInteger 
%

! same primitive as QuadByteString >> at:
category: 'Accessing'
method: 
at: anOffset 

"Returns a 32bit unsigned value as a SmallInteger."

<primitive: 1073>
(anOffset _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anOffset]
  ifFalse: [^ self _errorNonIntegerIndex: anOffset].
^ self _primitiveFailed: #at: args: { anOffset } .
%

category: 'Updating'
method:
at: anOffset put: aValue

"aValue must be a SmallInteger representable as a 32bit unsigned integer.
 returns aValue ."

<primitive: 1075>
aValue _validateClass: SmallInteger .
(aValue < 0 or:[ aValue > 4294967295]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ 0 . 4294967295 }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #codePointAt:put: args: { anOffset . aValue }
%


!----------------------------------------------- 
expectvalue /String
run
(SequenceableCollection byteSubclass: 'Uint64Array'
  classVars:#() classInstVars:#() poolDictionaries:#() inDictionary: Globals
  options: #( #'8byteWords' ) ) definition
%

set class Uint64Array
removeallmethods
removeallclassmethods

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'Instances of Uint64Array are byte format arrays that store 64 bit unsigned integers.
For an instance loaded into memory, the integers are in machine native byte order.'
%

category: 'Instance Creation'
classmethod:
new: aSize

^ self _basicNew:  aSize * 8
%

category: 'Accessing'
method:
size

"Returns the number of elements in the receiver."

^ self _basicSize // 8.
%

category: 'Updating'
method: 
size: anInteger

"Changes the size of the receiver to anInteger.

 If anInteger is less than the current size of the receiver, the receiver is
 shrunk accordingly.  If anInteger is greater than the current size of the
 receiver, the receiver is extended and new elements are initialized to zero."

^ super _basicSize: 8 * anInteger 
%

category: 'Accessing'
method: 
at: anOffset 

"Returns an Integer containing a 64bit unsigned value."

<primitive: 1076>
(anOffset _isSmallInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anOffset]
  ifFalse: [^ self _errorNonIntegerIndex: anOffset].
^ self _primitiveFailed: #at: args: { anOffset } .
%

category: 'Updating'
method:
at: anOffset put: aValue

"aValue must be an Integer representable as a 64bit unsigned integer.
 returns aValue ."

<primitive: 1077>
| max |
max := 18446744073709551615 .
aValue _validateClass: Integer .
(aValue < 0 or:[ aValue > max ]) ifTrue:[
  aValue _error: #rtErrArgOutOfRange args:{ 0 . max }
].
(anOffset _isSmallInteger) ifTrue: [
  ((anOffset > (self size + 1)) or: [anOffset < 1]) ifTrue: [
    ^ self _errorIndexOutOfRange: anOffset
  ]
] ifFalse: [
  ^ self _errorNonIntegerIndex: anOffset
] .
self _primitiveFailed: #codePointAt:put: args: { anOffset . aValue }
%

!-----------------------------------------------------
expectvalue /String
run
(Uint64Array byteSubclass: 'Int64Array'
  classVars:#() classInstVars:#() poolDictionaries:#() inDictionary: Globals
  options: #( #'signed8byteWords' ) ) definition
%
set class Int64Array
removeallmethods
removeallclassmethods

category: 'For Documentation Installation only'
classmethod:
installDocumentation
 
self comment:
'Instances of Int64Array are byte format arrays that store 64 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.'
%
!-----------------------------------------------------
expectvalue /String

run
(Uint32Array byteSubclass: 'Int32Array'
  classVars:#() classInstVars:#() poolDictionaries:#() inDictionary: Globals
  options: #( #'signed4byteWords' ) ) definition
%
set class Int32Array
removeallmethods
removeallclassmethods

category: 'For Documentation Installation only'
classmethod:
installDocumentation
 
self comment:
'Instances of Int32Array are byte format arrays that store 32 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.'
%
!-----------------------------------------------------
expectvalue /String
run
(Uint16Array byteSubclass: 'Int16Array'
  classVars:#() classInstVars:#() poolDictionaries:#() inDictionary: Globals
  options: #( #'signed2byteWords' ) ) definition
%
set class Int16Array
removeallmethods
removeallclassmethods

category: 'For Documentation Installation only'
classmethod:
installDocumentation
 
self comment:
'Instances of Int16Array are byte format arrays that store 16 bit signed integers.
For an instance loaded into memory, the integers are in machine native byte order.'
%

