!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class ZeroDivide

! no removeall 
! ZeroDivide>>initialize is in Exception.gs

category: 'For Documentation Installation only'
classmethod: 
installDocumentation

self comment:
'An instances of ZeroDivide is signalled when a division by zero
occurs,  and the division is not a floating point division.
See FloatingPointError for floating point divide by zero semantics.
Zero divide exceptions are resumable so any message in this 
protocol that signal such an exception may ultimately return to their 
sender. '
%

! -----------------------------------------
category: 'Instance creation'
classmethod: 
dividend: argument
	"Signal the occurrence of a division by zero exception. Capture the number
	that was being divided such that it is available from the 'signaled exception.'

	If the message #dividend is subsequently sent to the <ZeroDivide> object
	that is the 'signaled exception' the value of 'argument' is returned."

	argument / 0.
%

classmethod: 
signal

	0 / 0.
%

! -----------------------------------------
category: 'Accessing'
method: 
dividend

	^ dividend
%

method: 
dividend: aNumber

  dividend := aNumber
%

! fixed 41582
method: 
asString
^ self _description: 
   'attempt to divide ' , dividend asString , ' by zero' 
%
