!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   CollisionBucket, AbstractCollisionBucket, Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods CollisionBucket
removeallclassmethods CollisionBucket

category: 'For Documentation Installation only'
classmethod: CollisionBucket
installDocumentation

self comment:
'A CollisionBucket is an Array that is used in a KeyValueDictionary to store
 a collection of key/value pairs for which the keys hash to the same value.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object

instvar keyValueDictionary -- An AbstractDictionary.  For GemStone internal use.' .

%

category 'Accessing'
method: CollisionBucket
keyValueDictionary

"Returns the value of the instance variable."

^keyValueDictionary
%

category 'Updating'
method: CollisionBucket
keyValueDictionary: aDict

"Updates the value of the keyValueDictionary instance variable."

keyValueDictionary := aDict
%

category: 'Private'
method: CollisionBucket
_removeAll

"Dereferences the receiver from its parent and shrinks the receiver.
 Used while rebuilding a KeyValueDictionary."

keyValueDictionary := nil.
numElements := 0.
"gs64 v3.0 don't send  size: 0"
%

category: 'Searching'
method: CollisionBucket
_firstPair

"Returns an Array containing the receiver's first key/value pair.
 If the receiver is empty, returns an Array containing nils."

   numElements == 0 ifFalse: [  | idx |
      idx := 1 .
      "Search for the first non-nil key"
      1 to: self tableSize do: [ :n | | aKey |
         (aKey := self _at: idx ) ifNotNil: [    "inline keyAt:"
            ^ { aKey . (self _at: idx + 1) }
         ].
         idx := idx + 2
      ]
   ].
   ^ { nil . nil } "No first pair was found"
%

category: 'Private'
method: CollisionBucket
_removePairAt: anOffset

(self _at: anOffset)  ifNil:[
  ^ Error signal:'key has already been removed'.
]. 
self _at: anOffset put: nil ; 
     _at: anOffset + 1 put: nil .
numElements := numElements - 1 .
%

category: 'Repository Conversion'
method: CollisionBucket
fixRefsAfterConversion

"Default method for fixing references to ObsLargePositiveInteger
 and ObsLargeNegativeInteger instances that can now be represented
 as a SmallInteger and Floats and SmallFloats which can now be
 represented as a SmallDouble.  For collision buckets, we send
 the message to our parent Dictionary and let him do the fix up."

|dict result convBm |
convBm := (GsBitmap newForHiddenSet: #Conversion).
(convBm includes: self)
        ifTrue:[^false]. "already fixed this one"
dict := self keyValueDictionary.
result := false.
dict ~~ nil
        ifTrue:[result := dict fixRefsAfterConversion].
convBm add: self.
^result
%

