!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   EUCSymbol, InvariantEUCString, EUCString, JapaneseString,
!   CharacterCollection, SequenceableCollection, Collection, Object.
!
!=========================================================================

removeallmethods EUCSymbol
removeallclassmethods EUCSymbol

category: 'For Documentation Installation only'
classmethod: EUCSymbol
installDocumentation

self comment:
'Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteSymbol/QuadByteSymbol.

 An EUCSymbol represents an invariant Japanese symbol in Extended Unix Code
 format. 

 EUCSymbols are not canonicalized like Symbol and DoubleByteSymbol.

 An EUCSymbol may not be used as a message selector, and may not be stored
 into an instance variable constrained to hold Symbols.'.
%

! removed isSymbol to fix 32218

! category: 'Formatting'
! method: EUCSymbol
! describe
! 
! "Describes the receiver as a literal symbol."
! 
! ^(EUCString withAll: '#') addAll: self
! %

category: 'Copying'
method: EUCSymbol
copyReplacing: oldObject withObject: newObject
	"Returns a String comprising a copy of the receiver in which all occurrences
	 of objects equal to oldObject have been replaced by newObject."

	^self asEUCString copyReplacing: oldObject withObject: newObject
%

category: 'Formatting'
method: EUCSymbol
printOn: aStream

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

| mySize |
(mySize := self size) == 0 ifTrue:[
  aStream nextPut: $# .
  aStream nextPut: $' .
  aStream nextPut: $' .
  ]
ifFalse:[
  "do it the efficient way for large Symbols"
  aStream nextPut: $# .
  super printOn: aStream 
  ]
%

! asSymbolKind deleted
