!=========================================================================
! Copyright (C) GemTalk Systems 2010-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class GsCompilerIRNode

category: 'Documentation'
classmethod: 
comment
^ '
 GsCompilerIRNode  is the abstract superclass of all classes used
 to implement nodes of the IR graph which is input to the
 bytecode generator comgen.c  in Gemstone64 v3.0. 

 In the Smalltalk product, instances may only be created
 by the method compilation primitive by code in comparse.c .
'
%

category: 'Instance creation'
classmethod: 
new
  self shouldNotImplement: #new
%
classmethod: 
new: aSize
  self shouldNotImplement: #new:
%
category: 'Instance creation'
classmethod: 
_basicNew
  self shouldNotImplement: #_basicNew
%
classmethod: 
_basicNew: aSize
  self shouldNotImplement: #_basicNew: 
%


