!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: identityindexspec.gs 19139 2008-05-30 23:48:14Z stever $
!
! Superclass Hierarchy:
!   IdentityIndexSpecification,
!   AbstractIndexSpecification,
!   Object.
!
!=========================================================================

! class created in idxclasses.topaz

! Remove existing behavior from IdentityIndexSpecification
doit
IdentityIndexSpecification removeAllMethods.
IdentityIndexSpecification class removeAllMethods.
true
%

! ------------------- Class methods for IdentityIndexSpecification
category: 'For Documentation Installation only'
classmethod: IdentityIndexSpecification
installDocumentation

self comment:
'The class IdentityIndexSpecification provides details for specifying an identity index.'.
%

category: 'instance creation'
classmethod: IdentityIndexSpecification
path: aString 

	^(self new)
		path: aString;
		yourself
%
category: 'instance creation'
classmethod: IdentityIndexSpecification
path: aString lastElementClass: aClass

	^ self shouldNotImplement: #path:lastElementClass: 
%
! ------------------- Instance methods for IdentityIndexSpecification
category: 'accessing'
method: IdentityIndexSpecification
indexType

	^#identity
%
category: 'accessing'
set compile_env: 0
method: IdentityIndexSpecification
removeIndexFrom: anNsc
  (self isIndexedOn: anNsc)
    ifTrue: [ anNsc removeIdentityIndexOn: self path ]
%

! delete IdentityIndexSpecification createIndexOn:

category: 'accessing'
set compile_env: 0
method: IdentityIndexSpecification
indexTypePrintString
  ^ 'identityIndex'
%
category: 'accessing'
set compile_env: 0
method: IdentityIndexSpecification
_createIndex
  | index |
  index := self identityIndexClass new.
  self legacyIndex
    ifFalse: [ index options: self options ].
  ^ index
%
category: 'accessing'
method: IdentityIndexSpecification
identityIndexClass
  ^ self legacyIndex
    ifTrue: [ IdentityIndex ]
    ifFalse: [ GsIdentityIndex ]
%
