category: '*gsmonticello'
classmethod: String
stringHash: aString initialHash: speciesHash
	| stringSize hash low |
	stringSize := aString size.
	hash := speciesHash bitAnd: 16rFFFFFFF.
	1 to: stringSize do: [:pos |
		hash := hash + (aString at: pos) asInteger.
		"Begin hashMultiply"
		low := hash bitAnd: 16383.
		hash := (16r260D * low + ((16r260D * (hash bitShift: -14) + (16r0065 * low) bitAnd: 16383) * 16384)) bitAnd: 16r0FFFFFFF.
	].
	^ hash
%

category: '*gsmonticello'
method: String
extractNumber
	^ ('0', self select: [:ea | ea isDigit]) asNumber
%

category: '*gsmonticello'
method: String
byteAt: index

    ^(self at: index) codePoint
%

category: '*gsmonticello'
method: String
byteAt: index put: aByte

    ^self at: index put: aByte asCharacter
%

category: '*gsmonticello'
method: String
match: aString
	"# and * are the special characters"
	| special pattern keyStart keyStop char |
	special := { $# . $* }.
	
	pattern := OrderedCollection new.	
	keyStart := keyStop := 1.
	[keyStop <= self size] whileTrue:
		[keyStop _ self findDelimiters: special startingAt: keyStart.
		keyStart <= keyStop
			ifTrue: [
				keyStart = keyStop
					ifTrue: [ keyStart := keyStart + 1 ]
					ifFalse: [ 
						pattern add: (self copyFrom: keyStart to: (keyStop - 1)).
						keyStart := keyStop + 1. ].
				(keyStop <= self size) 
					ifTrue: [
						char := self at: keyStop.
						char == $# ifTrue: [ char := $? ].
						pattern add: char ]]].
	^aString _matchPatternNoCase: pattern asArray
%
