!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcBtreeLeafNode, BtreeLeafNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeLeafNode
removeallclassmethods RcBtreeLeafNode

category: 'For Documentation Installation only'
classmethod: RcBtreeLeafNode
installDocumentation

self comment:
'A RcBtreeLeafNode represents an exterior node of a B-tree for which a binary
search can be done for a key. Updates to instances of this class are logged and 
can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger' .
%

! ------------------- Class methods for RcBtreeLeafNode
! ------------------- Instance methods for RcBtreeLeafNode
category: 'Updating'
method: RcBtreeLeafNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeLeafNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeLeafNode
btreeAt: aKey put: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := super at: aKey put: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
category: 'Constants'
method: RcBtreeLeafNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeInteriorNode
%
category: 'Removing'
method: RcBtreeLeafNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeLeafNode
removeKey: aKey value: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := super removeKey: aKey value: aValue.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
